/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.core.json;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonEncoding;
import tools.jackson.core.JsonParser;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.TokenStreamFactory;
import tools.jackson.core.exc.JacksonIOException;
import tools.jackson.core.io.IOContext;
import tools.jackson.core.io.MergedStream;
import tools.jackson.core.io.UTF32Reader;
import tools.jackson.core.json.ReaderBasedJsonParser;
import tools.jackson.core.json.UTF8StreamJsonParser;
import tools.jackson.core.sym.ByteQuadsCanonicalizer;
import tools.jackson.core.sym.CharsToNameCanonicalizer;
import tools.jackson.core.util.VersionUtil;

public final class ByteSourceJsonBootstrapper {
    public static final byte UTF8_BOM_1 = -17;
    public static final byte UTF8_BOM_2 = -69;
    public static final byte UTF8_BOM_3 = -65;
    private static final int STRING_READER_BYTE_ARRAY_LENGTH_LIMIT = 8192;
    private final IOContext _context;
    private final InputStream _in;
    private final byte[] _inputBuffer;
    private int _inputPtr;
    private int _inputEnd;
    private final boolean _bufferRecyclable;
    private boolean _bigEndian = true;
    private int _bytesPerChar;

    public ByteSourceJsonBootstrapper(IOContext ctxt, InputStream in) {
        this._context = ctxt;
        this._in = in;
        this._inputBuffer = ctxt.allocReadIOBuffer();
        this._inputPtr = 0;
        this._inputEnd = 0;
        this._bufferRecyclable = true;
    }

    public ByteSourceJsonBootstrapper(IOContext ctxt, byte[] inputBuffer, int inputStart, int inputLen) {
        this._context = ctxt;
        this._in = null;
        this._inputBuffer = inputBuffer;
        this._inputPtr = inputStart;
        this._inputEnd = inputStart + inputLen;
        this._bufferRecyclable = false;
    }

    public JsonEncoding detectEncoding() throws JacksonException {
        JsonEncoding enc;
        int i16;
        boolean foundEncoding = false;
        if (this.ensureLoaded(4)) {
            int quad = this._inputBuffer[this._inputPtr] << 24 | (this._inputBuffer[this._inputPtr + 1] & 0xFF) << 16 | (this._inputBuffer[this._inputPtr + 2] & 0xFF) << 8 | this._inputBuffer[this._inputPtr + 3] & 0xFF;
            if (this.handleBOM(quad)) {
                foundEncoding = true;
            } else if (this.checkUTF32(quad)) {
                foundEncoding = true;
            } else if (this.checkUTF16(quad >>> 16)) {
                foundEncoding = true;
            }
        } else if (this.ensureLoaded(2) && this.checkUTF16(i16 = (this._inputBuffer[this._inputPtr] & 0xFF) << 8 | this._inputBuffer[this._inputPtr + 1] & 0xFF)) {
            foundEncoding = true;
        }
        if (!foundEncoding) {
            enc = JsonEncoding.UTF8;
        } else {
            switch (this._bytesPerChar) {
                case 1: {
                    enc = JsonEncoding.UTF8;
                    break;
                }
                case 2: {
                    enc = this._bigEndian ? JsonEncoding.UTF16_BE : JsonEncoding.UTF16_LE;
                    break;
                }
                case 4: {
                    enc = this._bigEndian ? JsonEncoding.UTF32_BE : JsonEncoding.UTF32_LE;
                    break;
                }
                default: {
                    return (JsonEncoding)((Object)VersionUtil.throwInternalReturnAny());
                }
            }
        }
        this._context.setEncoding(enc);
        return enc;
    }

    public static int skipUTF8BOM(DataInput input) throws JacksonException {
        try {
            int b = input.readUnsignedByte();
            if (b != 239) {
                return b;
            }
            b = input.readUnsignedByte();
            if (b != 187) {
                throw new IOException("Unexpected byte 0x" + Integer.toHexString(b) + " following 0xEF; should get 0xBB as part of UTF-8 BOM");
            }
            b = input.readUnsignedByte();
            if (b != 191) {
                throw new IOException("Unexpected byte 0x" + Integer.toHexString(b) + " following 0xEF 0xBB; should get 0xBF as part of UTF-8 BOM");
            }
            return input.readUnsignedByte();
        }
        catch (IOException e) {
            throw ByteSourceJsonBootstrapper._wrapIOFailure(e);
        }
    }

    public Reader constructReader() throws JacksonException {
        JsonEncoding enc = this._context.getEncoding();
        switch (enc.bits()) {
            case 8: 
            case 16: {
                InputStream in = this._in;
                if (in == null) {
                    int length = this._inputEnd - this._inputPtr;
                    if (length <= 8192) {
                        try {
                            return new StringReader(new String(this._inputBuffer, this._inputPtr, length, enc.getJavaName()));
                        }
                        catch (IOException e) {
                            throw ByteSourceJsonBootstrapper._wrapIOFailure(e);
                        }
                    }
                    in = new ByteArrayInputStream(this._inputBuffer, this._inputPtr, this._inputEnd);
                } else if (this._inputPtr < this._inputEnd) {
                    in = new MergedStream(this._context, in, this._inputBuffer, this._inputPtr, this._inputEnd);
                }
                try {
                    return new InputStreamReader(in, enc.getJavaName());
                }
                catch (IOException e) {
                    throw ByteSourceJsonBootstrapper._wrapIOFailure(e);
                }
            }
            case 32: {
                boolean autoClose = true;
                return new UTF32Reader(this._context, this._in, true, this._inputBuffer, this._inputPtr, this._inputEnd, this._context.getEncoding().isBigEndian());
            }
        }
        return (Reader)VersionUtil.throwInternalReturnAny();
    }

    public JsonParser constructParser(ObjectReadContext readCtxt, int streamReadFeatures, int formatReadFeatures, ByteQuadsCanonicalizer rootByteSymbols, CharsToNameCanonicalizer rootCharSymbols, int factoryFeatures) throws JacksonException {
        int prevInputPtr = this._inputPtr;
        JsonEncoding enc = TokenStreamFactory.Feature.CHARSET_DETECTION.enabledIn(factoryFeatures) ? this.detectEncoding() : JsonEncoding.UTF8;
        int bytesProcessed = this._inputPtr - prevInputPtr;
        if (enc == JsonEncoding.UTF8 && TokenStreamFactory.Feature.CANONICALIZE_PROPERTY_NAMES.enabledIn(factoryFeatures)) {
            ByteQuadsCanonicalizer can = rootByteSymbols.makeChild(factoryFeatures);
            return new UTF8StreamJsonParser(readCtxt, this._context, streamReadFeatures, formatReadFeatures, this._in, can, this._inputBuffer, this._inputPtr, this._inputEnd, bytesProcessed, this._bufferRecyclable);
        }
        return new ReaderBasedJsonParser(readCtxt, this._context, streamReadFeatures, formatReadFeatures, this.constructReader(), rootCharSymbols.makeChild());
    }

    private boolean handleBOM(int quad) throws JacksonException {
        switch (quad) {
            case 65279: {
                this._bigEndian = true;
                this._inputPtr += 4;
                this._bytesPerChar = 4;
                return true;
            }
            case -131072: {
                this._inputPtr += 4;
                this._bytesPerChar = 4;
                this._bigEndian = false;
                return true;
            }
            case 65534: {
                this._reportWeirdUCS4("2143");
                break;
            }
            case -16842752: {
                this._reportWeirdUCS4("3412");
                break;
            }
        }
        int msw = quad >>> 16;
        if (msw == 65279) {
            this._inputPtr += 2;
            this._bytesPerChar = 2;
            this._bigEndian = true;
            return true;
        }
        if (msw == 65534) {
            this._inputPtr += 2;
            this._bytesPerChar = 2;
            this._bigEndian = false;
            return true;
        }
        if (quad >>> 8 == 0xEFBBBF) {
            this._inputPtr += 3;
            this._bytesPerChar = 1;
            this._bigEndian = true;
            return true;
        }
        return false;
    }

    private boolean checkUTF32(int quad) throws JacksonException {
        if (quad >> 8 == 0) {
            this._bigEndian = true;
        } else if ((quad & 0xFFFFFF) == 0) {
            this._bigEndian = false;
        } else if ((quad & 0xFF00FFFF) == 0) {
            this._reportWeirdUCS4("3412");
        } else if ((quad & 0xFFFF00FF) == 0) {
            this._reportWeirdUCS4("2143");
        } else {
            return false;
        }
        this._bytesPerChar = 4;
        return true;
    }

    private boolean checkUTF16(int i16) {
        if ((i16 & 0xFF00) == 0) {
            this._bigEndian = true;
        } else if ((i16 & 0xFF) == 0) {
            this._bigEndian = false;
        } else {
            return false;
        }
        this._bytesPerChar = 2;
        return true;
    }

    private void _reportWeirdUCS4(String type) throws JacksonException {
        throw this._createIOFailure("Unsupported UCS-4 endianness (" + type + ") detected");
    }

    protected boolean ensureLoaded(int minimum) throws JacksonException {
        int count;
        for (int gotten = this._inputEnd - this._inputPtr; gotten < minimum; gotten += count) {
            if (this._in == null) {
                count = -1;
            } else {
                try {
                    count = this._in.read(this._inputBuffer, this._inputEnd, this._inputBuffer.length - this._inputEnd);
                }
                catch (IOException e) {
                    throw ByteSourceJsonBootstrapper._wrapIOFailure(e);
                }
            }
            if (count < 1) {
                return false;
            }
            this._inputEnd += count;
        }
        return true;
    }

    private JacksonException _createIOFailure(String msg) throws JacksonException {
        return ByteSourceJsonBootstrapper._wrapIOFailure(new IOException(msg));
    }

    private static JacksonException _wrapIOFailure(IOException e) throws JacksonException {
        return JacksonIOException.construct(e, null);
    }
}

