/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.upconversion;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import uk.ac.ed.ph.snuggletex.upconversion.ElementWrapper;
import uk.ac.ed.ph.snuggletex.upconversion.IllegalUpconversionOptionException;
import uk.ac.ed.ph.snuggletex.upconversion.UpConversionErrorCode;
import uk.ac.ed.ph.snuggletex.upconversion.UpConversionOptionDefinitions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UpConversionOptions {
    private final Map<String, String> specifiedOptionMap = new HashMap<String, String>();
    private final Map<ElementWrapper, String> symbolAssumptions = new HashMap<ElementWrapper, String>();

    public boolean isOptionSpecified(String name) {
        return this.specifiedOptionMap.containsKey(name);
    }

    public Set<String> getSpecifiedOptionNames() {
        return this.specifiedOptionMap.keySet();
    }

    public String getSpecifiedOptionValue(String name) {
        if (!UpConversionOptionDefinitions.OPTION_DEFINITIONS.containsKey(name)) {
            throw new IllegalUpconversionOptionException(UpConversionErrorCode.UAEOP0, name);
        }
        return this.specifiedOptionMap.get(name);
    }

    public String getEffectiveOptionValue(String name, boolean applyDefault) {
        if (!UpConversionOptionDefinitions.OPTION_DEFINITIONS.containsKey(name)) {
            throw new IllegalUpconversionOptionException(UpConversionErrorCode.UAEOP0, name);
        }
        return this.specifiedOptionMap.containsKey(name) ? this.specifiedOptionMap.get(name) : (applyDefault ? UpConversionOptionDefinitions.OPTION_DEFINITIONS.get(name).getDefaultValue() : null);
    }

    public void setSpecifiedOption(String name, String value) {
        UpConversionOptionDefinitions.OptionValueDefinition valueDefinition = UpConversionOptionDefinitions.OPTION_DEFINITIONS.get(name);
        if (valueDefinition == null) {
            throw new IllegalUpconversionOptionException(UpConversionErrorCode.UAEOP0, name);
        }
        Set<String> valueSpace = valueDefinition.getValueSpace();
        if (valueSpace != null && !valueSpace.contains(value)) {
            throw new IllegalUpconversionOptionException(UpConversionErrorCode.UAEOP1, name, value);
        }
        this.specifiedOptionMap.put(name, value);
    }

    public void clearSpecifiedOption(String name) {
        if (!this.specifiedOptionMap.containsKey(name)) {
            throw new IllegalUpconversionOptionException(UpConversionErrorCode.UAEOP2, name);
        }
        this.specifiedOptionMap.remove(name);
    }

    public Set<ElementWrapper> getAssumedSymbols() {
        return this.symbolAssumptions.keySet();
    }

    public String getSymbolAssumptionType(Element element) {
        return this.getSymbolAssumptionType(new ElementWrapper(element));
    }

    public String getSymbolAssumptionType(ElementWrapper elementWrapper) {
        return this.symbolAssumptions.get(elementWrapper);
    }

    public void assumeSymbol(Element element, String assumptionType) {
        if (!UpConversionOptionDefinitions.SYMBOL_ASSUMPTION_TYPES.contains(assumptionType)) {
            throw new IllegalUpconversionOptionException(UpConversionErrorCode.UAESY0, assumptionType);
        }
        this.symbolAssumptions.put(new ElementWrapper(element), assumptionType);
    }

    public void unassumeSymbol(Element element) {
        ElementWrapper wrapper = new ElementWrapper(element);
        if (!this.symbolAssumptions.containsKey(wrapper)) {
            throw new IllegalUpconversionOptionException(UpConversionErrorCode.UAESY2, new String[0]);
        }
        this.symbolAssumptions.remove(wrapper);
    }
}

