/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.upconversion.samples;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import uk.ac.ed.ph.snuggletex.upconversion.MathMLUpConverter;
import uk.ac.ed.ph.snuggletex.upconversion.UpConversionOptions;
import uk.ac.ed.ph.snuggletex.utilities.MathMLUtilities;
import uk.ac.ed.ph.snuggletex.utilities.UnwrappedParallelMathMLDOM;

public class ASCIIMathMLUpConversionExample {
    public static void main(String[] args) {
        Document asciiMathMLDocument;
        DocumentBuilder documentBuilder;
        String asciiMathML = "<math title=\" (5x)/(1-x) \" xmlns=\"http://www.w3.org/1998/Math/MathML\">\n  <mstyle mathcolor=\"blue\" fontfamily=\"serif\" displaystyle=\"true\">\n    <mfrac>\n      <mrow>\n        <mn>5</mn>\n        <mi>x</mi>\n      </mrow>\n      <mrow>\n        <mn>1</mn>\n        <mo>-</mo>\n        <mi>x</mi>\n      </mrow>\n    </mfrac>\n  </mstyle>\n</math>";
        try {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Blah...", e);
        }
        try {
            asciiMathMLDocument = documentBuilder.parse(new InputSource(new StringReader(asciiMathML)));
        }
        catch (SAXException e) {
            throw new RuntimeException("Blah...", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Blah...", e);
        }
        MathMLUpConverter upConverter = new MathMLUpConverter();
        UpConversionOptions upConversionOptions = new UpConversionOptions();
        upConversionOptions.setSpecifiedOption("doContentMathML", "true");
        upConversionOptions.setSpecifiedOption("doMaxima", "true");
        Document upConvertedDocument = upConverter.upConvertASCIIMathML(asciiMathMLDocument, upConversionOptions);
        String resultingMathMLString = MathMLUtilities.serializeDocument((Document)upConvertedDocument);
        System.out.println("Resulting MathML is:\n" + resultingMathMLString);
        String maximaAnnotation = MathMLUtilities.extractAnnotationString((Element)upConvertedDocument.getDocumentElement(), (String)"Maxima");
        System.out.println("Maxima Annotation was:\n" + maximaAnnotation);
        UnwrappedParallelMathMLDOM unwrappedDOM = MathMLUtilities.unwrapParallelMathMLDOM((Element)upConvertedDocument.getDocumentElement());
        System.out.println("First branch of parallel MathML DOM was:\n" + MathMLUtilities.serializeElement((Element)unwrappedDOM.getFirstBranch()));
    }
}

