/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.rust;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.agrona.Verify;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.generation.Generators;
import uk.co.real_logic.sbe.generation.rust.RustGenerator;
import uk.co.real_logic.sbe.ir.Encoding;

public class RustUtil {
    static final String INDENT = "    ";
    static final Map<PrimitiveType, String> TYPE_NAME_BY_PRIMITIVE_TYPE_MAP = new EnumMap<PrimitiveType, String>(PrimitiveType.class);

    static String rustTypeName(PrimitiveType primitiveType) {
        return TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.get((Object)primitiveType);
    }

    static String generateRustLiteral(PrimitiveType type, String value) {
        Verify.notNull((Object)type, "type");
        Verify.notNull(value, "value");
        String typeName = RustUtil.rustTypeName(type);
        if (typeName == null) {
            throw new IllegalArgumentException("Unknown Rust type name found for primitive " + type.primitiveName());
        }
        switch (type) {
            case CHAR: 
            case INT8: 
            case INT16: 
            case INT32: 
            case INT64: {
                return value + "_" + typeName;
            }
            case UINT8: 
            case UINT16: 
            case UINT32: 
            case UINT64: {
                return "0x" + Long.toHexString(Long.parseLong(value)) + "_" + typeName;
            }
            case FLOAT: 
            case DOUBLE: {
                return value.endsWith("NaN") ? typeName + "::NAN" : value + "_" + typeName;
            }
        }
        throw new IllegalArgumentException("Unsupported literal generation for type: " + type.primitiveName());
    }

    static byte eightBitCharacter(String asciiCharacter) {
        Verify.notNull(asciiCharacter, "asciiCharacter");
        byte[] bytes = asciiCharacter.getBytes(StandardCharsets.US_ASCII);
        if (bytes.length != 1) {
            throw new IllegalArgumentException("String value `" + asciiCharacter + "` did not fit into a single 8-bit character");
        }
        return bytes[0];
    }

    static String formatStructName(String structName) {
        return Generators.toUpperFirstChar(structName);
    }

    static String codecModName(String prefix) {
        return RustUtil.toLowerSnakeCase(prefix + "Codec");
    }

    static String codecName(String structName, RustGenerator.CodecType codecType) {
        return RustUtil.formatStructName(structName + codecType.name());
    }

    static String encoderName(String structName) {
        return RustUtil.codecName(structName, RustGenerator.CodecType.Encoder);
    }

    static String decoderName(String structName) {
        return RustUtil.codecName(structName, RustGenerator.CodecType.Decoder);
    }

    static String formatFunctionName(String value) {
        if (value.isEmpty()) {
            return value;
        }
        return RustUtil.sanitizeMethodOrProperty(RustUtil.toLowerSnakeCase(value));
    }

    static String cleanUpperAcronyms(String value) {
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            if (RustUtil.isUpperAlpha(c) || RustUtil.isNumeric(c)) continue;
            if (c != '_' && i > 2) {
                int index = i - 1;
                return value.substring(0, index).toLowerCase() + value.substring(index);
            }
            return value;
        }
        return value;
    }

    static String characterEncoding(Encoding encoding) {
        String characterEncoding = encoding.characterEncoding();
        if (characterEncoding == null) {
            return "None";
        }
        return characterEncoding;
    }

    static String toLowerSnakeCase(String value) {
        if (value.isEmpty()) {
            return value;
        }
        String cleaned = RustUtil.cleanUpperAcronyms(value);
        String s = Generators.toLowerFirstChar(cleaned);
        int length = s.length();
        StringBuilder out = new StringBuilder(length + 4);
        char lastChar = '\u0000';
        int i = 0;
        for (int j = 0; j < length; ++j) {
            boolean wasUpper = RustUtil.isUpperAlpha(lastChar);
            boolean wasNumeric = RustUtil.isNumeric(lastChar);
            boolean wasUnderscore = lastChar == '_';
            char c = s.charAt(j);
            if (c == '_') {
                out.append(c);
                i = j + 1;
            } else if (RustUtil.isUpperAlpha(c)) {
                if (wasNumeric || !wasUpper && j - i > 1 && !wasUnderscore) {
                    out.append('_');
                    out.append(RustUtil.toLowerSnakeCase(s.substring(j)));
                    return out.toString();
                }
                out.append(Character.toLowerCase(c));
            } else if (RustUtil.isNumeric(c)) {
                if (!wasNumeric && j - i > 1 && !wasUnderscore) {
                    out.append('_');
                    out.append(RustUtil.toLowerSnakeCase(s.substring(j)));
                    return out.toString();
                }
                out.append(c);
            } else {
                if ((wasUpper || wasNumeric) && j - i > 1 && !wasUnderscore) {
                    out.append('_');
                    out.append(RustUtil.toLowerSnakeCase(s.substring(j)));
                    return out.toString();
                }
                out.append(c);
            }
            lastChar = c;
        }
        return out.toString();
    }

    private static boolean isUpperAlpha(char c) {
        return 'A' <= c && c <= 'Z';
    }

    private static boolean isNumeric(char c) {
        return '0' <= c && c <= '9';
    }

    private static String sanitizeMethodOrProperty(String name) {
        if (RustUtil.shadowsKeyword(name)) {
            return "r#" + name;
        }
        return name;
    }

    private static boolean shadowsKeyword(String name) {
        return ReservedKeyword.anyMatch(name);
    }

    static Appendable indent(Appendable appendable) throws IOException {
        return RustUtil.indent(appendable, 1);
    }

    static Appendable indent(Appendable appendable, int level) throws IOException {
        Appendable out = appendable;
        for (int i = 0; i < level; ++i) {
            out = out.append(INDENT);
        }
        return out;
    }

    static Appendable indent(Appendable appendable, int level, String f, Object ... args) throws IOException {
        return RustUtil.indent(appendable, level).append(String.format(f, args));
    }

    static {
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.CHAR, "u8");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.INT8, "i8");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.INT16, "i16");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.INT32, "i32");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.INT64, "i64");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.UINT8, "u8");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.UINT16, "u16");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.UINT32, "u32");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.UINT64, "u64");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.FLOAT, "f32");
        TYPE_NAME_BY_PRIMITIVE_TYPE_MAP.put(PrimitiveType.DOUBLE, "f64");
    }

    static enum ReservedKeyword {
        Abstract,
        AlignOf,
        As,
        Async,
        Become,
        Box,
        Break,
        Const,
        Continue,
        Crate,
        Do,
        Else,
        Enum,
        Extern,
        False,
        Final,
        Fn,
        For,
        If,
        Impl,
        In,
        Let,
        Loop,
        Macro,
        Match,
        Mod,
        Move,
        Mut,
        OffsetOf,
        Override,
        Priv,
        Proc,
        Pub,
        Pure,
        Ref,
        Return,
        Self,
        Sizeof,
        Static,
        Struct,
        Super,
        Trait,
        True,
        Type,
        Typeof,
        Unsafe,
        Unsized,
        Use,
        Virtual,
        Where,
        While,
        Yield;

        private static final Set<String> LOWER_CASE_NAMES;

        static boolean anyMatch(String v) {
            return LOWER_CASE_NAMES.contains(v.toLowerCase());
        }

        static {
            LOWER_CASE_NAMES = new HashSet<String>();
            for (ReservedKeyword value : ReservedKeyword.values()) {
                LOWER_CASE_NAMES.add(value.name().toLowerCase());
            }
        }
    }
}

