/*
 * Decompiled with CFR 0.152.
 */
package uk.org.lidalia.slf4jtest;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.joda.time.Instant;
import org.slf4j.Marker;
import org.slf4j.helpers.MessageFormatter;
import uk.org.lidalia.lang.Identity;
import uk.org.lidalia.lang.RichObject;
import uk.org.lidalia.slf4jext.Level;
import uk.org.lidalia.slf4jtest.TestLogger;

public class LoggingEvent
extends RichObject {
    private static final Function<Object, Object> TO_NON_NULL_VALUE = new Function<Object, Object>(){

        public Object apply(Object input) {
            return Optional.fromNullable((Object)input).or((Object)Optional.absent());
        }
    };
    @Identity
    private final Level level;
    @Identity
    private final ImmutableMap<String, String> mdc;
    @Identity
    private final Optional<Marker> marker;
    @Identity
    private final Optional<Throwable> throwable;
    @Identity
    private final String message;
    @Identity
    private final ImmutableList<Object> arguments;
    private final Optional<TestLogger> creatingLogger;
    private final Instant timestamp = new Instant();
    private final String threadName = Thread.currentThread().getName();
    private static final Function<TestLogger, String> toLoggerNameString = new Function<TestLogger, String>(){

        public String apply(TestLogger logger) {
            return " " + logger.getName();
        }
    };

    public static LoggingEvent trace(String message, Object ... arguments) {
        return new LoggingEvent(Level.TRACE, message, arguments);
    }

    public static LoggingEvent trace(Throwable throwable, String message, Object ... arguments) {
        return new LoggingEvent(Level.TRACE, throwable, message, arguments);
    }

    public static LoggingEvent trace(Marker marker, String message, Object ... arguments) {
        return new LoggingEvent(Level.TRACE, marker, message, arguments);
    }

    public static LoggingEvent trace(Marker marker, Throwable throwable, String message, Object ... arguments) {
        return new LoggingEvent(Level.TRACE, marker, throwable, message, arguments);
    }

    public static LoggingEvent trace(Map<String, String> mdc, String message, Object ... arguments) {
        return new LoggingEvent(Level.TRACE, mdc, message, arguments);
    }

    public static LoggingEvent trace(Map<String, String> mdc, Throwable throwable, String message, Object ... arguments) {
        return new LoggingEvent(Level.TRACE, mdc, throwable, message, arguments);
    }

    public static LoggingEvent trace(Map<String, String> mdc, Marker marker, String message, Object ... arguments) {
        return new LoggingEvent(Level.TRACE, mdc, marker, message, arguments);
    }

    public static LoggingEvent trace(Map<String, String> mdc, Marker marker, Throwable throwable, String message, Object ... arguments) {
        return new LoggingEvent(Level.TRACE, mdc, marker, throwable, message, arguments);
    }

    public static LoggingEvent debug(String message, Object ... arguments) {
        return new LoggingEvent(Level.DEBUG, message, arguments);
    }

    public static LoggingEvent debug(Throwable throwable, String message, Object ... arguments) {
        return new LoggingEvent(Level.DEBUG, throwable, message, arguments);
    }

    public static LoggingEvent debug(Marker marker, String message, Object ... arguments) {
        return new LoggingEvent(Level.DEBUG, marker, message, arguments);
    }

    public static LoggingEvent debug(Marker marker, Throwable throwable, String message, Object ... arguments) {
        return new LoggingEvent(Level.DEBUG, marker, throwable, message, arguments);
    }

    public static LoggingEvent debug(Map<String, String> mdc, String message, Object ... arguments) {
        return new LoggingEvent(Level.DEBUG, mdc, message, arguments);
    }

    public static LoggingEvent debug(Map<String, String> mdc, Throwable throwable, String message, Object ... arguments) {
        return new LoggingEvent(Level.DEBUG, mdc, throwable, message, arguments);
    }

    public static LoggingEvent debug(Map<String, String> mdc, Marker marker, String message, Object ... arguments) {
        return new LoggingEvent(Level.DEBUG, mdc, marker, message, arguments);
    }

    public static LoggingEvent debug(Map<String, String> mdc, Marker marker, Throwable throwable, String message, Object ... arguments) {
        return new LoggingEvent(Level.DEBUG, mdc, marker, throwable, message, arguments);
    }

    public static LoggingEvent info(String message, Object ... arguments) {
        return new LoggingEvent(Level.INFO, message, arguments);
    }

    public static LoggingEvent info(Throwable throwable, String message, Object ... arguments) {
        return new LoggingEvent(Level.INFO, throwable, message, arguments);
    }

    public static LoggingEvent info(Marker marker, String message, Object ... arguments) {
        return new LoggingEvent(Level.INFO, marker, message, arguments);
    }

    public static LoggingEvent info(Marker marker, Throwable throwable, String message, Object ... arguments) {
        return new LoggingEvent(Level.INFO, marker, throwable, message, arguments);
    }

    public static LoggingEvent info(Map<String, String> mdc, String message, Object ... arguments) {
        return new LoggingEvent(Level.INFO, mdc, message, arguments);
    }

    public static LoggingEvent info(Map<String, String> mdc, Throwable throwable, String message, Object ... arguments) {
        return new LoggingEvent(Level.INFO, mdc, throwable, message, arguments);
    }

    public static LoggingEvent info(Map<String, String> mdc, Marker marker, String message, Object ... arguments) {
        return new LoggingEvent(Level.INFO, mdc, marker, message, arguments);
    }

    public static LoggingEvent info(Map<String, String> mdc, Marker marker, Throwable throwable, String message, Object ... arguments) {
        return new LoggingEvent(Level.INFO, mdc, marker, throwable, message, arguments);
    }

    public static LoggingEvent warn(String message, Object ... arguments) {
        return new LoggingEvent(Level.WARN, message, arguments);
    }

    public static LoggingEvent warn(Throwable throwable, String message, Object ... arguments) {
        return new LoggingEvent(Level.WARN, throwable, message, arguments);
    }

    public static LoggingEvent warn(Marker marker, String message, Object ... arguments) {
        return new LoggingEvent(Level.WARN, marker, message, arguments);
    }

    public static LoggingEvent warn(Marker marker, Throwable throwable, String message, Object ... arguments) {
        return new LoggingEvent(Level.WARN, marker, throwable, message, arguments);
    }

    public static LoggingEvent warn(Map<String, String> mdc, String message, Object ... arguments) {
        return new LoggingEvent(Level.WARN, mdc, message, arguments);
    }

    public static LoggingEvent warn(Map<String, String> mdc, Throwable throwable, String message, Object ... arguments) {
        return new LoggingEvent(Level.WARN, mdc, throwable, message, arguments);
    }

    public static LoggingEvent warn(Map<String, String> mdc, Marker marker, String message, Object ... arguments) {
        return new LoggingEvent(Level.WARN, mdc, marker, message, arguments);
    }

    public static LoggingEvent warn(Map<String, String> mdc, Marker marker, Throwable throwable, String message, Object ... arguments) {
        return new LoggingEvent(Level.WARN, mdc, marker, throwable, message, arguments);
    }

    public static LoggingEvent error(String message, Object ... arguments) {
        return new LoggingEvent(Level.ERROR, message, arguments);
    }

    public static LoggingEvent error(Throwable throwable, String message, Object ... arguments) {
        return new LoggingEvent(Level.ERROR, throwable, message, arguments);
    }

    public static LoggingEvent error(Marker marker, String message, Object ... arguments) {
        return new LoggingEvent(Level.ERROR, marker, message, arguments);
    }

    public static LoggingEvent error(Marker marker, Throwable throwable, String message, Object ... arguments) {
        return new LoggingEvent(Level.ERROR, marker, throwable, message, arguments);
    }

    public static LoggingEvent error(Map<String, String> mdc, String message, Object ... arguments) {
        return new LoggingEvent(Level.ERROR, mdc, message, arguments);
    }

    public static LoggingEvent error(Map<String, String> mdc, Throwable throwable, String message, Object ... arguments) {
        return new LoggingEvent(Level.ERROR, mdc, throwable, message, arguments);
    }

    public static LoggingEvent error(Map<String, String> mdc, Marker marker, String message, Object ... arguments) {
        return new LoggingEvent(Level.ERROR, mdc, marker, message, arguments);
    }

    public static LoggingEvent error(Map<String, String> mdc, Marker marker, Throwable throwable, String message, Object ... arguments) {
        return new LoggingEvent(Level.ERROR, mdc, marker, throwable, message, arguments);
    }

    public LoggingEvent(Level level, String message, Object ... arguments) {
        this(level, Collections.emptyMap(), (Optional<Marker>)Optional.absent(), (Optional<Throwable>)Optional.absent(), message, arguments);
    }

    public LoggingEvent(Level level, Throwable throwable, String message, Object ... arguments) {
        this(level, Collections.emptyMap(), (Optional<Marker>)Optional.absent(), (Optional<Throwable>)Optional.fromNullable((Object)throwable), message, arguments);
    }

    public LoggingEvent(Level level, Marker marker, String message, Object ... arguments) {
        this(level, Collections.emptyMap(), (Optional<Marker>)Optional.fromNullable((Object)marker), (Optional<Throwable>)Optional.absent(), message, arguments);
    }

    public LoggingEvent(Level level, Marker marker, Throwable throwable, String message, Object ... arguments) {
        this(level, Collections.emptyMap(), (Optional<Marker>)Optional.fromNullable((Object)marker), (Optional<Throwable>)Optional.fromNullable((Object)throwable), message, arguments);
    }

    public LoggingEvent(Level level, Map<String, String> mdc, String message, Object ... arguments) {
        this(level, mdc, (Optional<Marker>)Optional.absent(), (Optional<Throwable>)Optional.absent(), message, arguments);
    }

    public LoggingEvent(Level level, Map<String, String> mdc, Throwable throwable, String message, Object ... arguments) {
        this(level, mdc, (Optional<Marker>)Optional.absent(), (Optional<Throwable>)Optional.fromNullable((Object)throwable), message, arguments);
    }

    public LoggingEvent(Level level, Map<String, String> mdc, Marker marker, String message, Object ... arguments) {
        this(level, mdc, (Optional<Marker>)Optional.fromNullable((Object)marker), (Optional<Throwable>)Optional.absent(), message, arguments);
    }

    public LoggingEvent(Level level, Map<String, String> mdc, Marker marker, Throwable throwable, String message, Object ... arguments) {
        this(level, mdc, (Optional<Marker>)Optional.fromNullable((Object)marker), (Optional<Throwable>)Optional.fromNullable((Object)throwable), message, arguments);
    }

    private LoggingEvent(Level level, Map<String, String> mdc, Optional<Marker> marker, Optional<Throwable> throwable, String message, Object ... arguments) {
        this((Optional<TestLogger>)Optional.absent(), level, mdc, marker, throwable, message, arguments);
    }

    LoggingEvent(Optional<TestLogger> creatingLogger, Level level, Map<String, String> mdc, Optional<Marker> marker, Optional<Throwable> throwable, String message, Object ... arguments) {
        this.creatingLogger = creatingLogger;
        this.level = (Level)Preconditions.checkNotNull((Object)level);
        this.mdc = ImmutableMap.copyOf(mdc);
        this.marker = (Optional)Preconditions.checkNotNull(marker);
        this.throwable = (Optional)Preconditions.checkNotNull(throwable);
        this.message = (String)Preconditions.checkNotNull((Object)message);
        this.arguments = FluentIterable.from(Arrays.asList(arguments)).transform(TO_NON_NULL_VALUE).toList();
    }

    public Level getLevel() {
        return this.level;
    }

    public ImmutableMap<String, String> getMdc() {
        return this.mdc;
    }

    public Optional<Marker> getMarker() {
        return this.marker;
    }

    public String getMessage() {
        return this.message;
    }

    public ImmutableList<Object> getArguments() {
        return this.arguments;
    }

    public Optional<Throwable> getThrowable() {
        return this.throwable;
    }

    public TestLogger getCreatingLogger() {
        return (TestLogger)this.creatingLogger.get();
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public String getThreadName() {
        return this.threadName;
    }

    void print() {
        PrintStream output = this.printStreamForLevel();
        output.println(this.formatLogStatement());
        this.throwable.transform(LoggingEvent.printThrowableTo(output));
    }

    private static Function<Throwable, String> printThrowableTo(final PrintStream output) {
        return new Function<Throwable, String>(){

            public String apply(Throwable throwableToPrint) {
                throwableToPrint.printStackTrace(output);
                return "";
            }
        };
    }

    private String formatLogStatement() {
        return this.getTimestamp() + " [" + this.getThreadName() + "] " + this.getLevel() + this.safeLoggerName() + " - " + this.getFormattedMessage();
    }

    private String safeLoggerName() {
        return (String)this.creatingLogger.transform(toLoggerNameString).or((Object)"");
    }

    private String getFormattedMessage() {
        return MessageFormatter.arrayFormat((String)this.getMessage(), (Object[])this.getArguments().toArray()).getMessage();
    }

    private PrintStream printStreamForLevel() {
        switch (this.level) {
            case ERROR: 
            case WARN: {
                return System.err;
            }
        }
        return System.out;
    }
}

