/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import schemacrawler.SchemaCrawlerLogger;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableColumnDataType;
import schemacrawler.crawl.MutableResultsColumn;
import schemacrawler.crawl.MutableResultsColumns;
import schemacrawler.crawl.MutableTable;
import schemacrawler.schema.DataTypeType;
import schemacrawler.schema.JavaSqlType;
import schemacrawler.schema.ResultsColumns;
import schemacrawler.schema.Schema;
import schemacrawler.utility.JavaSqlTypes;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.StringFormat;

final class ResultsRetriever {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(ResultsRetriever.class.getName());
    private final ResultSetMetaData resultsMetaData;

    ResultsRetriever(ResultSet resultSet) throws SQLException {
        Objects.requireNonNull(resultSet, "Cannot retrieve metadata for null results");
        this.resultsMetaData = resultSet.getMetaData();
    }

    ResultsColumns retrieveResults() throws SQLException {
        JavaSqlTypes javaSqlTypes = new JavaSqlTypes();
        MutableResultsColumns resultColumns = new MutableResultsColumns("");
        MutableCatalog catalog = new MutableCatalog("results");
        int columnCount = this.resultsMetaData.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            int columnIndex = i;
            String catalogName = this.execute("catalog name", () -> this.resultsMetaData.getCatalogName(columnIndex));
            String schemaName = this.execute("schema name", () -> this.resultsMetaData.getSchemaName(columnIndex));
            Schema schema = catalog.addSchema(catalogName, schemaName);
            String tableName = this.execute("table name", () -> this.resultsMetaData.getTableName(columnIndex));
            if (Utility.isBlank(tableName)) {
                tableName = "";
            }
            MutableTable table = new MutableTable(schema, tableName);
            catalog.addTable(table);
            String columnName = this.execute("column name", () -> this.resultsMetaData.getColumnName(columnIndex));
            String columnLabel = this.execute("column label", () -> this.resultsMetaData.getColumnLabel(columnIndex));
            MutableResultsColumn column = new MutableResultsColumn(table, columnName, columnLabel);
            try {
                String databaseSpecificTypeName = this.resultsMetaData.getColumnTypeName(columnIndex);
                int javaSqlType = this.resultsMetaData.getColumnType(columnIndex);
                String columnClassName = this.resultsMetaData.getColumnClassName(columnIndex);
                MutableColumnDataType columnDataType = new MutableColumnDataType(schema, databaseSpecificTypeName, DataTypeType.user_defined);
                columnDataType.setJavaSqlType(javaSqlTypes.valueOf(javaSqlType));
                columnDataType.setTypeMappedClass(columnClassName);
                columnDataType.setPrecision(this.resultsMetaData.getPrecision(columnIndex));
                int scale = this.resultsMetaData.getScale(columnIndex);
                columnDataType.setMaximumScale(scale);
                columnDataType.setMinimumScale(scale);
                column.setColumnDataType(columnDataType);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, new StringFormat("Could not retrieve results column data type for %s (%s)", column, column.getLabel()), (Throwable)e);
                MutableColumnDataType unknownColumnDataType = new MutableColumnDataType(schema, "<unknown>", DataTypeType.user_defined);
                unknownColumnDataType.setJavaSqlType(JavaSqlType.UNKNOWN);
                column.setColumnDataType(unknownColumnDataType);
            }
            try {
                boolean isNullable = this.resultsMetaData.isNullable(columnIndex) == 1;
                column.setOrdinalPosition(columnIndex);
                column.setDisplaySize(this.resultsMetaData.getColumnDisplaySize(columnIndex));
                column.setAutoIncrement(this.resultsMetaData.isAutoIncrement(columnIndex));
                column.setCaseSensitive(this.resultsMetaData.isCaseSensitive(columnIndex));
                column.setCurrency(this.resultsMetaData.isCurrency(columnIndex));
                column.setDefinitelyWritable(this.resultsMetaData.isDefinitelyWritable(columnIndex));
                column.setNullable(isNullable);
                column.setReadOnly(this.resultsMetaData.isReadOnly(columnIndex));
                column.setSearchable(this.resultsMetaData.isSearchable(columnIndex));
                column.setSigned(this.resultsMetaData.isSigned(columnIndex));
                column.setWritable(this.resultsMetaData.isWritable(columnIndex));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, new StringFormat("Could not retrieve results column additional data for %s (%s)", column, column.getLabel()), (Throwable)e);
            }
            resultColumns.addColumn(column);
        }
        return resultColumns;
    }

    private String execute(String resultsColumnField, Callable<String> getResultsColumn) {
        try {
            return getResultsColumn.call();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, new StringFormat("Could not retrieve results column field, %s", resultsColumnField), (Throwable)e);
            return null;
        }
    }
}

