/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.filter;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.PartialDatabaseObject;
import schemacrawler.schema.Reducer;
import schemacrawler.schema.ReducibleCollection;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableRelationshipType;
import schemacrawler.schemacrawler.FilterOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;

final class TablesReducer
implements Reducer<Table> {
    private final SchemaCrawlerOptions options;
    private final Predicate<Table> tableFilter;

    TablesReducer(SchemaCrawlerOptions options, Predicate<Table> tableFilter) {
        this.options = Objects.requireNonNull(options, "No SchemaCrawler options provided");
        this.tableFilter = Objects.requireNonNull(tableFilter, "No table filter provided");
    }

    @Override
    public void reduce(ReducibleCollection<? extends Table> allTables) {
        if (allTables == null) {
            return;
        }
        this.doReduce(allTables);
        this.removeForeignKeys(allTables);
    }

    private void doReduce(ReducibleCollection<? extends Table> allTables) {
        HashSet<Table> reducedTables = new HashSet<Table>();
        for (Table table2 : allTables) {
            if (!this.tableFilter.test(table2)) continue;
            reducedTables.add(table2);
        }
        FilterOptions filterOptions = this.options.getFilterOptions();
        int n = filterOptions.getChildTableFilterDepth();
        Collection<Table> childTables = this.includeRelatedTables(TableRelationshipType.child, n, reducedTables);
        int parentTableFilterDepth = filterOptions.getParentTableFilterDepth();
        Collection<Table> parentTables = this.includeRelatedTables(TableRelationshipType.parent, parentTableFilterDepth, reducedTables);
        HashSet<Table> keepTables = new HashSet<Table>();
        keepTables.addAll(reducedTables);
        keepTables.addAll(childTables);
        keepTables.addAll(parentTables);
        for (Table table3 : allTables) {
            if (!this.isTablePartial(table3) && keepTables.contains(table3)) continue;
            this.markTableFilteredOut(table3);
        }
        allTables.filter(table -> keepTables.contains(table));
    }

    private Collection<Table> includeRelatedTables(TableRelationshipType tableRelationshipType, int depth, Set<Table> greppedTables) {
        HashSet<Table> includedTables = new HashSet<Table>();
        includedTables.addAll(greppedTables);
        for (int i = 0; i < depth; ++i) {
            for (Table table : new HashSet<Table>(includedTables)) {
                for (Table relatedTable : table.getRelatedTables(tableRelationshipType)) {
                    if (this.isTablePartial(relatedTable)) continue;
                    includedTables.add(relatedTable);
                }
            }
        }
        return includedTables;
    }

    private boolean isTablePartial(Table table) {
        return table instanceof PartialDatabaseObject;
    }

    private void markTableFilteredOut(Table table) {
        table.setAttribute("schemacrawler.table.filtered_out", true);
        if (this.options.getGrepOptions().isGrepOnlyMatching()) {
            table.setAttribute("schemacrawler.table.no_grep_match", true);
        }
    }

    private void removeForeignKeys(ReducibleCollection<? extends Table> allTables) {
        for (Table table : allTables) {
            for (ForeignKey foreignKey : table.getExportedForeignKeys()) {
                for (ColumnReference fkColumnRef : foreignKey) {
                    Table referencedTable = (Table)fkColumnRef.getForeignKeyColumn().getParent();
                    if (!this.isTablePartial(referencedTable) && !allTables.isFiltered(referencedTable)) continue;
                    this.markTableFilteredOut(referencedTable);
                }
            }
        }
    }
}

