/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.text.operation;

import java.util.ArrayList;
import java.util.Collection;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.tools.command.text.operation.OperationCommand;
import schemacrawler.tools.command.text.operation.options.OperationOptions;
import schemacrawler.tools.command.text.operation.options.OperationOptionsBuilder;
import schemacrawler.tools.command.text.operation.options.OperationType;
import schemacrawler.tools.executable.BaseCommandProvider;
import schemacrawler.tools.executable.CommandDescription;
import schemacrawler.tools.options.Config;
import schemacrawler.tools.options.OutputOptions;

public final class OperationCommandProvider
extends BaseCommandProvider {
    private static Collection<CommandDescription> operationCommands() {
        ArrayList<CommandDescription> supportedCommands = new ArrayList<CommandDescription>();
        for (OperationType operation : OperationType.values()) {
            supportedCommands.add(new CommandDescription(operation.name(), operation.getDescription()));
        }
        return supportedCommands;
    }

    public OperationCommandProvider() {
        super(OperationCommandProvider.operationCommands());
    }

    @Override
    public OperationCommand newSchemaCrawlerCommand(String command, Config config) {
        OperationOptions operationOptions = OperationOptionsBuilder.builder().withCommand(command).fromConfig(config).toOptions();
        OperationCommand scCommand = new OperationCommand(command);
        scCommand.setCommandOptions(operationOptions);
        return scCommand;
    }

    @Override
    public boolean supportsOutputFormat(String command, OutputOptions outputOptions) {
        return true;
    }

    @Override
    public boolean supportsSchemaCrawlerCommand(String command, SchemaCrawlerOptions schemaCrawlerOptions, Config additionalConfig, OutputOptions outputOptions) {
        boolean isOperation = this.supportsCommand(command);
        boolean isNamedQuery = additionalConfig != null ? additionalConfig.containsKey(command) : false;
        boolean supportsSchemaCrawlerCommand = isOperation || isNamedQuery;
        return supportsSchemaCrawlerCommand;
    }
}

