/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.translator;

import ai.djl.modality.Classifications;
import ai.djl.modality.cv.translator.BaseImageTranslator;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.translate.ArgumentsUtil;
import ai.djl.translate.TranslatorContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class ImageClassificationTranslator
extends BaseImageTranslator<Classifications> {
    private BaseImageTranslator.SynsetLoader synsetLoader;
    private boolean applySoftmax;
    private int topK;
    private List<String> classes;

    public ImageClassificationTranslator(Builder builder) {
        super(builder);
        this.synsetLoader = builder.synsetLoader;
        this.applySoftmax = builder.applySoftmax;
        this.topK = builder.topK;
    }

    @Override
    public void prepare(TranslatorContext ctx) throws IOException {
        if (this.classes == null) {
            this.classes = this.synsetLoader.load(ctx.getModel());
        }
    }

    @Override
    public Classifications processOutput(TranslatorContext ctx, NDList list) {
        NDArray probabilitiesNd = list.singletonOrThrow();
        if (this.applySoftmax) {
            probabilitiesNd = probabilitiesNd.softmax(0);
        }
        return new Classifications(this.classes, probabilitiesNd, this.topK);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Map<String, ?> arguments) {
        Builder builder = new Builder();
        builder.configPreProcess(arguments);
        builder.configPostProcess(arguments);
        return builder;
    }

    public static class Builder
    extends BaseImageTranslator.ClassificationBuilder<Builder> {
        private boolean applySoftmax;
        private int topK = 5;

        Builder() {
        }

        public Builder optTopK(int topK) {
            this.topK = topK;
            return this;
        }

        public Builder optApplySoftmax(boolean applySoftmax) {
            this.applySoftmax = applySoftmax;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        protected void configPostProcess(Map<String, ?> arguments) {
            super.configPostProcess(arguments);
            this.applySoftmax = ArgumentsUtil.booleanValue(arguments, "applySoftmax");
            this.topK = ArgumentsUtil.intValue(arguments, "topK", 5);
        }

        public ImageClassificationTranslator build() {
            this.validate();
            return new ImageClassificationTranslator(this);
        }
    }
}

