/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.internal.types;

import org.tensorflow.RawTensor;
import org.tensorflow.TensorMapper;
import org.tensorflow.internal.buffer.TensorBuffers;
import org.tensorflow.ndarray.buffer.ByteDataBuffer;
import org.tensorflow.ndarray.impl.dense.ByteDenseNdArray;
import org.tensorflow.types.TUint8;

public final class TUint8Mapper
extends TensorMapper<TUint8> {
    @Override
    protected TUint8 mapDense(RawTensor tensor) {
        ByteDataBuffer buffer = TensorBuffers.toBytes(TUint8Mapper.nativeHandle(tensor));
        return new DenseTUint8(tensor, buffer);
    }

    private static final class DenseTUint8
    extends ByteDenseNdArray
    implements TUint8 {
        final RawTensor rawTensor;

        public Class<TUint8> type() {
            return TUint8.class;
        }

        @Override
        public RawTensor asRawTensor() {
            return this.rawTensor;
        }

        DenseTUint8(RawTensor rawTensor, ByteDataBuffer buffer) {
            super(buffer, rawTensor.shape());
            this.rawTensor = rawTensor;
        }
    }
}

