/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.io;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="DeserializeManySparse", inputsClass=Inputs.class)
public final class DeserializeManySparse<T extends TType>
extends RawOp {
    public static final String OP_NAME = "DeserializeManySparse";
    private Output<TInt64> sparseIndices;
    private Output<T> sparseValues;
    private Output<TInt64> sparseShape;

    public DeserializeManySparse(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.sparseIndices = operation.output(outputIdx++);
        this.sparseValues = operation.output(outputIdx++);
        this.sparseShape = operation.output(outputIdx++);
    }

    public static <T extends TType> DeserializeManySparse<T> create(Scope scope, Operand<TString> serializedSparse, Class<T> dtype) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(serializedSparse.asOutput());
        opBuilder.setAttr("dtype", Operands.toDataType(dtype));
        return new DeserializeManySparse<T>(opBuilder.build());
    }

    public Output<TInt64> sparseIndices() {
        return this.sparseIndices;
    }

    public Output<T> sparseValues() {
        return this.sparseValues;
    }

    public Output<TInt64> sparseShape() {
        return this.sparseShape;
    }

    @OpInputsMetadata(outputsClass=DeserializeManySparse.class)
    public static class Inputs
    extends RawOpInputs<DeserializeManySparse<?>> {
        public final Operand<TString> serializedSparse;
        public final DataType dtype;

        public Inputs(GraphOperation op) {
            super(new DeserializeManySparse(op), op, Arrays.asList("dtype"));
            int inputIndex = 0;
            this.serializedSparse = op.input(inputIndex++);
            this.dtype = op.attributes().getAttrType("dtype");
        }
    }
}

