/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.sparse;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="DeserializeSparse", inputsClass=Inputs.class)
public final class DeserializeSparse<U extends TType>
extends RawOp {
    public static final String OP_NAME = "DeserializeSparse";
    private Output<TInt64> sparseIndices;
    private Output<U> sparseValues;
    private Output<TInt64> sparseShape;

    public DeserializeSparse(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.sparseIndices = operation.output(outputIdx++);
        this.sparseValues = operation.output(outputIdx++);
        this.sparseShape = operation.output(outputIdx++);
    }

    public static <U extends TType> DeserializeSparse<U> create(Scope scope, Operand<? extends TType> serializedSparse, Class<U> dtype) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(serializedSparse.asOutput());
        opBuilder.setAttr("dtype", Operands.toDataType(dtype));
        return new DeserializeSparse<U>(opBuilder.build());
    }

    public Output<TInt64> sparseIndices() {
        return this.sparseIndices;
    }

    public Output<U> sparseValues() {
        return this.sparseValues;
    }

    public Output<TInt64> sparseShape() {
        return this.sparseShape;
    }

    @OpInputsMetadata(outputsClass=DeserializeSparse.class)
    public static class Inputs
    extends RawOpInputs<DeserializeSparse<?>> {
        public final Operand<? extends TType> serializedSparse;
        public final DataType dtype;
        public final DataType Tserialized;

        public Inputs(GraphOperation op) {
            super(new DeserializeSparse(op), op, Arrays.asList("dtype", "Tserialized"));
            int inputIndex = 0;
            this.serializedSparse = op.input(inputIndex++);
            this.dtype = op.attributes().getAttrType("dtype");
            this.Tserialized = op.attributes().getAttrType("Tserialized");
        }
    }
}

