/*
 * Decompiled with CFR 0.152.
 */
package ai.picovoice.porcupine;

import ai.picovoice.porcupine.PorcupineException;
import ai.picovoice.porcupine.PorcupineInvalidArgumentException;
import ai.picovoice.porcupine.PorcupineRuntimeException;
import ai.picovoice.porcupine.Utils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Porcupine {
    private final long libraryHandle;
    public static final String LIBRARY_PATH = Utils.getPackagedLibraryPath();
    public static final String MODEL_PATH = Utils.getPackagedModelPath();
    public static final HashMap<BuiltInKeyword, String> BUILT_IN_KEYWORD_PATHS = Utils.getPackagedKeywordPaths();

    public Porcupine(String accessKey, String libraryPath, String modelPath, String[] keywordPaths, float[] sensitivities) throws PorcupineException {
        try {
            System.load(libraryPath);
        }
        catch (Exception exception) {
            throw new PorcupineException(exception);
        }
        this.libraryHandle = this.init(accessKey, modelPath, keywordPaths, sensitivities);
    }

    public void delete() {
        this.delete(this.libraryHandle);
    }

    public int process(short[] pcm) throws PorcupineException {
        return this.process(this.libraryHandle, pcm);
    }

    public native String getVersion();

    public native int getFrameLength();

    public native int getSampleRate();

    private native long init(String var1, String var2, String[] var3, float[] var4);

    private native void delete(long var1);

    private native int process(long var1, short[] var3);

    public static class Builder {
        private String accessKey = null;
        private String libraryPath = null;
        private String modelPath = null;
        private String[] keywordPaths = null;
        private BuiltInKeyword[] keywords = null;
        private float[] sensitivities = null;

        public Builder setAccessKey(String accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        public Builder setLibraryPath(String libraryPath) {
            this.libraryPath = libraryPath;
            return this;
        }

        public Builder setModelPath(String modelPath) {
            this.modelPath = modelPath;
            return this;
        }

        public Builder setKeywordPaths(String[] keywordPaths) {
            this.keywordPaths = keywordPaths;
            return this;
        }

        public Builder setKeywordPath(String keywordPaths) {
            this.keywordPaths = new String[]{keywordPaths};
            return this;
        }

        public Builder setBuiltInKeywords(BuiltInKeyword[] keywords) {
            this.keywords = keywords;
            return this;
        }

        public Builder setBuiltInKeyword(BuiltInKeyword keyword) {
            this.keywords = new BuiltInKeyword[]{keyword};
            return this;
        }

        public Builder setSensitivities(float[] sensitivities) {
            this.sensitivities = sensitivities;
            return this;
        }

        public Builder setSensitivity(float sensitivity) {
            this.sensitivities = new float[]{sensitivity};
            return this;
        }

        public Porcupine build() throws PorcupineException {
            if (!Utils.isEnvironmentSupported()) {
                throw new PorcupineRuntimeException("Could not initialize Porcupine. Execution environment not currently supported by Porcupine Java.");
            }
            if (this.accessKey == null) {
                throw new PorcupineInvalidArgumentException("AccessKey is required for Porcupine initialization.");
            }
            if (this.libraryPath == null) {
                if (Utils.isResourcesAvailable()) {
                    this.libraryPath = LIBRARY_PATH;
                } else {
                    throw new PorcupineInvalidArgumentException("Default library unavailable. Please provide a native Porcupine library path (-l <library_path>).");
                }
            }
            if (this.modelPath == null) {
                if (Utils.isResourcesAvailable()) {
                    this.modelPath = MODEL_PATH;
                } else {
                    throw new PorcupineInvalidArgumentException("Default model unavailable. Please provide a valid Porcupine model path (-m <model_path>).");
                }
            }
            if (this.keywordPaths != null && this.keywords != null) {
                throw new PorcupineInvalidArgumentException("Both 'keywords' and 'keywordPaths' were set. Only one of the two arguments may be set for initialization.");
            }
            if (this.keywordPaths == null) {
                if (this.keywords == null) {
                    throw new PorcupineInvalidArgumentException("Either 'keywords' or 'keywordPaths' must be set.");
                }
                if (Utils.isResourcesAvailable()) {
                    this.keywordPaths = new String[this.keywords.length];
                    for (int i = 0; i < this.keywords.length; ++i) {
                        this.keywordPaths[i] = BUILT_IN_KEYWORD_PATHS.get((Object)this.keywords[i]);
                    }
                } else {
                    throw new PorcupineInvalidArgumentException("BuiltIn keywords unavailable. Please provide a valid Porcupine keyword path.");
                }
            }
            if (this.sensitivities == null) {
                this.sensitivities = new float[this.keywordPaths.length];
                Arrays.fill(this.sensitivities, 0.5f);
            }
            if (this.sensitivities.length != this.keywordPaths.length) {
                throw new PorcupineInvalidArgumentException(String.format("Number of keywords (%d) does not match number of sensitivities (%d)", this.keywordPaths.length, this.sensitivities.length));
            }
            return new Porcupine(this.accessKey, this.libraryPath, this.modelPath, this.keywordPaths, this.sensitivities);
        }
    }

    public static enum BuiltInKeyword {
        ALEXA,
        AMERICANO,
        BLUEBERRY,
        BUMBLEBEE,
        COMPUTER,
        GRAPEFRUIT,
        GRASSHOPPER,
        HEY_GOOGLE,
        HEY_SIRI,
        JARVIS,
        OK_GOOGLE,
        PICOVOICE,
        PORCUPINE,
        TERMINATOR;


        public static Stream<BuiltInKeyword> stream() {
            return Stream.of(BuiltInKeyword.values());
        }

        public static String options() {
            return BuiltInKeyword.stream().map(v -> v.name()).collect(Collectors.joining(","));
        }
    }
}

