/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.s3;

import com.amazon.s3.CallingFormat;
import com.amazon.s3.GetResponse;
import com.amazon.s3.ListAllMyBucketsResponse;
import com.amazon.s3.ListBucketResponse;
import com.amazon.s3.Response;
import com.amazon.s3.S3Object;
import com.amazon.s3.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AWSAuthConnection {
    private String awsAccessKeyId;
    private String awsSecretAccessKey;
    private boolean isSecure;
    private String server;
    private int port;
    private CallingFormat callingFormat;

    public AWSAuthConnection(String awsAccessKeyId, String awsSecretAccessKey) {
        this(awsAccessKeyId, awsSecretAccessKey, true);
    }

    public AWSAuthConnection(String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure) {
        this(awsAccessKeyId, awsSecretAccessKey, isSecure, "s3.amazonaws.com");
    }

    public AWSAuthConnection(String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure, String server) {
        this(awsAccessKeyId, awsSecretAccessKey, isSecure, server, isSecure ? 443 : 80);
    }

    public AWSAuthConnection(String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure, String server, int port) {
        this(awsAccessKeyId, awsSecretAccessKey, isSecure, server, port, CallingFormat.getRegularCallingFormat());
    }

    public AWSAuthConnection(String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure, String server, int port, CallingFormat format) {
        this.awsAccessKeyId = awsAccessKeyId;
        this.awsSecretAccessKey = awsSecretAccessKey;
        this.isSecure = isSecure;
        this.server = server;
        this.port = port;
        this.callingFormat = format;
    }

    public Response createBucket(String bucket, Map<String, List<String>> headers) throws MalformedURLException, IOException {
        return new Response(this.makeRequest("PUT", bucket, "", null, headers));
    }

    public ListBucketResponse listBucket(String bucket, String prefix, String marker, Integer maxKeys, Map<String, List<String>> headers) throws MalformedURLException, IOException {
        return this.listBucket(bucket, prefix, marker, maxKeys, null, headers);
    }

    public ListBucketResponse listBucket(String bucket, String prefix, String marker, Integer maxKeys, String delimiter, Map<String, List<String>> headers) throws MalformedURLException, IOException {
        Map<String, String> pathArgs = Utils.paramsForListOptions(prefix, marker, maxKeys, delimiter);
        return new ListBucketResponse(this.makeRequest("GET", bucket, "", pathArgs, headers));
    }

    public Response deleteBucket(String bucket, Map<String, List<String>> headers) throws MalformedURLException, IOException {
        return new Response(this.makeRequest("DELETE", bucket, "", null, headers));
    }

    public Response put(String bucket, String key, S3Object object, Map<String, List<String>> headers) throws MalformedURLException, IOException {
        HttpURLConnection request = this.makeRequest("PUT", bucket, Utils.urlencode(key), null, headers, object);
        request.setDoOutput(true);
        this.writeToS3(object, request);
        return new Response(request);
    }

    public GetResponse get(String bucket, String key, Map<String, List<String>> headers) throws MalformedURLException, IOException {
        return new GetResponse(this.makeRequest("GET", bucket, Utils.urlencode(key), null, headers));
    }

    public Response delete(String bucket, String key, Map<String, List<String>> headers) throws MalformedURLException, IOException {
        return new Response(this.makeRequest("DELETE", bucket, Utils.urlencode(key), null, headers));
    }

    public GetResponse getBucketLogging(String bucket, Map<String, List<String>> headers) throws MalformedURLException, IOException {
        HashMap<String, String> pathArgs = new HashMap<String, String>();
        pathArgs.put("logging", null);
        return new GetResponse(this.makeRequest("GET", bucket, "", pathArgs, headers));
    }

    public Response putBucketLogging(String bucket, String loggingXMLDoc, Map<String, List<String>> headers) throws MalformedURLException, IOException {
        HashMap<String, String> pathArgs = new HashMap<String, String>();
        pathArgs.put("logging", null);
        S3Object object = new S3Object(new ByteArrayInputStream(loggingXMLDoc.getBytes()), null);
        HttpURLConnection request = this.makeRequest("PUT", bucket, "", pathArgs, headers, object);
        request.setDoOutput(true);
        this.writeToS3(object, request);
        return new Response(request);
    }

    public GetResponse getBucketACL(String bucket, Map<String, List<String>> headers) throws MalformedURLException, IOException {
        return this.getACL(bucket, "", headers);
    }

    public GetResponse getACL(String bucket, String key, Map<String, List<String>> headers) throws MalformedURLException, IOException {
        if (key == null) {
            key = "";
        }
        HashMap<String, String> pathArgs = new HashMap<String, String>();
        pathArgs.put("acl", null);
        return new GetResponse(this.makeRequest("GET", bucket, Utils.urlencode(key), pathArgs, headers));
    }

    public Response putBucketACL(String bucket, String aclXMLDoc, Map<String, List<String>> headers) throws MalformedURLException, IOException {
        return this.putACL(bucket, "", aclXMLDoc, headers);
    }

    public Response putACL(String bucket, String key, String aclXMLDoc, Map<String, List<String>> headers) throws MalformedURLException, IOException {
        S3Object object = new S3Object(new ByteArrayInputStream(aclXMLDoc.getBytes()), null);
        HashMap<String, String> pathArgs = new HashMap<String, String>();
        pathArgs.put("acl", null);
        HttpURLConnection request = this.makeRequest("PUT", bucket, Utils.urlencode(key), pathArgs, headers, object);
        request.setDoOutput(true);
        this.writeToS3(object, request);
        return new Response(request);
    }

    public ListAllMyBucketsResponse listAllMyBuckets(Map<String, List<String>> headers) throws MalformedURLException, IOException {
        return new ListAllMyBucketsResponse(this.makeRequest("GET", "", "", null, headers));
    }

    private HttpURLConnection makeRequest(String method, String bucketName, String key, Map<String, String> pathArgs, Map<String, List<String>> headers) throws MalformedURLException, IOException {
        return this.makeRequest(method, bucketName, key, pathArgs, headers, null);
    }

    private HttpURLConnection makeRequest(String method, String bucket, String key, Map<String, String> pathArgs, Map<String, List<String>> headers, S3Object object) throws MalformedURLException, IOException {
        URL url = this.callingFormat.getURL(this.isSecure, this.server, this.port, bucket, key, pathArgs);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(method);
        this.addHeaders(connection, headers);
        if (object != null) {
            this.addMetadataHeaders(connection, object.getMetadata());
        }
        this.addAuthHeader(connection, method, bucket, key, pathArgs);
        return connection;
    }

    private void addHeaders(HttpURLConnection connection, Map<String, List<String>> headers) {
        this.addHeaders(connection, headers, "");
    }

    private void addMetadataHeaders(HttpURLConnection connection, Map<String, List<String>> metadata) {
        this.addHeaders(connection, metadata, "x-amz-meta-");
    }

    private void addHeaders(HttpURLConnection connection, Map<String, List<String>> headers, String prefix) {
        if (headers != null) {
            for (String key : headers.keySet()) {
                for (String value : headers.get(key)) {
                    connection.addRequestProperty(String.valueOf(prefix) + key, value);
                }
            }
        }
    }

    private void addAuthHeader(HttpURLConnection connection, String method, String bucket, String key, Map<String, String> pathArgs) {
        if (connection.getRequestProperty("Date") == null) {
            connection.setRequestProperty("Date", AWSAuthConnection.httpDate());
        }
        if (connection.getRequestProperty("Content-Type") == null) {
            connection.setRequestProperty("Content-Type", "");
        }
        String canonicalString = Utils.makeCanonicalString(method, bucket, key, pathArgs, connection.getRequestProperties());
        String encodedCanonical = Utils.encode(this.awsSecretAccessKey, canonicalString, false);
        connection.setRequestProperty("Authorization", "AWS " + this.awsAccessKeyId + ":" + encodedCanonical);
    }

    public static String httpDate() {
        String DateFormat2 = "EEE, dd MMM yyyy HH:mm:ss ";
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss ", Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return String.valueOf(format.format(new Date())) + "GMT";
    }

    private void writeToS3(S3Object object, HttpURLConnection request) throws IOException {
        InputStream in = object.getStream();
        OutputStream out = request.getOutputStream();
        int rd = -1;
        byte[] buff = new byte[4096];
        while ((rd = in.read(buff)) != -1) {
            out.write(buff, 0, rd);
        }
        out.close();
    }
}

