/*
 * Decompiled with CFR 0.152.
 */
package android.arch.lifecycle;

import android.arch.core.executor.ArchTaskExecutor;
import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.Observer;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class LiveDataReactiveStreams {
    private LiveDataReactiveStreams() {
    }

    @NonNull
    public static <T> Publisher<T> toPublisher(@NonNull LifecycleOwner lifecycle, @NonNull LiveData<T> liveData) {
        return new LiveDataPublisher<T>(lifecycle, liveData);
    }

    @NonNull
    public static <T> LiveData<T> fromPublisher(@NonNull Publisher<T> publisher) {
        return new PublisherLiveData<T>(publisher);
    }

    private static class PublisherLiveData<T>
    extends LiveData<T> {
        private final Publisher<T> mPublisher;
        final AtomicReference<LiveDataSubscriber> mSubscriber;

        PublisherLiveData(@NonNull Publisher<T> publisher) {
            this.mPublisher = publisher;
            this.mSubscriber = new AtomicReference();
        }

        protected void onActive() {
            super.onActive();
            LiveDataSubscriber s = new LiveDataSubscriber();
            this.mSubscriber.set(s);
            this.mPublisher.subscribe((Subscriber)s);
        }

        protected void onInactive() {
            super.onInactive();
            LiveDataSubscriber s = this.mSubscriber.getAndSet(null);
            if (s != null) {
                s.cancelSubscription();
            }
        }

        final class LiveDataSubscriber
        extends AtomicReference<Subscription>
        implements Subscriber<T> {
            LiveDataSubscriber() {
            }

            public void onSubscribe(Subscription s) {
                if (this.compareAndSet(null, s)) {
                    s.request(Long.MAX_VALUE);
                } else {
                    s.cancel();
                }
            }

            public void onNext(T item) {
                PublisherLiveData.this.postValue(item);
            }

            public void onError(final Throwable ex) {
                PublisherLiveData.this.mSubscriber.compareAndSet(this, null);
                ArchTaskExecutor.getInstance().executeOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        throw new RuntimeException("LiveData does not handle errors. Errors from publishers should be handled upstream and propagated as state", ex);
                    }
                });
            }

            public void onComplete() {
                PublisherLiveData.this.mSubscriber.compareAndSet(this, null);
            }

            public void cancelSubscription() {
                Subscription s = (Subscription)this.get();
                if (s != null) {
                    s.cancel();
                }
            }
        }
    }

    private static final class LiveDataPublisher<T>
    implements Publisher<T> {
        final LifecycleOwner mLifecycle;
        final LiveData<T> mLiveData;

        LiveDataPublisher(LifecycleOwner lifecycle, LiveData<T> liveData) {
            this.mLifecycle = lifecycle;
            this.mLiveData = liveData;
        }

        public void subscribe(Subscriber<? super T> subscriber) {
            subscriber.onSubscribe(new LiveDataSubscription<T>(subscriber, this.mLifecycle, this.mLiveData));
        }

        static final class LiveDataSubscription<T>
        implements Subscription,
        Observer<T> {
            final Subscriber<? super T> mSubscriber;
            final LifecycleOwner mLifecycle;
            final LiveData<T> mLiveData;
            volatile boolean mCanceled;
            boolean mObserving;
            long mRequested;
            @Nullable
            T mLatest;

            LiveDataSubscription(Subscriber<? super T> subscriber, LifecycleOwner lifecycle, LiveData<T> liveData) {
                this.mSubscriber = subscriber;
                this.mLifecycle = lifecycle;
                this.mLiveData = liveData;
            }

            public void onChanged(@Nullable T t) {
                if (this.mCanceled) {
                    return;
                }
                if (this.mRequested > 0L) {
                    this.mLatest = null;
                    this.mSubscriber.onNext(t);
                    if (this.mRequested != Long.MAX_VALUE) {
                        --this.mRequested;
                    }
                } else {
                    this.mLatest = t;
                }
            }

            public void request(final long n) {
                if (this.mCanceled) {
                    return;
                }
                ArchTaskExecutor.getInstance().executeOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        if (LiveDataSubscription.this.mCanceled) {
                            return;
                        }
                        if (n <= 0L) {
                            LiveDataSubscription.this.mCanceled = true;
                            if (LiveDataSubscription.this.mObserving) {
                                LiveDataSubscription.this.mLiveData.removeObserver((Observer)LiveDataSubscription.this);
                                LiveDataSubscription.this.mObserving = false;
                            }
                            LiveDataSubscription.this.mLatest = null;
                            LiveDataSubscription.this.mSubscriber.onError((Throwable)new IllegalArgumentException("Non-positive request"));
                            return;
                        }
                        long l = LiveDataSubscription.this.mRequested = LiveDataSubscription.this.mRequested + n >= LiveDataSubscription.this.mRequested ? LiveDataSubscription.this.mRequested + n : Long.MAX_VALUE;
                        if (!LiveDataSubscription.this.mObserving) {
                            LiveDataSubscription.this.mObserving = true;
                            LiveDataSubscription.this.mLiveData.observe(LiveDataSubscription.this.mLifecycle, (Observer)LiveDataSubscription.this);
                        } else if (LiveDataSubscription.this.mLatest != null) {
                            LiveDataSubscription.this.onChanged(LiveDataSubscription.this.mLatest);
                            LiveDataSubscription.this.mLatest = null;
                        }
                    }
                });
            }

            public void cancel() {
                if (this.mCanceled) {
                    return;
                }
                this.mCanceled = true;
                ArchTaskExecutor.getInstance().executeOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        if (LiveDataSubscription.this.mObserving) {
                            LiveDataSubscription.this.mLiveData.removeObserver((Observer)LiveDataSubscription.this);
                            LiveDataSubscription.this.mObserving = false;
                        }
                        LiveDataSubscription.this.mLatest = null;
                    }
                });
            }
        }
    }
}

