/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.os.Bundle;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import androidx.navigation.NavDestination;
import androidx.navigation.NavOptions;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class Navigator<D extends NavDestination> {
    public static final int BACK_STACK_UNCHANGED = 0;
    public static final int BACK_STACK_DESTINATION_ADDED = 1;
    public static final int BACK_STACK_DESTINATION_POPPED = 2;
    private final CopyOnWriteArrayList<OnNavigatorNavigatedListener> mOnNavigatedListeners = new CopyOnWriteArrayList();

    @NonNull
    public abstract D createDestination();

    public abstract void navigate(@NonNull D var1, @Nullable Bundle var2, @Nullable NavOptions var3);

    public abstract boolean popBackStack();

    public final void addOnNavigatorNavigatedListener(@NonNull OnNavigatorNavigatedListener listener) {
        this.mOnNavigatedListeners.add(listener);
    }

    public final void removeOnNavigatorNavigatedListener(@NonNull OnNavigatorNavigatedListener listener) {
        this.mOnNavigatedListeners.remove(listener);
    }

    public final void dispatchOnNavigatorNavigated(@IdRes int destId, int backStackEffect) {
        for (OnNavigatorNavigatedListener listener : this.mOnNavigatedListeners) {
            listener.onNavigatorNavigated(this, destId, backStackEffect);
        }
    }

    public static interface OnNavigatorNavigatedListener {
        public void onNavigatorNavigated(@NonNull Navigator var1, @IdRes int var2, int var3);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Name {
        public String value();
    }
}

