/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import androidx.navigation.NavDestination;
import androidx.navigation.NavGraph;
import androidx.navigation.NavOptions;
import androidx.navigation.Navigator;

@Navigator.Name(value="navigation")
public class NavGraphNavigator
extends Navigator<NavGraph> {
    private Context mContext;

    public NavGraphNavigator(@NonNull Context context) {
        this.mContext = context;
    }

    @Override
    @NonNull
    public NavGraph createDestination() {
        return new NavGraph(this);
    }

    @Override
    public void navigate(@NonNull NavGraph destination, @Nullable Bundle args, @Nullable NavOptions navOptions) {
        int startId = destination.getStartDestination();
        if (startId == 0) {
            throw new IllegalStateException("no start destination defined via app:startDestination for " + (destination.getId() != 0 ? NavDestination.getDisplayName(this.mContext, destination.getId()) : "the root navigation"));
        }
        NavDestination startDestination = destination.findNode(startId, false);
        if (startDestination == null) {
            String dest = NavDestination.getDisplayName(this.mContext, startId);
            throw new IllegalArgumentException("navigation destination " + dest + " is not a direct child of this NavGraph");
        }
        this.dispatchOnNavigatorNavigated(destination.getId(), 1);
        startDestination.navigate(args, navOptions);
    }

    @Override
    public boolean popBackStack() {
        return false;
    }
}

