/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import androidx.navigation.NavDestination;
import androidx.navigation.NavOptions;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class Navigator<D extends NavDestination> {
    private final CopyOnWriteArrayList<OnNavigatorBackPressListener> mOnBackPressListeners = new CopyOnWriteArrayList();

    @NonNull
    public abstract D createDestination();

    @Nullable
    public abstract NavDestination navigate(@NonNull D var1, @Nullable Bundle var2, @Nullable NavOptions var3, @Nullable Extras var4);

    public abstract boolean popBackStack();

    @Nullable
    public Bundle onSaveState() {
        return null;
    }

    public void onRestoreState(@NonNull Bundle savedState) {
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected void onBackPressAdded() {
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected void onBackPressRemoved() {
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void addOnNavigatorBackPressListener(@NonNull OnNavigatorBackPressListener listener) {
        boolean added = this.mOnBackPressListeners.add(listener);
        if (added && this.mOnBackPressListeners.size() == 1) {
            this.onBackPressAdded();
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void removeOnNavigatorBackPressListener(@NonNull OnNavigatorBackPressListener listener) {
        boolean removed = this.mOnBackPressListeners.remove(listener);
        if (removed && this.mOnBackPressListeners.isEmpty()) {
            this.onBackPressRemoved();
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final void dispatchOnNavigatorBackPress() {
        for (OnNavigatorBackPressListener listener : this.mOnBackPressListeners) {
            listener.onPopBackStack(this);
        }
    }

    public static interface Extras {
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static interface OnNavigatorBackPressListener {
        public void onPopBackStack(@NonNull Navigator var1);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Name {
        public String value();
    }
}

