/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import androidx.navigation.NavType;

public final class NavArgument {
    @NonNull
    private final NavType mType;
    private final boolean mIsNullable;
    private final boolean mDefaultValuePresent;
    @Nullable
    private final Object mDefaultValue;

    NavArgument(@NonNull NavType<?> type, boolean isNullable, @Nullable Object defaultValue, boolean defaultValuePresent) {
        if (!type.isNullableAllowed() && isNullable) {
            throw new IllegalArgumentException(type.getName() + " does not allow nullable values");
        }
        if (!isNullable && defaultValuePresent && defaultValue == null) {
            throw new IllegalArgumentException("Argument with type " + type.getName() + " has null value but is not nullable.");
        }
        this.mType = type;
        this.mIsNullable = isNullable;
        this.mDefaultValue = defaultValue;
        this.mDefaultValuePresent = defaultValuePresent;
    }

    public boolean isDefaultValuePresent() {
        return this.mDefaultValuePresent;
    }

    @NonNull
    public NavType<?> getType() {
        return this.mType;
    }

    public boolean isNullable() {
        return this.mIsNullable;
    }

    @Nullable
    public Object getDefaultValue() {
        return this.mDefaultValue;
    }

    void putDefaultValue(@NonNull String name, @NonNull Bundle bundle) {
        if (this.mDefaultValuePresent) {
            this.mType.put(bundle, name, this.mDefaultValue);
        }
    }

    boolean verify(@NonNull String name, @NonNull Bundle bundle) {
        if (!this.mIsNullable && bundle.containsKey(name) && bundle.get(name) == null) {
            return false;
        }
        try {
            this.mType.get(bundle, name);
        }
        catch (ClassCastException e) {
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NavArgument that = (NavArgument)o;
        if (this.mIsNullable != that.mIsNullable) {
            return false;
        }
        if (this.mDefaultValuePresent != that.mDefaultValuePresent) {
            return false;
        }
        if (!this.mType.equals(that.mType)) {
            return false;
        }
        return this.mDefaultValue != null ? this.mDefaultValue.equals(that.mDefaultValue) : that.mDefaultValue == null;
    }

    public int hashCode() {
        int result = this.mType.hashCode();
        result = 31 * result + (this.mIsNullable ? 1 : 0);
        result = 31 * result + (this.mDefaultValuePresent ? 1 : 0);
        result = 31 * result + (this.mDefaultValue != null ? this.mDefaultValue.hashCode() : 0);
        return result;
    }

    public static final class Builder {
        @Nullable
        private NavType<?> mType;
        private boolean mIsNullable = false;
        @Nullable
        private Object mDefaultValue;
        private boolean mDefaultValuePresent = false;

        @NonNull
        public Builder setType(@NonNull NavType<?> type) {
            this.mType = type;
            return this;
        }

        @NonNull
        public Builder setIsNullable(boolean isNullable) {
            this.mIsNullable = isNullable;
            return this;
        }

        @NonNull
        public Builder setDefaultValue(@Nullable Object defaultValue) {
            this.mDefaultValue = defaultValue;
            this.mDefaultValuePresent = true;
            return this;
        }

        @NonNull
        public NavArgument build() {
            if (this.mType == null) {
                this.mType = NavType.inferFromValueType(this.mDefaultValue);
            }
            return new NavArgument(this.mType, this.mIsNullable, this.mDefaultValue, this.mDefaultValuePresent);
        }
    }
}

