/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.annotation.SuppressLint;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import androidx.navigation.NavDestination;
import androidx.navigation.Navigator;
import java.util.HashMap;
import java.util.Map;

@SuppressLint(value={"TypeParameterUnusedInFormals"})
public class NavigatorProvider {
    private static final HashMap<Class, String> sAnnotationNames = new HashMap();
    private final HashMap<String, Navigator<? extends NavDestination>> mNavigators = new HashMap();

    private static boolean validateName(String name) {
        return name != null && !name.isEmpty();
    }

    @NonNull
    static String getNameForNavigator(@NonNull Class<? extends Navigator> navigatorClass) {
        String name = sAnnotationNames.get(navigatorClass);
        if (name == null) {
            Navigator.Name annotation = navigatorClass.getAnnotation(Navigator.Name.class);
            String string = name = annotation != null ? annotation.value() : null;
            if (!NavigatorProvider.validateName(name)) {
                throw new IllegalArgumentException("No @Navigator.Name annotation found for " + navigatorClass.getSimpleName());
            }
            sAnnotationNames.put(navigatorClass, name);
        }
        return name;
    }

    @NonNull
    public final <T extends Navigator<?>> T getNavigator(@NonNull Class<T> navigatorClass) {
        String name = NavigatorProvider.getNameForNavigator(navigatorClass);
        return this.getNavigator(name);
    }

    @CallSuper
    @NonNull
    public <T extends Navigator<?>> T getNavigator(@NonNull String name) {
        if (!NavigatorProvider.validateName(name)) {
            throw new IllegalArgumentException("navigator name cannot be an empty string");
        }
        Navigator<? extends NavDestination> navigator = this.mNavigators.get(name);
        if (navigator == null) {
            throw new IllegalStateException("Could not find Navigator with name \"" + name + "\". You must call NavController.addNavigator() for each navigation type.");
        }
        return (T)navigator;
    }

    @Nullable
    public final Navigator<? extends NavDestination> addNavigator(@NonNull Navigator<? extends NavDestination> navigator) {
        String name = NavigatorProvider.getNameForNavigator(navigator.getClass());
        return this.addNavigator(name, navigator);
    }

    @CallSuper
    @Nullable
    public Navigator<? extends NavDestination> addNavigator(@NonNull String name, @NonNull Navigator<? extends NavDestination> navigator) {
        if (!NavigatorProvider.validateName(name)) {
            throw new IllegalArgumentException("navigator name cannot be an empty string");
        }
        return this.mNavigators.put(name, navigator);
    }

    Map<String, Navigator<? extends NavDestination>> getNavigators() {
        return this.mNavigators;
    }
}

