/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.fragment;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.util.AttributeSet;
import androidx.navigation.NavDestination;
import androidx.navigation.NavOptions;
import androidx.navigation.Navigator;
import androidx.navigation.NavigatorProvider;
import androidx.navigation.fragment.R;
import java.util.ArrayDeque;
import java.util.HashMap;

@Navigator.Name(value="fragment")
public class FragmentNavigator
extends Navigator<Destination> {
    private static final String KEY_BACK_STACK_IDS = "androidx-nav-fragment:navigator:backStackIds";
    private Context mContext;
    private FragmentManager mFragmentManager;
    private int mContainerId;
    private ArrayDeque<Integer> mBackStack = new ArrayDeque();
    private final FragmentManager.OnBackStackChangedListener mOnBackStackChangedListener = new FragmentManager.OnBackStackChangedListener(){

        public void onBackStackChanged() {
            int newCount = FragmentNavigator.this.mFragmentManager.getBackStackEntryCount() + 1;
            if (newCount < FragmentNavigator.this.mBackStack.size()) {
                while (FragmentNavigator.this.mBackStack.size() > newCount) {
                    FragmentNavigator.this.mBackStack.removeLast();
                }
                int destId = FragmentNavigator.this.mBackStack.isEmpty() ? 0 : (Integer)FragmentNavigator.this.mBackStack.peekLast();
                FragmentNavigator.this.dispatchOnNavigatorNavigated(destId, 2);
            }
        }
    };

    public FragmentNavigator(@NonNull Context context, @NonNull FragmentManager manager, int containerId) {
        this.mContext = context;
        this.mFragmentManager = manager;
        this.mContainerId = containerId;
        this.mFragmentManager.addOnBackStackChangedListener(this.mOnBackStackChangedListener);
    }

    public boolean popBackStack() {
        if (this.mFragmentManager.getBackStackEntryCount() == 0) {
            return false;
        }
        this.mFragmentManager.popBackStack();
        this.mBackStack.removeLast();
        int destId = this.mBackStack.isEmpty() ? 0 : this.mBackStack.peekLast();
        this.dispatchOnNavigatorNavigated(destId, 2);
        return true;
    }

    @NonNull
    public Destination createDestination() {
        return new Destination(this);
    }

    @NonNull
    private String getBackStackName(@IdRes int destinationId) {
        try {
            return this.mContext.getResources().getResourceName(destinationId);
        }
        catch (Resources.NotFoundException e) {
            return Integer.toString(destinationId);
        }
    }

    public void navigate(@NonNull Destination destination, @Nullable Bundle args, @Nullable NavOptions navOptions) {
        int backStackEffect;
        boolean isSingleTopReplacement;
        int popExitAnim;
        Fragment frag = destination.createFragment(args);
        FragmentTransaction ft = this.mFragmentManager.beginTransaction();
        int enterAnim = navOptions != null ? navOptions.getEnterAnim() : -1;
        int exitAnim = navOptions != null ? navOptions.getExitAnim() : -1;
        int popEnterAnim = navOptions != null ? navOptions.getPopEnterAnim() : -1;
        int n = popExitAnim = navOptions != null ? navOptions.getPopExitAnim() : -1;
        if (enterAnim != -1 || exitAnim != -1 || popEnterAnim != -1 || popExitAnim != -1) {
            enterAnim = enterAnim != -1 ? enterAnim : 0;
            exitAnim = exitAnim != -1 ? exitAnim : 0;
            popEnterAnim = popEnterAnim != -1 ? popEnterAnim : 0;
            popExitAnim = popExitAnim != -1 ? popExitAnim : 0;
            ft.setCustomAnimations(enterAnim, exitAnim, popEnterAnim, popExitAnim);
        }
        ft.replace(this.mContainerId, frag);
        int destId = destination.getId();
        boolean initialNavigation = this.mBackStack.isEmpty();
        boolean isClearTask = navOptions != null && navOptions.shouldClearTask();
        boolean bl = isSingleTopReplacement = navOptions != null && !initialNavigation && navOptions.shouldLaunchSingleTop() && this.mBackStack.peekLast() == destId;
        if (!(initialNavigation || isClearTask || isSingleTopReplacement)) {
            ft.addToBackStack(this.getBackStackName(destId));
            backStackEffect = 1;
        } else if (isSingleTopReplacement) {
            if (this.mBackStack.size() > 1) {
                this.mFragmentManager.popBackStack();
                ft.addToBackStack(this.getBackStackName(destId));
            }
            backStackEffect = 0;
        } else {
            backStackEffect = 1;
        }
        ft.setReorderingAllowed(true);
        ft.commit();
        if (initialNavigation || !isSingleTopReplacement) {
            this.mBackStack.add(destId);
        }
        this.dispatchOnNavigatorNavigated(destId, backStackEffect);
    }

    @Nullable
    public Bundle onSaveState() {
        Bundle b = new Bundle();
        int[] backStack = new int[this.mBackStack.size()];
        int index = 0;
        for (Integer id : this.mBackStack) {
            backStack[index++] = id;
        }
        b.putIntArray(KEY_BACK_STACK_IDS, backStack);
        return b;
    }

    public void onRestoreState(@Nullable Bundle savedState) {
        int[] backStack;
        if (savedState != null && (backStack = savedState.getIntArray(KEY_BACK_STACK_IDS)) != null) {
            for (int destId : backStack) {
                this.mBackStack.add(destId);
            }
        }
    }

    public static class Destination
    extends NavDestination {
        private static final HashMap<String, Class<? extends Fragment>> sFragmentClasses = new HashMap();
        private Class<? extends Fragment> mFragmentClass;

        public Destination(@NonNull NavigatorProvider navigatorProvider) {
            this((Navigator<? extends Destination>)navigatorProvider.getNavigator(FragmentNavigator.class));
        }

        public Destination(@NonNull Navigator<? extends Destination> fragmentNavigator) {
            super(fragmentNavigator);
        }

        public void onInflate(@NonNull Context context, @NonNull AttributeSet attrs) {
            super.onInflate(context, attrs);
            TypedArray a = context.getResources().obtainAttributes(attrs, R.styleable.FragmentNavigator);
            this.setFragmentClass(this.getFragmentClassByName(context, a.getString(R.styleable.FragmentNavigator_android_name)));
            a.recycle();
        }

        @NonNull
        private Class<? extends Fragment> getFragmentClassByName(Context context, String name) {
            Class<Object> clazz;
            if (name != null && name.charAt(0) == '.') {
                name = context.getPackageName() + name;
            }
            if ((clazz = sFragmentClasses.get(name)) == null) {
                try {
                    clazz = Class.forName(name, true, context.getClassLoader());
                    sFragmentClasses.put(name, clazz);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            return clazz;
        }

        @NonNull
        public Destination setFragmentClass(@NonNull Class<? extends Fragment> clazz) {
            this.mFragmentClass = clazz;
            return this;
        }

        public Class<? extends Fragment> getFragmentClass() {
            return this.mFragmentClass;
        }

        @NonNull
        public Fragment createFragment(@Nullable Bundle args) {
            Fragment f;
            Class<? extends Fragment> clazz = this.getFragmentClass();
            if (clazz == null) {
                throw new IllegalStateException("fragment class not set");
            }
            try {
                f = clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (args != null) {
                f.setArguments(args);
            }
            return f;
        }
    }
}

