/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.fragment;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.util.AttributeSet;
import android.util.Log;
import androidx.navigation.NavDestination;
import androidx.navigation.NavOptions;
import androidx.navigation.Navigator;
import androidx.navigation.NavigatorProvider;
import androidx.navigation.fragment.R;
import java.util.ArrayDeque;
import java.util.Iterator;

@Navigator.Name(value="fragment")
public class FragmentNavigator
extends Navigator<Destination> {
    private static final String TAG = "FragmentNavigator";
    private static final String KEY_BACK_STACK_IDS = "androidx-nav-fragment:navigator:backStackIds";
    private Context mContext;
    FragmentManager mFragmentManager;
    private int mContainerId;
    ArrayDeque<Integer> mBackStack = new ArrayDeque();
    boolean mIsPendingBackStackOperation = false;
    private final FragmentManager.OnBackStackChangedListener mOnBackStackChangedListener = new FragmentManager.OnBackStackChangedListener(){

        public void onBackStackChanged() {
            if (FragmentNavigator.this.mIsPendingBackStackOperation) {
                FragmentNavigator.this.mIsPendingBackStackOperation = !FragmentNavigator.this.isBackStackEqual();
                return;
            }
            int newCount = FragmentNavigator.this.mFragmentManager.getBackStackEntryCount() + 1;
            if (newCount < FragmentNavigator.this.mBackStack.size()) {
                while (FragmentNavigator.this.mBackStack.size() > newCount) {
                    FragmentNavigator.this.mBackStack.removeLast();
                }
                int destId = FragmentNavigator.this.mBackStack.isEmpty() ? 0 : FragmentNavigator.this.mBackStack.peekLast();
                FragmentNavigator.this.dispatchOnNavigatorNavigated(destId, 2);
            }
        }
    };

    public FragmentNavigator(@NonNull Context context, @NonNull FragmentManager manager, int containerId) {
        this.mContext = context;
        this.mFragmentManager = manager;
        this.mContainerId = containerId;
    }

    public void onActive() {
        this.mFragmentManager.addOnBackStackChangedListener(this.mOnBackStackChangedListener);
    }

    public void onInactive() {
        this.mFragmentManager.removeOnBackStackChangedListener(this.mOnBackStackChangedListener);
    }

    public boolean popBackStack() {
        if (this.mBackStack.isEmpty()) {
            return false;
        }
        if (this.mFragmentManager.isStateSaved()) {
            Log.i((String)TAG, (String)"Ignoring popBackStack() call: FragmentManager has already saved its state");
            return false;
        }
        boolean popped = false;
        if (this.mFragmentManager.getBackStackEntryCount() > 0) {
            this.mFragmentManager.popBackStack();
            this.mIsPendingBackStackOperation = true;
            popped = true;
        }
        this.mBackStack.removeLast();
        int destId = this.mBackStack.isEmpty() ? 0 : this.mBackStack.peekLast();
        this.dispatchOnNavigatorNavigated(destId, 2);
        return popped;
    }

    @NonNull
    public Destination createDestination() {
        return new Destination(this);
    }

    public void navigate(@NonNull Destination destination, @Nullable Bundle args, @Nullable NavOptions navOptions) {
        int backStackEffect;
        boolean isSingleTopReplacement;
        int popExitAnim;
        if (this.mFragmentManager.isStateSaved()) {
            Log.i((String)TAG, (String)"Ignoring navigate() call: FragmentManager has already saved its state");
            return;
        }
        Fragment frag = destination.createFragment(args);
        FragmentTransaction ft = this.mFragmentManager.beginTransaction();
        int enterAnim = navOptions != null ? navOptions.getEnterAnim() : -1;
        int exitAnim = navOptions != null ? navOptions.getExitAnim() : -1;
        int popEnterAnim = navOptions != null ? navOptions.getPopEnterAnim() : -1;
        int n = popExitAnim = navOptions != null ? navOptions.getPopExitAnim() : -1;
        if (enterAnim != -1 || exitAnim != -1 || popEnterAnim != -1 || popExitAnim != -1) {
            enterAnim = enterAnim != -1 ? enterAnim : 0;
            exitAnim = exitAnim != -1 ? exitAnim : 0;
            popEnterAnim = popEnterAnim != -1 ? popEnterAnim : 0;
            popExitAnim = popExitAnim != -1 ? popExitAnim : 0;
            ft.setCustomAnimations(enterAnim, exitAnim, popEnterAnim, popExitAnim);
        }
        ft.replace(this.mContainerId, frag);
        ft.setPrimaryNavigationFragment(frag);
        int destId = destination.getId();
        boolean initialNavigation = this.mBackStack.isEmpty();
        boolean isClearTask = navOptions != null && navOptions.shouldClearTask();
        boolean bl = isSingleTopReplacement = navOptions != null && !initialNavigation && navOptions.shouldLaunchSingleTop() && this.mBackStack.peekLast() == destId;
        if (initialNavigation || isClearTask) {
            backStackEffect = 1;
        } else if (isSingleTopReplacement) {
            if (this.mBackStack.size() > 1) {
                this.mFragmentManager.popBackStack();
                ft.addToBackStack(Integer.toString(destId));
                this.mIsPendingBackStackOperation = true;
            }
            backStackEffect = 0;
        } else {
            ft.addToBackStack(Integer.toString(destId));
            this.mIsPendingBackStackOperation = true;
            backStackEffect = 1;
        }
        ft.setReorderingAllowed(true);
        ft.commit();
        if (backStackEffect == 1) {
            this.mBackStack.add(destId);
        }
        this.dispatchOnNavigatorNavigated(destId, backStackEffect);
    }

    @Nullable
    public Bundle onSaveState() {
        Bundle b = new Bundle();
        int[] backStack = new int[this.mBackStack.size()];
        int index = 0;
        for (Integer id : this.mBackStack) {
            backStack[index++] = id;
        }
        b.putIntArray(KEY_BACK_STACK_IDS, backStack);
        return b;
    }

    public void onRestoreState(@Nullable Bundle savedState) {
        int[] backStack;
        if (savedState != null && (backStack = savedState.getIntArray(KEY_BACK_STACK_IDS)) != null) {
            this.mBackStack.clear();
            for (int destId : backStack) {
                this.mBackStack.add(destId);
            }
        }
    }

    boolean isBackStackEqual() {
        int fragmentBackStackCount = this.mFragmentManager.getBackStackEntryCount();
        if (this.mBackStack.size() != fragmentBackStackCount + 1) {
            return false;
        }
        Iterator<Integer> backStackIterator = this.mBackStack.descendingIterator();
        int fragmentBackStackIndex = fragmentBackStackCount - 1;
        while (backStackIterator.hasNext() && fragmentBackStackIndex >= 0) {
            int fragmentDestId;
            int destId = backStackIterator.next();
            if (destId == (fragmentDestId = Integer.valueOf(this.mFragmentManager.getBackStackEntryAt(fragmentBackStackIndex--).getName()).intValue())) continue;
            return false;
        }
        return true;
    }

    public static class Destination
    extends NavDestination {
        private Class<? extends Fragment> mFragmentClass;

        public Destination(@NonNull NavigatorProvider navigatorProvider) {
            this((Navigator<? extends Destination>)navigatorProvider.getNavigator(FragmentNavigator.class));
        }

        public Destination(@NonNull Navigator<? extends Destination> fragmentNavigator) {
            super(fragmentNavigator);
        }

        public void onInflate(@NonNull Context context, @NonNull AttributeSet attrs) {
            super.onInflate(context, attrs);
            TypedArray a = context.getResources().obtainAttributes(attrs, R.styleable.FragmentNavigator);
            String className = a.getString(R.styleable.FragmentNavigator_android_name);
            if (className != null) {
                this.setFragmentClass(Destination.parseClassFromName((Context)context, (String)className, Fragment.class));
            }
            a.recycle();
        }

        @NonNull
        public Destination setFragmentClass(@NonNull Class<? extends Fragment> clazz) {
            this.mFragmentClass = clazz;
            return this;
        }

        @NonNull
        public Class<? extends Fragment> getFragmentClass() {
            if (this.mFragmentClass == null) {
                throw new IllegalStateException("fragment class not set");
            }
            return this.mFragmentClass;
        }

        @NonNull
        public Fragment createFragment(@Nullable Bundle args) {
            Fragment f;
            Class<? extends Fragment> clazz = this.getFragmentClass();
            try {
                f = clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (args != null) {
                f.setArguments(args);
            }
            return f;
        }
    }
}

