/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.res.TypedArray;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import androidx.navigation.NavDestination;
import androidx.navigation.NavOptions;
import androidx.navigation.Navigator;
import androidx.navigation.NavigatorProvider;
import androidx.navigation.R;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Navigator.Name(value="activity")
public class ActivityNavigator
extends Navigator<Destination> {
    private static final String EXTRA_NAV_SOURCE = "android-support-navigation:ActivityNavigator:source";
    private static final String EXTRA_NAV_CURRENT = "android-support-navigation:ActivityNavigator:current";
    private Context mContext;
    private Activity mHostActivity;

    public ActivityNavigator(@NonNull Context context) {
        this.mContext = context;
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                this.mHostActivity = (Activity)context;
                break;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
    }

    @NonNull
    Context getContext() {
        return this.mContext;
    }

    @NonNull
    public Destination createDestination() {
        return new Destination(this);
    }

    public boolean popBackStack() {
        if (this.mHostActivity != null) {
            int destId = 0;
            Intent intent = this.mHostActivity.getIntent();
            if (intent != null) {
                destId = intent.getIntExtra(EXTRA_NAV_SOURCE, 0);
            }
            this.mHostActivity.finish();
            this.dispatchOnNavigatorNavigated(destId, 2);
            return true;
        }
        return false;
    }

    public void navigate(@NonNull Destination destination, @Nullable Bundle args, @Nullable NavOptions navOptions) {
        int hostCurrentId;
        Intent hostIntent;
        if (destination.getIntent() == null) {
            throw new IllegalStateException("Destination " + destination.getId() + " does not have an Intent set.");
        }
        Intent intent = new Intent(destination.getIntent());
        if (args != null) {
            intent.putExtras(args);
            String dataPattern = destination.getDataPattern();
            if (!TextUtils.isEmpty((CharSequence)dataPattern)) {
                StringBuffer data = new StringBuffer();
                Pattern fillInPattern = Pattern.compile("\\{(.+?)\\}");
                Matcher matcher = fillInPattern.matcher(dataPattern);
                while (matcher.find()) {
                    String argName = matcher.group(1);
                    if (args.containsKey(argName)) {
                        matcher.appendReplacement(data, "");
                        data.append(Uri.encode((String)args.getString(argName)));
                        continue;
                    }
                    throw new IllegalArgumentException("Could not find " + argName + " in " + args + " to fill data pattern " + dataPattern);
                }
                matcher.appendTail(data);
                intent.setData(Uri.parse((String)data.toString()));
            }
        }
        if (navOptions != null && navOptions.shouldClearTask()) {
            intent.addFlags(32768);
        }
        if (navOptions != null && navOptions.shouldLaunchDocument() && Build.VERSION.SDK_INT >= 21) {
            intent.addFlags(524288);
        } else if (!(this.mContext instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        if (navOptions != null && navOptions.shouldLaunchSingleTop()) {
            intent.addFlags(0x20000000);
        }
        if (this.mHostActivity != null && (hostIntent = this.mHostActivity.getIntent()) != null && (hostCurrentId = hostIntent.getIntExtra(EXTRA_NAV_CURRENT, 0)) != 0) {
            intent.putExtra(EXTRA_NAV_SOURCE, hostCurrentId);
        }
        int destId = destination.getId();
        intent.putExtra(EXTRA_NAV_CURRENT, destId);
        NavOptions.addPopAnimationsToIntent((Intent)intent, (NavOptions)navOptions);
        this.mContext.startActivity(intent);
        if (navOptions != null && this.mHostActivity != null) {
            int enterAnim = navOptions.getEnterAnim();
            int exitAnim = navOptions.getExitAnim();
            if (enterAnim != -1 || exitAnim != -1) {
                enterAnim = enterAnim != -1 ? enterAnim : 0;
                exitAnim = exitAnim != -1 ? exitAnim : 0;
                this.mHostActivity.overridePendingTransition(enterAnim, exitAnim);
            }
        }
        this.dispatchOnNavigatorNavigated(destId, 0);
    }

    public static class Destination
    extends NavDestination {
        private Intent mIntent;
        private String mDataPattern;

        public Destination(@NonNull NavigatorProvider navigatorProvider) {
            this((Navigator<? extends Destination>)navigatorProvider.getNavigator(ActivityNavigator.class));
        }

        public Destination(@NonNull Navigator<? extends Destination> activityNavigator) {
            super(activityNavigator);
        }

        public void onInflate(@NonNull Context context, @NonNull AttributeSet attrs) {
            super.onInflate(context, attrs);
            TypedArray a = context.getResources().obtainAttributes(attrs, R.styleable.ActivityNavigator);
            String className = a.getString(R.styleable.ActivityNavigator_android_name);
            if (className != null) {
                this.setComponentName(new ComponentName(context, Destination.parseClassFromName((Context)context, (String)className, Activity.class)));
            }
            this.setAction(a.getString(R.styleable.ActivityNavigator_action));
            String data = a.getString(R.styleable.ActivityNavigator_data);
            if (data != null) {
                this.setData(Uri.parse((String)data));
            }
            this.setDataPattern(a.getString(R.styleable.ActivityNavigator_dataPattern));
            a.recycle();
        }

        @NonNull
        public Destination setIntent(@Nullable Intent intent) {
            this.mIntent = intent;
            return this;
        }

        @Nullable
        public Intent getIntent() {
            return this.mIntent;
        }

        @NonNull
        public Destination setComponentName(@Nullable ComponentName name) {
            if (this.mIntent == null) {
                this.mIntent = new Intent();
            }
            this.mIntent.setComponent(name);
            return this;
        }

        @Nullable
        public ComponentName getComponent() {
            if (this.mIntent == null) {
                return null;
            }
            return this.mIntent.getComponent();
        }

        @NonNull
        public Destination setAction(@Nullable String action) {
            if (this.mIntent == null) {
                this.mIntent = new Intent();
            }
            this.mIntent.setAction(action);
            return this;
        }

        @Nullable
        public String getAction() {
            if (this.mIntent == null) {
                return null;
            }
            return this.mIntent.getAction();
        }

        @NonNull
        public Destination setData(@Nullable Uri data) {
            if (this.mIntent == null) {
                this.mIntent = new Intent();
            }
            this.mIntent.setData(data);
            return this;
        }

        @Nullable
        public Uri getData() {
            if (this.mIntent == null) {
                return null;
            }
            return this.mIntent.getData();
        }

        @NonNull
        public Destination setDataPattern(@Nullable String dataPattern) {
            this.mDataPattern = dataPattern;
            return this;
        }

        @Nullable
        public String getDataPattern() {
            return this.mDataPattern;
        }
    }
}

