/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.IdRes;
import android.support.annotation.NavigationRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.TaskStackBuilder;
import android.support.v4.util.Pair;
import android.util.Log;
import androidx.navigation.ActivityNavigator;
import androidx.navigation.NavAction;
import androidx.navigation.NavDeepLinkBuilder;
import androidx.navigation.NavDestination;
import androidx.navigation.NavDirections;
import androidx.navigation.NavGraph;
import androidx.navigation.NavGraphNavigator;
import androidx.navigation.NavInflater;
import androidx.navigation.NavOptions;
import androidx.navigation.Navigator;
import androidx.navigation.NavigatorProvider;
import androidx.navigation.SimpleNavigatorProvider;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class NavController {
    private static final String TAG = "NavController";
    private static final String KEY_NAVIGATOR_STATE = "android-support-nav:controller:navigatorState";
    private static final String KEY_NAVIGATOR_STATE_NAMES = "android-support-nav:controller:navigatorState:names";
    private static final String KEY_GRAPH_ID = "android-support-nav:controller:graphId";
    private static final String KEY_BACK_STACK_IDS = "android-support-nav:controller:backStackIds";
    static final String KEY_DEEP_LINK_IDS = "android-support-nav:controller:deepLinkIds";
    static final String KEY_DEEP_LINK_EXTRAS = "android-support-nav:controller:deepLinkExtras";
    @NonNull
    public static final String KEY_DEEP_LINK_INTENT = "android-support-nav:controller:deepLinkIntent";
    final Context mContext;
    private Activity mActivity;
    private NavInflater mInflater;
    private NavGraph mGraph;
    private int mGraphId;
    private Bundle mNavigatorStateToRestore;
    private int[] mBackStackToRestore;
    final Deque<NavDestination> mBackStack = new ArrayDeque<NavDestination>();
    private final SimpleNavigatorProvider mNavigatorProvider = new SimpleNavigatorProvider(){

        @Nullable
        public Navigator<? extends NavDestination> addNavigator(@NonNull String name, @NonNull Navigator<? extends NavDestination> navigator) {
            Navigator previousNavigator = super.addNavigator(name, navigator);
            if (previousNavigator != navigator) {
                if (previousNavigator != null) {
                    previousNavigator.removeOnNavigatorNavigatedListener(NavController.this.mOnNavigatedListener);
                }
                navigator.addOnNavigatorNavigatedListener(NavController.this.mOnNavigatedListener);
            }
            return previousNavigator;
        }
    };
    final Navigator.OnNavigatorNavigatedListener mOnNavigatedListener = new Navigator.OnNavigatorNavigatedListener(){

        public void onNavigatorNavigated(@NonNull Navigator navigator, @IdRes int destId, int backStackEffect) {
            switch (backStackEffect) {
                case 2: {
                    NavDestination lastFromNavigator = null;
                    Iterator<NavDestination> iterator = NavController.this.mBackStack.descendingIterator();
                    while (iterator.hasNext()) {
                        NavDestination destination = iterator.next();
                        if (destination.getNavigator() != navigator) continue;
                        lastFromNavigator = destination;
                        break;
                    }
                    if (lastFromNavigator == null) {
                        throw new IllegalArgumentException("Navigator " + navigator + " reported pop but did not have any destinations" + " on the NavController back stack");
                    }
                    NavController.this.popBackStack(lastFromNavigator.getId(), false);
                    if (!NavController.this.mBackStack.isEmpty()) {
                        NavController.this.mBackStack.removeLast();
                    }
                    while (!NavController.this.mBackStack.isEmpty() && NavController.this.mBackStack.peekLast() instanceof NavGraph) {
                        NavController.this.popBackStack();
                    }
                    if (NavController.this.mBackStack.isEmpty()) break;
                    NavController.this.dispatchOnNavigated(NavController.this.mBackStack.peekLast());
                    break;
                }
                case 1: {
                    NavDestination newDest = NavController.this.findDestination(destId);
                    if (newDest == null) {
                        throw new IllegalArgumentException("Navigator " + navigator + " reported navigation to unknown destination id " + NavDestination.getDisplayName((Context)NavController.this.mContext, (int)destId));
                    }
                    NavController.this.mBackStack.add(newDest);
                    NavController.this.dispatchOnNavigated(newDest);
                    break;
                }
            }
        }
    };
    private final CopyOnWriteArrayList<OnNavigatedListener> mOnNavigatedListeners = new CopyOnWriteArrayList();

    public NavController(@NonNull Context context) {
        this.mContext = context;
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                this.mActivity = (Activity)context;
                break;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        this.mNavigatorProvider.addNavigator((Navigator)new NavGraphNavigator(this.mContext));
        this.mNavigatorProvider.addNavigator((Navigator)new ActivityNavigator(this.mContext));
    }

    @NonNull
    Context getContext() {
        return this.mContext;
    }

    @NonNull
    public NavigatorProvider getNavigatorProvider() {
        return this.mNavigatorProvider;
    }

    public void addOnNavigatedListener(@NonNull OnNavigatedListener listener) {
        if (!this.mBackStack.isEmpty()) {
            listener.onNavigated(this, this.mBackStack.peekLast());
        }
        this.mOnNavigatedListeners.add(listener);
    }

    public void removeOnNavigatedListener(@NonNull OnNavigatedListener listener) {
        this.mOnNavigatedListeners.remove(listener);
    }

    public boolean popBackStack() {
        if (this.mBackStack.isEmpty()) {
            return false;
        }
        return this.popBackStack(this.getCurrentDestination().getId(), true);
    }

    public boolean popBackStack(@IdRes int destinationId, boolean inclusive) {
        if (this.mBackStack.isEmpty()) {
            return false;
        }
        ArrayList<NavDestination> destinationsToRemove = new ArrayList<NavDestination>();
        Iterator<Object> iterator = this.mBackStack.descendingIterator();
        boolean foundDestination = false;
        while (iterator.hasNext()) {
            NavDestination destination = iterator.next();
            if (inclusive || destination.getId() != destinationId) {
                destinationsToRemove.add(destination);
            }
            if (destination.getId() != destinationId) continue;
            foundDestination = true;
            break;
        }
        if (!foundDestination) {
            String destinationName = NavDestination.getDisplayName((Context)this.mContext, (int)destinationId);
            Log.i((String)TAG, (String)("Ignoring popBackStack to destination " + destinationName + " as it was not found on the current back stack"));
            return false;
        }
        boolean popped = false;
        iterator = destinationsToRemove.iterator();
        while (iterator.hasNext()) {
            NavDestination destination = (NavDestination)iterator.next();
            while (!this.mBackStack.isEmpty() && this.mBackStack.peekLast().getId() != destination.getId()) {
                if (iterator.hasNext()) {
                    destination = (NavDestination)iterator.next();
                    continue;
                }
                destination = null;
                break;
            }
            if (destination == null) continue;
            popped = destination.getNavigator().popBackStack() || popped;
        }
        return popped;
    }

    public boolean navigateUp() {
        if (this.mBackStack.size() == 1) {
            NavDestination currentDestination = this.getCurrentDestination();
            int destId = currentDestination.getId();
            for (NavGraph parent = currentDestination.getParent(); parent != null; parent = parent.getParent()) {
                if (parent.getStartDestination() != destId) {
                    TaskStackBuilder parentIntents = new NavDeepLinkBuilder(this).setDestination(parent.getId()).createTaskStackBuilder();
                    parentIntents.startActivities();
                    if (this.mActivity != null) {
                        this.mActivity.finish();
                    }
                    return true;
                }
                destId = parent.getId();
            }
            return false;
        }
        return this.popBackStack();
    }

    void dispatchOnNavigated(NavDestination destination) {
        for (OnNavigatedListener listener : this.mOnNavigatedListeners) {
            listener.onNavigated(this, destination);
        }
    }

    public void setMetadataGraph() {
        NavGraph metadataGraph = this.getNavInflater().inflateMetadataGraph();
        if (metadataGraph != null) {
            this.setGraph(metadataGraph);
        }
    }

    @NonNull
    public NavInflater getNavInflater() {
        if (this.mInflater == null) {
            this.mInflater = new NavInflater(this.mContext, (NavigatorProvider)this.mNavigatorProvider);
        }
        return this.mInflater;
    }

    public void setGraph(@NavigationRes int graphResId) {
        this.mGraph = this.getNavInflater().inflate(graphResId);
        this.mGraphId = graphResId;
        this.onGraphCreated();
    }

    public void setGraph(@NonNull NavGraph graph) {
        this.mGraph = graph;
        this.mGraphId = 0;
        this.onGraphCreated();
    }

    private void onGraphCreated() {
        Object navigatorNames;
        if (this.mNavigatorStateToRestore != null && (navigatorNames = this.mNavigatorStateToRestore.getStringArrayList(KEY_NAVIGATOR_STATE_NAMES)) != null) {
            Iterator iterator = ((ArrayList)navigatorNames).iterator();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                Navigator navigator = this.mNavigatorProvider.getNavigator(name);
                Bundle bundle = this.mNavigatorStateToRestore.getBundle(name);
                if (bundle == null) continue;
                navigator.onRestoreState(bundle);
            }
        }
        if (this.mBackStackToRestore != null) {
            for (Object destinationId : (Object)this.mBackStackToRestore) {
                NavDestination node = this.findDestination((int)destinationId);
                if (node == null) {
                    throw new IllegalStateException("unknown destination during restore: " + this.mContext.getResources().getResourceName((int)destinationId));
                }
                this.mBackStack.add(node);
            }
            this.mBackStackToRestore = null;
        }
        if (this.mGraph != null && this.mBackStack.isEmpty()) {
            boolean deepLinked;
            boolean bl = deepLinked = this.mActivity != null && this.onHandleDeepLink(this.mActivity.getIntent());
            if (!deepLinked) {
                this.mGraph.navigate(null, null);
            }
        }
    }

    public boolean onHandleDeepLink(@Nullable Intent intent) {
        Pair matchingDeepLink;
        Bundle deepLinkExtras;
        if (intent == null) {
            return false;
        }
        Bundle extras = intent.getExtras();
        int[] deepLink = extras != null ? extras.getIntArray(KEY_DEEP_LINK_IDS) : null;
        Bundle bundle = new Bundle();
        Bundle bundle2 = deepLinkExtras = extras != null ? extras.getBundle(KEY_DEEP_LINK_EXTRAS) : null;
        if (deepLinkExtras != null) {
            bundle.putAll(deepLinkExtras);
        }
        if ((deepLink == null || deepLink.length == 0) && intent.getData() != null && (matchingDeepLink = this.mGraph.matchDeepLink(intent.getData())) != null) {
            deepLink = ((NavDestination)matchingDeepLink.first).buildDeepLinkIds();
            bundle.putAll((Bundle)matchingDeepLink.second);
        }
        if (deepLink == null || deepLink.length == 0) {
            return false;
        }
        bundle.putParcelable(KEY_DEEP_LINK_INTENT, (Parcelable)intent);
        int flags = intent.getFlags();
        if ((flags & 0x10000000) != 0 && (flags & 0x8000) == 0) {
            intent.addFlags(32768);
            TaskStackBuilder taskStackBuilder = TaskStackBuilder.create((Context)this.mContext).addNextIntentWithParentStack(intent);
            taskStackBuilder.startActivities();
            if (this.mActivity != null) {
                this.mActivity.finish();
            }
            return true;
        }
        if ((flags & 0x10000000) != 0) {
            if (!this.mBackStack.isEmpty()) {
                this.navigate(this.mGraph.getStartDestination(), bundle, new NavOptions.Builder().setPopUpTo(this.mGraph.getId(), true).setEnterAnim(0).setExitAnim(0).build());
            }
            int index = 0;
            while (index < deepLink.length) {
                int destinationId;
                NavDestination node;
                if ((node = this.findDestination(destinationId = deepLink[index++])) == null) {
                    throw new IllegalStateException("unknown destination during deep link: " + NavDestination.getDisplayName((Context)this.mContext, (int)destinationId));
                }
                node.navigate(bundle, new NavOptions.Builder().setEnterAnim(0).setExitAnim(0).build());
            }
            return true;
        }
        NavGraph graph = this.mGraph;
        for (int i = 0; i < deepLink.length; ++i) {
            NavGraph node;
            int destinationId = deepLink[i];
            Object object = node = i == 0 ? this.mGraph : graph.findNode(destinationId);
            if (node == null) {
                throw new IllegalStateException("unknown destination during deep link: " + NavDestination.getDisplayName((Context)this.mContext, (int)destinationId));
            }
            if (i != deepLink.length - 1) {
                graph = node;
                continue;
            }
            node.navigate(bundle, new NavOptions.Builder().setPopUpTo(this.mGraph.getId(), true).setEnterAnim(0).setExitAnim(0).build());
        }
        return true;
    }

    public NavGraph getGraph() {
        return this.mGraph;
    }

    @Nullable
    public NavDestination getCurrentDestination() {
        return this.mBackStack.peekLast();
    }

    NavDestination findDestination(@IdRes int destinationId) {
        if (this.mGraph == null) {
            return null;
        }
        if (this.mGraph.getId() == destinationId) {
            return this.mGraph;
        }
        NavGraph currentNode = this.mBackStack.isEmpty() ? this.mGraph : this.mBackStack.peekLast();
        NavGraph currentGraph = currentNode instanceof NavGraph ? currentNode : currentNode.getParent();
        return currentGraph.findNode(destinationId);
    }

    public final void navigate(@IdRes int resId) {
        this.navigate(resId, null);
    }

    public final void navigate(@IdRes int resId, @Nullable Bundle args) {
        this.navigate(resId, args, null);
    }

    public void navigate(@IdRes int resId, @Nullable Bundle args, @Nullable NavOptions navOptions) {
        NavGraph currentNode;
        Object object = currentNode = this.mBackStack.isEmpty() ? this.mGraph : this.mBackStack.peekLast();
        if (currentNode == null) {
            throw new IllegalStateException("no current navigation node");
        }
        int destId = resId;
        NavAction navAction = currentNode.getAction(resId);
        if (navAction != null) {
            if (navOptions == null) {
                navOptions = navAction.getNavOptions();
            }
            destId = navAction.getDestinationId();
        }
        if (destId == 0 && navOptions != null && navOptions.getPopUpTo() != 0) {
            this.popBackStack(navOptions.getPopUpTo(), navOptions.isPopUpToInclusive());
            return;
        }
        if (destId == 0) {
            throw new IllegalArgumentException("Destination id == 0 can only be used in conjunction with navOptions.popUpTo != 0");
        }
        NavDestination node = this.findDestination(destId);
        if (node == null) {
            String dest = NavDestination.getDisplayName((Context)this.mContext, (int)destId);
            throw new IllegalArgumentException("navigation destination " + dest + (navAction != null ? " referenced from action " + NavDestination.getDisplayName((Context)this.mContext, (int)resId) : "") + " is unknown to this NavController");
        }
        if (navOptions != null) {
            if (navOptions.shouldClearTask()) {
                this.popBackStack(this.mGraph.getId(), true);
            } else if (navOptions.getPopUpTo() != 0) {
                this.popBackStack(navOptions.getPopUpTo(), navOptions.isPopUpToInclusive());
            }
        }
        node.navigate(args, navOptions);
    }

    public void navigate(@NonNull NavDirections directions) {
        this.navigate(directions.getActionId(), directions.getArguments());
    }

    public void navigate(@NonNull NavDirections directions, @Nullable NavOptions navOptions) {
        this.navigate(directions.getActionId(), directions.getArguments(), navOptions);
    }

    @NonNull
    public NavDeepLinkBuilder createDeepLink() {
        return new NavDeepLinkBuilder(this);
    }

    @Nullable
    public Bundle saveState() {
        Bundle b = null;
        if (this.mGraphId != 0) {
            b = new Bundle();
            b.putInt(KEY_GRAPH_ID, this.mGraphId);
        }
        ArrayList<String> navigatorNames = new ArrayList<String>();
        Bundle navigatorState = new Bundle();
        for (Map.Entry entry : this.mNavigatorProvider.getNavigators().entrySet()) {
            String name = (String)entry.getKey();
            Bundle savedState = ((Navigator)entry.getValue()).onSaveState();
            if (savedState == null) continue;
            navigatorNames.add(name);
            navigatorState.putBundle(name, ((Navigator)entry.getValue()).onSaveState());
        }
        if (!navigatorNames.isEmpty()) {
            if (b == null) {
                b = new Bundle();
            }
            navigatorState.putStringArrayList(KEY_NAVIGATOR_STATE_NAMES, navigatorNames);
            b.putBundle(KEY_NAVIGATOR_STATE, navigatorState);
        }
        if (!this.mBackStack.isEmpty()) {
            if (b == null) {
                b = new Bundle();
            }
            int[] backStack = new int[this.mBackStack.size()];
            int index = 0;
            for (NavDestination destination : this.mBackStack) {
                backStack[index++] = destination.getId();
            }
            b.putIntArray(KEY_BACK_STACK_IDS, backStack);
        }
        return b;
    }

    public void restoreState(@Nullable Bundle navState) {
        if (navState == null) {
            return;
        }
        this.mGraphId = navState.getInt(KEY_GRAPH_ID);
        this.mNavigatorStateToRestore = navState.getBundle(KEY_NAVIGATOR_STATE);
        this.mBackStackToRestore = navState.getIntArray(KEY_BACK_STACK_IDS);
        if (this.mGraphId != 0) {
            this.setGraph(this.mGraphId);
        }
    }

    public static interface OnNavigatedListener {
        public void onNavigated(@NonNull NavController var1, @NonNull NavDestination var2);
    }
}

