/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.safe.args.generator;

import androidx.navigation.safe.args.generator.BooleanValue;
import androidx.navigation.safe.args.generator.FloatValue;
import androidx.navigation.safe.args.generator.IntValue;
import androidx.navigation.safe.args.generator.NavType;
import androidx.navigation.safe.args.generator.ReferenceValue;
import androidx.navigation.safe.args.generator.StringValue;
import androidx.navigation.safe.args.generator.models.Argument;
import androidx.navigation.safe.args.generator.models.ResReference;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0001H\u0000\u001a\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0014\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0014\u001a\u00020\u0001H\u0000\u001a\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"ATTRIBUTE_DEFAULT_VALUE", "", "ATTRIBUTE_DESTINATION", "ATTRIBUTE_ID", "ATTRIBUTE_NAME", "ATTRIBUTE_TYPE", "NAMESPACE_ANDROID", "NAMESPACE_RES_AUTO", "RESOURCE_REGEX", "Lkotlin/text/Regex;", "TAG_ACTION", "TAG_ARGUMENT", "TAG_NAVIGATION", "inferArgument", "Landroidx/navigation/safe/args/generator/models/Argument;", "name", "defaultValue", "rFilePackage", "parseBoolean", "Landroidx/navigation/safe/args/generator/BooleanValue;", "value", "parseFloatValue", "Landroidx/navigation/safe/args/generator/FloatValue;", "parseIntValue", "Landroidx/navigation/safe/args/generator/IntValue;", "parseReference", "Landroidx/navigation/safe/args/generator/models/ResReference;", "xmlValue", "navigation-safe-args-generator"})
public final class NavParserKt {
    private static final String TAG_NAVIGATION = "navigation";
    private static final String TAG_ACTION = "action";
    private static final String TAG_ARGUMENT = "argument";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_DESTINATION = "destination";
    private static final String ATTRIBUTE_DEFAULT_VALUE = "defaultValue";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String NAMESPACE_RES_AUTO = "http://schemas.android.com/apk/res-auto";
    private static final String NAMESPACE_ANDROID = "http://schemas.android.com/apk/res/android";
    private static final Regex RESOURCE_REGEX = new Regex("^@[+]?(.+?:)?(.+?)/(.+)$");

    @NotNull
    public static final Argument inferArgument(@NotNull String name, @NotNull String defaultValue, @NotNull String rFilePackage) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)ATTRIBUTE_NAME);
        Intrinsics.checkParameterIsNotNull((Object)defaultValue, (String)ATTRIBUTE_DEFAULT_VALUE);
        Intrinsics.checkParameterIsNotNull((Object)rFilePackage, (String)"rFilePackage");
        ResReference reference = NavParserKt.parseReference(defaultValue, rFilePackage);
        if (reference != null) {
            return new Argument(name, NavType.REFERENCE, new ReferenceValue(reference));
        }
        IntValue intValue = NavParserKt.parseIntValue(defaultValue);
        if (intValue != null) {
            return new Argument(name, NavType.INT, intValue);
        }
        FloatValue floatValue = NavParserKt.parseFloatValue(defaultValue);
        if (floatValue != null) {
            return new Argument(name, NavType.FLOAT, floatValue);
        }
        BooleanValue boolValue = NavParserKt.parseBoolean(defaultValue);
        if (boolValue != null) {
            return new Argument(name, NavType.BOOLEAN, boolValue);
        }
        return new Argument(name, NavType.STRING, new StringValue(defaultValue));
    }

    @Nullable
    public static final ResReference parseReference(@NotNull String xmlValue, @NotNull String rFilePackage) {
        Intrinsics.checkParameterIsNotNull((Object)xmlValue, (String)"xmlValue");
        Intrinsics.checkParameterIsNotNull((Object)rFilePackage, (String)"rFilePackage");
        MatchResult matchResult = RESOURCE_REGEX.matchEntire((CharSequence)xmlValue);
        if (matchResult == null) {
            return null;
        }
        MatchResult matchEntire = matchResult;
        List groups = matchEntire.getGroupValues();
        String resourceName = (String)CollectionsKt.last((List)groups);
        String resType = (String)groups.get(groups.size() - 2);
        CharSequence charSequence = (CharSequence)groups.get(1);
        String packageName = charSequence.length() > 0 ? StringsKt.removeSuffix((String)((String)groups.get(1)), (CharSequence)":") : rFilePackage;
        return new ResReference(packageName, resType, resourceName);
    }

    @Nullable
    public static final IntValue parseIntValue(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        try {
            if (StringsKt.startsWith$default((String)value, (String)"0x", (boolean)false, (int)2, null)) {
                String string = value;
                int n = 2;
                String string2 = string.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                Integer.parseUnsignedInt(string2, 16);
            } else {
                Integer.parseInt(value);
            }
        }
        catch (NumberFormatException ex) {
            return null;
        }
        return new IntValue(value);
    }

    private static final FloatValue parseFloatValue(String value) {
        FloatValue floatValue;
        Float f = StringsKt.toFloatOrNull((String)value);
        if (f != null) {
            Float f2 = f;
            float it = ((Number)f2).floatValue();
            floatValue = new FloatValue(value);
        } else {
            floatValue = null;
        }
        return floatValue;
    }

    private static final BooleanValue parseBoolean(String value) {
        if (Intrinsics.areEqual((Object)value, (Object)"true") || Intrinsics.areEqual((Object)value, (Object)"false")) {
            return new BooleanValue(value);
        }
        return null;
    }

    @Nullable
    public static final /* synthetic */ FloatValue access$parseFloatValue(@NotNull String value) {
        return NavParserKt.parseFloatValue(value);
    }

    @Nullable
    public static final /* synthetic */ BooleanValue access$parseBoolean(@NotNull String value) {
        return NavParserKt.parseBoolean(value);
    }
}

