/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.safe.args.generator;

import androidx.navigation.safe.args.generator.NavParserErrors;
import androidx.navigation.safe.args.generator.NavType;
import androidx.navigation.safe.args.generator.models.Action;
import androidx.navigation.safe.args.generator.models.Argument;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\t\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004J\u0016\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004J\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004J\u001c\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u001c\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0014J\u0010\u0010\u0019\u001a\u00020\u00042\b\u0010\u001a\u001a\u0004\u0018\u00010\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"Landroidx/navigation/safe/args/generator/NavParserErrors;", "", "()V", "UNNAMED_DESTINATION", "", "getUNNAMED_DESTINATION", "()Ljava/lang/String;", "defaultNullButNotNullable", "name", "defaultValueParcelable", "type", "deprecatedTypeAttrUsed", "invalidDefaultValue", "value", "Landroidx/navigation/safe/args/generator/NavType;", "invalidDefaultValueReference", "invalidId", "sameSanitizedNameActions", "sanitizedName", "actions", "", "Landroidx/navigation/safe/args/generator/models/Action;", "sameSanitizedNameArguments", "args", "Landroidx/navigation/safe/args/generator/models/Argument;", "typeIsNotNullable", "typeName", "navigation-safe-args-generator"})
public final class NavParserErrors {
    @NotNull
    private static final String UNNAMED_DESTINATION = "Destination with arguments or actions must have 'name' or 'id' attributes.";
    public static final NavParserErrors INSTANCE;

    @NotNull
    public final String getUNNAMED_DESTINATION() {
        return UNNAMED_DESTINATION;
    }

    @NotNull
    public final String invalidDefaultValueReference(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return "Failed to parse defaultValue " + '\'' + value + "' as reference. Reference must be in format @[+][package:]res_type/resource_name";
    }

    @NotNull
    public final String invalidDefaultValue(@NotNull String value, @NotNull NavType type) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return "Failed to parse defaultValue " + '\'' + value + "' as " + type;
    }

    @NotNull
    public final String invalidId(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return "Failed to parse " + value + " as id. 'id' must be in the format:" + " @[+][package:]id/resource_name ";
    }

    @NotNull
    public final String defaultValueParcelable(@Nullable String type) {
        return "Parcelable ('" + type + "') " + "doesn't allow default values other than @null";
    }

    @NotNull
    public final String defaultNullButNotNullable(@Nullable String name) {
        return "android:defaultValue is @null, but '" + name + "' " + "is not nullable. Add app:nullable=\"true\" to the argument to make it nullable.";
    }

    @NotNull
    public final String typeIsNotNullable(@Nullable String typeName) {
        return '\'' + typeName + "' is a simple type " + "and cannot be nullable. Remove app:nullable=\"true\" from the argument.";
    }

    @NotNull
    public final String sameSanitizedNameArguments(@NotNull String sanitizedName, @NotNull List<Argument> args) {
        Intrinsics.checkParameterIsNotNull((Object)sanitizedName, (String)"sanitizedName");
        Intrinsics.checkParameterIsNotNull(args, (String)"args");
        return "Multiple same name arguments. The named arguments: " + '[' + CollectionsKt.joinToString$default((Iterable)args, (CharSequence)", ", null, null, (int)0, null, (Function1)sameSanitizedNameArguments.1.INSTANCE, (int)30, null) + "] result in the generator using " + "the same name: '" + sanitizedName + "'.";
    }

    @NotNull
    public final String sameSanitizedNameActions(@NotNull String sanitizedName, @NotNull List<Action> actions) {
        Intrinsics.checkParameterIsNotNull((Object)sanitizedName, (String)"sanitizedName");
        Intrinsics.checkParameterIsNotNull(actions, (String)"actions");
        return "Multiple same name actions. The action ids: " + '[' + CollectionsKt.joinToString$default((Iterable)actions, (CharSequence)", ", null, null, (int)0, null, (Function1)sameSanitizedNameActions.1.INSTANCE, (int)30, null) + "] result in the " + "generator using the same name: '" + sanitizedName + "'.";
    }

    @NotNull
    public final String deprecatedTypeAttrUsed(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return "The 'type' attribute used by argument '" + name + "' is deprecated. " + "Please change all instances of 'type' in navigation resources to 'argType'.";
    }

    private NavParserErrors() {
    }

    static {
        NavParserErrors navParserErrors;
        INSTANCE = navParserErrors = new NavParserErrors();
        UNNAMED_DESTINATION = UNNAMED_DESTINATION;
    }
}

