/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.safe.args.generator;

import androidx.navigation.safe.args.generator.Annotations;
import androidx.navigation.safe.args.generator.BoolType;
import androidx.navigation.safe.args.generator.FloatType;
import androidx.navigation.safe.args.generator.IntType;
import androidx.navigation.safe.args.generator.LongType;
import androidx.navigation.safe.args.generator.NavType;
import androidx.navigation.safe.args.generator.NavWriterKt;
import androidx.navigation.safe.args.generator.ParcelableType;
import androidx.navigation.safe.args.generator.ReferenceType;
import androidx.navigation.safe.args.generator.StringType;
import androidx.navigation.safe.args.generator.WriteableValue;
import androidx.navigation.safe.args.generator.models.Argument;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.lang.model.element.Modifier;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rJ\u001e\u0010\u000f\u001a\n \u000e*\u0004\u0018\u00010\u00100\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012J\"\u0010\u0014\u001a\n \u000e*\u0004\u0018\u00010\r0\r2\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0010J\u0014\u0010\u0018\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00190\u00190\u0003J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0004H\u0002J\u0014\u0010\u001d\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\u0003J\u001a\u0010\u001e\u001a\n \u000e*\u0004\u0018\u00010\r0\r2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0010J\u001c\u0010\u001f\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\u00032\u0006\u0010 \u001a\u00020\u0016J\u0016\u0010!\u001a\n \u000e*\u0004\u0018\u00010\r0\r2\u0006\u0010\"\u001a\u00020\u0012J\"\u0010#\u001a\n \u000e*\u0004\u0018\u00010\r0\r2\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006%"}, d2={"Landroidx/navigation/safe/args/generator/ClassWithArgsSpecs;", "", "args", "", "Landroidx/navigation/safe/args/generator/models/Argument;", "annotations", "Landroidx/navigation/safe/args/generator/Annotations;", "(Ljava/util/List;Landroidx/navigation/safe/args/generator/Annotations;)V", "getAnnotations", "()Landroidx/navigation/safe/args/generator/Annotations;", "getArgs", "()Ljava/util/List;", "constructor", "Lcom/squareup/javapoet/MethodSpec;", "kotlin.jvm.PlatformType", "copyProperties", "Lcom/squareup/javapoet/CodeBlock;", "to", "", "from", "equalsMethod", "className", "Lcom/squareup/javapoet/ClassName;", "additionalCode", "fieldSpecs", "Lcom/squareup/javapoet/FieldSpec;", "generateParameterSpec", "Lcom/squareup/javapoet/ParameterSpec;", "arg", "getters", "hashCodeMethod", "setters", "thisClassName", "toBundleMethod", "name", "toStringMethod", "toStringHeaderBlock", "navigation-safe-args-generator"})
final class ClassWithArgsSpecs {
    @NotNull
    private final List<Argument> args;
    @NotNull
    private final Annotations annotations;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FieldSpec> fieldSpecs() {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)this.args;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void arg;
            FieldSpec.Builder builder;
            Argument argument = (Argument)item$iv$iv;
            Collection collection = destination$iv$iv;
            FieldSpec.Builder $receiver = builder = FieldSpec.builder((TypeName)arg.getType().typeName(), (String)arg.getSanitizedName(), (Modifier[])new Modifier[0]);
            $receiver.addModifiers(new Modifier[]{Modifier.PRIVATE});
            if (arg.getType().allowsNullable()) {
                if (arg.isNullable()) {
                    $receiver.addAnnotation(this.annotations.getNULLABLE_CLASSNAME());
                } else {
                    $receiver.addAnnotation(this.annotations.getNONNULL_CLASSNAME());
                }
            }
            if (arg.isOptional()) {
                WriteableValue writeableValue = arg.getDefaultValue();
                if (writeableValue == null) {
                    Intrinsics.throwNpe();
                }
                $receiver.initializer(writeableValue.write());
            }
            FieldSpec fieldSpec = builder.build();
            collection.add(fieldSpec);
        }
        return (List)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<MethodSpec> setters(@NotNull ClassName thisClassName) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)thisClassName, (String)"thisClassName");
        Iterable iterable = $receiver$iv = (Iterable)this.args;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void arg;
            MethodSpec.Builder builder;
            Argument argument = (Argument)item$iv$iv;
            Collection collection = destination$iv$iv;
            MethodSpec.Builder $receiver = builder = MethodSpec.methodBuilder((String)("set" + StringsKt.capitalize((String)arg.getSanitizedName())));
            $receiver.addAnnotation(this.annotations.getNONNULL_CLASSNAME());
            $receiver.addModifiers(new Modifier[]{Modifier.PUBLIC});
            $receiver.addParameter(this.generateParameterSpec((Argument)arg));
            NavWriterKt.access$addNullCheck($receiver, (Argument)arg, arg.getSanitizedName());
            $receiver.addStatement("this.$N = $N", new Object[]{arg.getSanitizedName(), arg.getSanitizedName()});
            $receiver.addStatement("return this", new Object[0]);
            $receiver.returns((TypeName)thisClassName);
            MethodSpec methodSpec = builder.build();
            collection.add(methodSpec);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public final MethodSpec constructor() {
        void $receiver$iv$iv;
        MethodSpec.Builder builder;
        MethodSpec.Builder $receiver = builder = MethodSpec.constructorBuilder();
        $receiver.addModifiers(new Modifier[]{Modifier.PUBLIC});
        Iterable $receiver$iv = this.args;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Argument p1 = (Argument)element$iv$iv;
            if (p1.isOptional()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            Argument arg = (Argument)element$iv;
            $receiver.addParameter(this.generateParameterSpec(arg));
            $receiver.addStatement("this.$N = $N", new Object[]{arg.getSanitizedName(), arg.getSanitizedName()});
            NavWriterKt.access$addNullCheck($receiver, arg, "this." + arg.getSanitizedName());
        }
        return builder.build();
    }

    public final MethodSpec toBundleMethod(@NotNull String name) {
        MethodSpec.Builder builder;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        MethodSpec.Builder $receiver = builder = MethodSpec.methodBuilder((String)name);
        $receiver.addAnnotation(this.annotations.getNONNULL_CLASSNAME());
        $receiver.addModifiers(new Modifier[]{Modifier.PUBLIC});
        $receiver.returns((TypeName)NavWriterKt.access$getBUNDLE_CLASSNAME$p());
        String bundleName = "__outBundle";
        $receiver.addStatement("$T $N = new $T()", new Object[]{NavWriterKt.access$getBUNDLE_CLASSNAME$p(), bundleName, NavWriterKt.access$getBUNDLE_CLASSNAME$p()});
        Iterable $receiver$iv = this.args;
        for (Object element$iv : $receiver$iv) {
            Argument $name_type_$_$_$_$_sanitizedName = (Argument)element$iv;
            String name2 = $name_type_$_$_$_$_sanitizedName.component1();
            NavType type = $name_type_$_$_$_$_sanitizedName.component2();
            String sanitizedName = $name_type_$_$_$_$_sanitizedName.component5();
            $receiver.addStatement("$N.$N($S, this.$N)", new Object[]{bundleName, type.bundlePutMethod(), name2, sanitizedName});
        }
        $receiver.addStatement("return $N", new Object[]{bundleName});
        return builder.build();
    }

    public final CodeBlock copyProperties(@NotNull String to, @NotNull String from) {
        CodeBlock.Builder builder;
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        CodeBlock.Builder $receiver = builder = CodeBlock.builder();
        Iterable $receiver$iv = this.args;
        for (Object element$iv : $receiver$iv) {
            Argument $$_$_$_$_$_$_$_$_sanitizedName = (Argument)element$iv;
            String sanitizedName = $$_$_$_$_$_$_$_$_sanitizedName.component5();
            $receiver.addStatement(to + '.' + sanitizedName + " = " + from + '.' + sanitizedName, new Object[0]);
        }
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<MethodSpec> getters() {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)this.args;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void arg;
            MethodSpec.Builder builder;
            Argument argument = (Argument)item$iv$iv;
            Collection collection = destination$iv$iv;
            MethodSpec.Builder $receiver = builder = MethodSpec.methodBuilder((String)("get" + StringsKt.capitalize((String)arg.getSanitizedName())));
            $receiver.addModifiers(new Modifier[]{Modifier.PUBLIC});
            if (arg.getType().allowsNullable()) {
                if (arg.isNullable()) {
                    $receiver.addAnnotation(this.annotations.getNULLABLE_CLASSNAME());
                } else {
                    $receiver.addAnnotation(this.annotations.getNONNULL_CLASSNAME());
                }
            }
            $receiver.addStatement("return $N", new Object[]{arg.getSanitizedName()});
            $receiver.returns(arg.getType().typeName());
            MethodSpec methodSpec = builder.build();
            collection.add(methodSpec);
        }
        return (List)var3_3;
    }

    public final MethodSpec equalsMethod(@NotNull ClassName className, @Nullable CodeBlock additionalCode) {
        MethodSpec.Builder builder;
        Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
        MethodSpec.Builder $receiver = builder = MethodSpec.methodBuilder((String)"equals");
        $receiver.addAnnotation(Override.class);
        $receiver.addModifiers(new Modifier[]{Modifier.PUBLIC});
        $receiver.addParameter((TypeName)TypeName.OBJECT, "object", new Modifier[0]);
        $receiver.addCode(StringsKt.trimIndent((String)"\n                if (this == object) {\n                    return true;\n                }\n                if (object == null || getClass() != object.getClass()) {\n                    return false;\n                }\n\n                "), new Object[0]);
        $receiver.addStatement("$T that = ($T) object", new Object[]{className, className});
        Iterable $receiver$iv = this.args;
        for (Object element$iv : $receiver$iv) {
            String string;
            Argument $$_$_type_$_$_$_$_sanitizedName = (Argument)element$iv;
            NavType type = $$_$_type_$_$_$_$_sanitizedName.component2();
            String sanitizedName = $$_$_type_$_$_$_$_sanitizedName.component5();
            NavType navType = type;
            if (Intrinsics.areEqual((Object)navType, (Object)IntType.INSTANCE) || Intrinsics.areEqual((Object)navType, (Object)BoolType.INSTANCE) || Intrinsics.areEqual((Object)navType, (Object)ReferenceType.INSTANCE) || Intrinsics.areEqual((Object)navType, (Object)LongType.INSTANCE)) {
                string = sanitizedName + " != that." + sanitizedName;
            } else if (Intrinsics.areEqual((Object)navType, (Object)FloatType.INSTANCE)) {
                string = "Float.compare(that." + sanitizedName + ", " + sanitizedName + ") != 0";
            } else if (Intrinsics.areEqual((Object)navType, (Object)StringType.INSTANCE) || navType instanceof ParcelableType) {
                string = sanitizedName + " != null ? !" + sanitizedName + ".equals(that." + sanitizedName + ") " + ": that." + sanitizedName + " != null";
            } else {
                throw new NoWhenBranchMatchedException();
            }
            String compareExpression = string;
            NavType $receiver2 = navType = $receiver.beginControlFlow("if ($N)", new Object[]{compareExpression});
            $receiver2.addStatement("return false", new Object[0]);
            $receiver.endControlFlow();
        }
        if (additionalCode != null) {
            $receiver.addCode(additionalCode);
        }
        $receiver.addStatement("return true", new Object[0]);
        $receiver.returns(TypeName.BOOLEAN);
        return builder.build();
    }

    public static /* bridge */ /* synthetic */ MethodSpec equalsMethod$default(ClassWithArgsSpecs classWithArgsSpecs, ClassName className, CodeBlock codeBlock, int n, Object object) {
        if ((n & 2) != 0) {
            codeBlock = null;
        }
        return classWithArgsSpecs.equalsMethod(className, codeBlock);
    }

    public final MethodSpec hashCodeMethod(@Nullable CodeBlock additionalCode) {
        MethodSpec.Builder builder;
        MethodSpec.Builder $receiver = builder = MethodSpec.methodBuilder((String)"hashCode");
        $receiver.addAnnotation(Override.class);
        $receiver.addModifiers(new Modifier[]{Modifier.PUBLIC});
        $receiver.addStatement("int result = super.hashCode()", new Object[0]);
        Iterable $receiver$iv = this.args;
        for (Object element$iv : $receiver$iv) {
            String string;
            Argument $$_$_type_$_$_$_$_sanitizedName = (Argument)element$iv;
            NavType type = $$_$_type_$_$_$_$_sanitizedName.component2();
            String sanitizedName = $$_$_type_$_$_$_$_sanitizedName.component5();
            NavType navType = type;
            if (Intrinsics.areEqual((Object)navType, (Object)IntType.INSTANCE) || Intrinsics.areEqual((Object)navType, (Object)ReferenceType.INSTANCE)) {
                string = sanitizedName;
            } else if (Intrinsics.areEqual((Object)navType, (Object)FloatType.INSTANCE)) {
                string = "Float.floatToIntBits(" + sanitizedName + ')';
            } else if (Intrinsics.areEqual((Object)navType, (Object)StringType.INSTANCE) || navType instanceof ParcelableType) {
                string = '(' + sanitizedName + " != null ? " + sanitizedName + ".hashCode() : 0)";
            } else if (Intrinsics.areEqual((Object)navType, (Object)BoolType.INSTANCE)) {
                string = '(' + sanitizedName + " ? 1 : 0)";
            } else if (Intrinsics.areEqual((Object)navType, (Object)LongType.INSTANCE)) {
                string = "(int)(" + sanitizedName + " ^ (" + sanitizedName + " >>> 32))";
            } else {
                throw new NoWhenBranchMatchedException();
            }
            String hashCodeExpression = string;
            $receiver.addStatement("result = 31 * result + $N", new Object[]{hashCodeExpression});
        }
        if (additionalCode != null) {
            $receiver.addCode(additionalCode);
        }
        $receiver.addStatement("return result", new Object[0]);
        $receiver.returns(TypeName.INT);
        return builder.build();
    }

    public static /* bridge */ /* synthetic */ MethodSpec hashCodeMethod$default(ClassWithArgsSpecs classWithArgsSpecs, CodeBlock codeBlock, int n, Object object) {
        if ((n & 1) != 0) {
            codeBlock = null;
        }
        return classWithArgsSpecs.hashCodeMethod(codeBlock);
    }

    /*
     * WARNING - void declaration
     */
    public final MethodSpec toStringMethod(@NotNull ClassName className, @Nullable CodeBlock toStringHeaderBlock) {
        MethodSpec.Builder builder;
        Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
        MethodSpec.Builder $receiver = builder = MethodSpec.methodBuilder((String)"toString");
        $receiver.addAnnotation(Override.class);
        $receiver.addModifiers(new Modifier[]{Modifier.PUBLIC});
        CodeBlock.Builder builder2 = CodeBlock.builder();
        MethodSpec.Builder builder3 = $receiver;
        CodeBlock.Builder $receiver2 = builder2;
        if (toStringHeaderBlock != null) {
            $receiver2.add("$[return $L", new Object[]{toStringHeaderBlock});
        } else {
            $receiver2.add("$[return $S", new Object[]{className.simpleName() + '{'});
        }
        Iterable $receiver$iv = this.args;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void $$_$_$_$_$_$_$_$_sanitizedName;
            int n = index$iv++;
            Argument argument = (Argument)item$iv;
            int index = n;
            String sanitizedName = $$_$_$_$_$_$_$_$_sanitizedName.component5();
            String prefix = index == 0 ? "" : ", ";
            $receiver2.add("\n+ $S + $L", new Object[]{prefix + sanitizedName + '=', sanitizedName});
        }
        $receiver2.add("\n+ $S;\n$]", new Object[]{"}"});
        CodeBlock.Builder builder4 = builder2;
        builder3.addCode(builder4.build());
        $receiver.returns((TypeName)ClassName.get(String.class));
        return builder.build();
    }

    public static /* bridge */ /* synthetic */ MethodSpec toStringMethod$default(ClassWithArgsSpecs classWithArgsSpecs, ClassName className, CodeBlock codeBlock, int n, Object object) {
        if ((n & 2) != 0) {
            codeBlock = null;
        }
        return classWithArgsSpecs.toStringMethod(className, codeBlock);
    }

    private final ParameterSpec generateParameterSpec(Argument arg) {
        ParameterSpec.Builder builder;
        ParameterSpec.Builder $receiver = builder = ParameterSpec.builder((TypeName)arg.getType().typeName(), (String)arg.getSanitizedName(), (Modifier[])new Modifier[0]);
        if (arg.getType().allowsNullable()) {
            if (arg.isNullable()) {
                $receiver.addAnnotation(this.annotations.getNULLABLE_CLASSNAME());
            } else {
                $receiver.addAnnotation(this.annotations.getNONNULL_CLASSNAME());
            }
        }
        ParameterSpec parameterSpec = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)parameterSpec, (String)"ParameterSpec.builder(ar\u2026      }\n        }.build()");
        return parameterSpec;
    }

    @NotNull
    public final List<Argument> getArgs() {
        return this.args;
    }

    @NotNull
    public final Annotations getAnnotations() {
        return this.annotations;
    }

    public ClassWithArgsSpecs(@NotNull List<Argument> args, @NotNull Annotations annotations) {
        Intrinsics.checkParameterIsNotNull(args, (String)"args");
        Intrinsics.checkParameterIsNotNull((Object)annotations, (String)"annotations");
        this.args = args;
        this.annotations = annotations;
    }
}

