/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.safe.args.generator;

import androidx.navigation.safe.args.generator.BoolType;
import androidx.navigation.safe.args.generator.BooleanValue;
import androidx.navigation.safe.args.generator.FloatType;
import androidx.navigation.safe.args.generator.FloatValue;
import androidx.navigation.safe.args.generator.IntType;
import androidx.navigation.safe.args.generator.IntValue;
import androidx.navigation.safe.args.generator.LongType;
import androidx.navigation.safe.args.generator.LongValue;
import androidx.navigation.safe.args.generator.ReferenceType;
import androidx.navigation.safe.args.generator.ReferenceValue;
import androidx.navigation.safe.args.generator.StringType;
import androidx.navigation.safe.args.generator.StringValue;
import androidx.navigation.safe.args.generator.models.Argument;
import androidx.navigation.safe.args.generator.models.ResReference;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0001H\u0000\u001a\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001b\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001b\u001a\u00020\u0001H\u0000\u001a\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001b\u001a\u00020\u0001H\u0000\u001a\u001a\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0011\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0012\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"ATTRIBUTE_DEFAULT_VALUE", "", "ATTRIBUTE_DESTINATION", "ATTRIBUTE_GRAPH", "ATTRIBUTE_ID", "ATTRIBUTE_NAME", "ATTRIBUTE_NULLABLE", "ATTRIBUTE_TYPE", "ATTRIBUTE_TYPE_DEPRECATED", "NAMESPACE_ANDROID", "NAMESPACE_RES_AUTO", "RESOURCE_REGEX", "Lkotlin/text/Regex;", "TAG_ACTION", "TAG_ARGUMENT", "TAG_INCLUDE", "TAG_NAVIGATION", "VALUE_FALSE", "VALUE_NULL", "VALUE_TRUE", "inferArgument", "Landroidx/navigation/safe/args/generator/models/Argument;", "name", "defaultValue", "rFilePackage", "parseBoolean", "Landroidx/navigation/safe/args/generator/BooleanValue;", "value", "parseFloatValue", "Landroidx/navigation/safe/args/generator/FloatValue;", "parseIntValue", "Landroidx/navigation/safe/args/generator/IntValue;", "parseLongValue", "Landroidx/navigation/safe/args/generator/LongValue;", "parseReference", "Landroidx/navigation/safe/args/generator/models/ResReference;", "xmlValue", "navigation-safe-args-generator"})
public final class NavParserKt {
    private static final String TAG_NAVIGATION = "navigation";
    private static final String TAG_ACTION = "action";
    private static final String TAG_ARGUMENT = "argument";
    private static final String TAG_INCLUDE = "include";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_DESTINATION = "destination";
    private static final String ATTRIBUTE_DEFAULT_VALUE = "defaultValue";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_TYPE = "argType";
    private static final String ATTRIBUTE_TYPE_DEPRECATED = "type";
    private static final String ATTRIBUTE_NULLABLE = "nullable";
    private static final String ATTRIBUTE_GRAPH = "graph";
    @NotNull
    public static final String VALUE_NULL = "@null";
    private static final String VALUE_TRUE = "true";
    private static final String VALUE_FALSE = "false";
    private static final String NAMESPACE_RES_AUTO = "http://schemas.android.com/apk/res-auto";
    private static final String NAMESPACE_ANDROID = "http://schemas.android.com/apk/res/android";
    private static final Regex RESOURCE_REGEX = new Regex("^@[+]?(.+?:)?(.+?)/(.+)$");

    @NotNull
    public static final Argument inferArgument(@NotNull String name, @NotNull String defaultValue, @NotNull String rFilePackage) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)ATTRIBUTE_NAME);
        Intrinsics.checkParameterIsNotNull((Object)defaultValue, (String)ATTRIBUTE_DEFAULT_VALUE);
        Intrinsics.checkParameterIsNotNull((Object)rFilePackage, (String)"rFilePackage");
        ResReference reference = NavParserKt.parseReference(defaultValue, rFilePackage);
        if (reference != null) {
            return new Argument(name, ReferenceType.INSTANCE, new ReferenceValue(reference), false, 8, null);
        }
        LongValue longValue = NavParserKt.parseLongValue(defaultValue);
        if (longValue != null) {
            return new Argument(name, LongType.INSTANCE, longValue, false, 8, null);
        }
        IntValue intValue = NavParserKt.parseIntValue(defaultValue);
        if (intValue != null) {
            return new Argument(name, IntType.INSTANCE, intValue, false, 8, null);
        }
        FloatValue floatValue = NavParserKt.parseFloatValue(defaultValue);
        if (floatValue != null) {
            return new Argument(name, FloatType.INSTANCE, floatValue, false, 8, null);
        }
        BooleanValue boolValue = NavParserKt.parseBoolean(defaultValue);
        if (boolValue != null) {
            return new Argument(name, BoolType.INSTANCE, boolValue, false, 8, null);
        }
        return new Argument(name, StringType.INSTANCE, new StringValue(defaultValue), false, 8, null);
    }

    @Nullable
    public static final ResReference parseReference(@NotNull String xmlValue, @NotNull String rFilePackage) {
        Intrinsics.checkParameterIsNotNull((Object)xmlValue, (String)"xmlValue");
        Intrinsics.checkParameterIsNotNull((Object)rFilePackage, (String)"rFilePackage");
        MatchResult matchResult = RESOURCE_REGEX.matchEntire((CharSequence)xmlValue);
        if (matchResult == null) {
            return null;
        }
        MatchResult matchEntire = matchResult;
        List groups = matchEntire.getGroupValues();
        String resourceName = (String)CollectionsKt.last((List)groups);
        String resType = (String)groups.get(groups.size() - 2);
        CharSequence charSequence = (CharSequence)groups.get(1);
        String packageName = charSequence.length() > 0 ? StringsKt.removeSuffix((String)((String)groups.get(1)), (CharSequence)":") : rFilePackage;
        return new ResReference(packageName, resType, resourceName);
    }

    @Nullable
    public static final IntValue parseIntValue(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        try {
            if (StringsKt.startsWith$default((String)value, (String)"0x", (boolean)false, (int)2, null)) {
                String string = value;
                int n = 2;
                String string2 = string.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                Integer.parseUnsignedInt(string2, 16);
            } else {
                Integer.parseInt(value);
            }
        }
        catch (NumberFormatException ex) {
            return null;
        }
        return new IntValue(value);
    }

    @Nullable
    public static final LongValue parseLongValue(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        if (!StringsKt.endsWith$default((CharSequence)value, (char)'L', (boolean)false, (int)2, null)) {
            return null;
        }
        try {
            String normalizedValue = StringsKt.substringBeforeLast$default((String)value, (char)'L', null, (int)2, null);
            if (StringsKt.startsWith$default((String)normalizedValue, (String)"0x", (boolean)false, (int)2, null)) {
                String string = normalizedValue;
                int n = 2;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                string = string3;
                n = 16;
                Long.parseLong(string, CharsKt.checkRadix((int)n));
            } else {
                String string = normalizedValue;
                Long.parseLong(string);
            }
        }
        catch (NumberFormatException ex) {
            return null;
        }
        return new LongValue(value);
    }

    private static final FloatValue parseFloatValue(String value) {
        FloatValue floatValue;
        Float f = StringsKt.toFloatOrNull((String)value);
        if (f != null) {
            Float f2 = f;
            float it = ((Number)f2).floatValue();
            floatValue = new FloatValue(value);
        } else {
            floatValue = null;
        }
        return floatValue;
    }

    private static final BooleanValue parseBoolean(String value) {
        if (Intrinsics.areEqual((Object)value, (Object)VALUE_TRUE) || Intrinsics.areEqual((Object)value, (Object)VALUE_FALSE)) {
            return new BooleanValue(value);
        }
        return null;
    }

    @Nullable
    public static final /* synthetic */ FloatValue access$parseFloatValue(@NotNull String value) {
        return NavParserKt.parseFloatValue(value);
    }

    @Nullable
    public static final /* synthetic */ BooleanValue access$parseBoolean(@NotNull String value) {
        return NavParserKt.parseBoolean(value);
    }
}

