/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.safeargs.gradle;

import androidx.navigation.safe.args.generator.NavSafeArgsGeneratorKt;
import androidx.navigation.safeargs.gradle.Mapping;
import com.android.build.gradle.internal.tasks.IncrementalTask;
import com.android.ide.common.resources.FileStatus;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\u001c\u0010\u001a\u001a\u00020\u00192\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0014J$\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\n2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0!2\u0006\u0010\"\u001a\u00020\u000bH\u0002J\b\u0010#\u001a\u00020$H\u0014J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001f0\nH\u0002J\u0016\u0010&\u001a\u00020\u00192\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001f0\nH\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\"\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u00020\u000b8\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u00020\u00048\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0006\"\u0004\b\u0017\u0010\b\u00a8\u0006("}, d2={"Landroidx/navigation/safeargs/gradle/ArgumentsGenerationTask;", "Lcom/android/build/gradle/internal/tasks/IncrementalTask;", "()V", "applicationId", "", "getApplicationId", "()Ljava/lang/String;", "setApplicationId", "(Ljava/lang/String;)V", "navigationFiles", "", "Ljava/io/File;", "getNavigationFiles", "()Ljava/util/List;", "setNavigationFiles", "(Ljava/util/List;)V", "outputDir", "getOutputDir", "()Ljava/io/File;", "setOutputDir", "(Ljava/io/File;)V", "rFilePackage", "getRFilePackage", "setRFilePackage", "doFullTaskAction", "", "doIncrementalTaskAction", "changedInputs", "", "Lcom/android/ide/common/resources/FileStatus;", "generateArgs", "Landroidx/navigation/safeargs/gradle/Mapping;", "navFiles", "", "out", "isIncremental", "", "readMappings", "writeMappings", "mappings", "navigation-safe-args-gradle-plugin"})
public class ArgumentsGenerationTask
extends IncrementalTask {
    @NotNull
    public String rFilePackage;
    @NotNull
    public String applicationId;
    @NotNull
    public File outputDir;
    @NotNull
    private List<? extends File> navigationFiles = CollectionsKt.emptyList();

    @Input
    @NotNull
    public final String getRFilePackage() {
        String string = this.rFilePackage;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rFilePackage");
        }
        return string;
    }

    public final void setRFilePackage(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.rFilePackage = string;
    }

    @Input
    @NotNull
    public final String getApplicationId() {
        String string = this.applicationId;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"applicationId");
        }
        return string;
    }

    public final void setApplicationId(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.applicationId = string;
    }

    @OutputDirectory
    @NotNull
    public final File getOutputDir() {
        File file = this.outputDir;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
        }
        return file;
    }

    public final void setOutputDir(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
        this.outputDir = file;
    }

    @InputFiles
    @NotNull
    public final List<File> getNavigationFiles() {
        return this.navigationFiles;
    }

    public final void setNavigationFiles(@NotNull List<? extends File> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.navigationFiles = list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Mapping> generateArgs(Collection<? extends File> navFiles, File out) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)navFiles;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void file;
            File file2 = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            Project project = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            File file3 = project.getProjectDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"project.projectDir");
            String string = FilesKt.relativeTo((File)file, (File)file3).getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.relativeTo(project.projectDir).path");
            String string2 = this.rFilePackage;
            if (string2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"rFilePackage");
            }
            String string3 = this.applicationId;
            if (string3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"applicationId");
            }
            Mapping mapping = new Mapping(string, NavSafeArgsGeneratorKt.generateSafeArgs((String)string2, (String)string3, (File)file, (File)out));
            collection.add(mapping);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeMappings(List<Mapping> mappings) {
        Object object = new File(this.getIncrementalFolder(), "file_mappings.json");
        Object object2 = Charsets.UTF_8;
        Object object3 = object;
        object3 = new FileOutputStream((File)object3);
        object = new OutputStreamWriter((OutputStream)object3, (Charset)object2);
        object2 = null;
        try {
            OutputStreamWriter it = (OutputStreamWriter)object;
            new Gson().toJson(mappings, (Appendable)it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<Mapping> readMappings() {
        Type type2 = new TypeToken<List<? extends Mapping>>(){}.getType();
        File mappingsFile = new File(this.getIncrementalFolder(), "file_mappings.json");
        if (mappingsFile.exists()) {
            List list;
            Object object = mappingsFile;
            Object object2 = Charsets.UTF_8;
            Object object3 = object;
            object3 = new FileInputStream((File)object3);
            object = new InputStreamReader((InputStream)object3, (Charset)object2);
            object2 = null;
            try {
                InputStreamReader it = (InputStreamReader)object;
                Object object4 = new Gson().fromJson((Reader)it, type2);
                Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"Gson().fromJson(it, type)");
                List list2 = (List)object4;
                list = list2;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"mappingsFile.reader().us\u2026on().fromJson(it, type) }");
            return list;
        }
        return CollectionsKt.emptyList();
    }

    protected void doFullTaskAction() {
        File file = this.outputDir;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
        }
        if (file.exists()) {
            File file2 = this.outputDir;
            if (file2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
            }
            if (!FilesKt.deleteRecursively((File)file2)) {
                Project project = this.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                project.getLogger().warn("Failed to clear directory for navigation arguments");
            }
        }
        File file3 = this.outputDir;
        if (file3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
        }
        if (!file3.exists()) {
            File file4 = this.outputDir;
            if (file4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
            }
            if (!file4.mkdirs()) {
                throw (Throwable)new GradleException("Failed to create directory for navigation arguments");
            }
        }
        Collection collection = this.navigationFiles;
        File file5 = this.outputDir;
        if (file5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
        }
        List<Mapping> mappings = this.generateArgs(collection, file5);
        this.writeMappings(mappings);
    }

    /*
     * WARNING - void declaration
     */
    protected void doIncrementalTaskAction(@NotNull Map<File, FileStatus> changedInputs) {
        Iterable $receiver$iv$iv;
        void modified;
        Iterable $receiver$iv;
        void $receiver$iv$iv2;
        Iterable $receiver$iv2;
        void $receiver$iv$iv3;
        Map<File, FileStatus> $receiver$iv3;
        Intrinsics.checkParameterIsNotNull(changedInputs, (String)"changedInputs");
        super.doIncrementalTaskAction(changedInputs);
        List<Mapping> oldMapping = this.readMappings();
        Map<File, FileStatus> map = $receiver$iv3 = changedInputs;
        Map destination$iv$iv = new LinkedHashMap();
        Iterable iterable = $receiver$iv$iv3;
        for (Map.Entry element$iv$iv : iterable.entrySet()) {
            Map.Entry $$_$_status = element$iv$iv;
            Map.Entry entry = $$_$_status;
            FileStatus status = (FileStatus)entry.getValue();
            if (!(status != FileStatus.REMOVED)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Set navFiles = destination$iv$iv.keySet();
        Collection collection = navFiles;
        File file = this.outputDir;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
        }
        List<Mapping> newMapping = this.generateArgs(collection, file);
        iterable = $receiver$iv2 = (Iterable)newMapping;
        Collection destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            Mapping it = (Mapping)element$iv$iv;
            Iterable list$iv$iv = it.getJavaFiles();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Set newJavaFiles = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        Iterable $receiver$iv4 = oldMapping;
        ArrayList first$iv = new ArrayList();
        Iterator second$iv = new ArrayList();
        for (Object element$iv : $receiver$iv4) {
            Mapping it = (Mapping)element$iv;
            Map<File, FileStatus> $i$f$flatMap = changedInputs;
            Project project = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            File file2 = new File(project.getProjectDir(), it.getNavFile());
            Map<File, FileStatus> map2 = $i$f$flatMap;
            if (map2.containsKey(file2)) {
                first$iv.add(element$iv);
                continue;
            }
            ((ArrayList)((Object)second$iv)).add(element$iv);
        }
        destination$iv$iv2 = new Pair(first$iv, second$iv);
        $receiver$iv2 = (List)destination$iv$iv2.component1();
        List unmodified = (List)destination$iv$iv2.component2();
        $receiver$iv4 = $receiver$iv = (Iterable)modified;
        Collection destination$iv$iv3 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Mapping it = (Mapping)element$iv$iv;
            Iterable list$iv$iv = it.getJavaFiles();
            CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv3;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv3 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            String name = (String)element$iv$iv;
            if (!(!newJavaFiles.contains(name))) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv3;
        for (Object element$iv : $receiver$iv) {
            File file3;
            String javaName = (String)element$iv;
            String fileName = "" + StringsKt.replace$default((String)javaName, (char)'.', (char)File.separatorChar, (boolean)false, (int)4, null) + ".java";
            File file4 = this.outputDir;
            if (file4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
            }
            if (!(file3 = new File(file4, fileName)).exists()) continue;
            file3.delete();
        }
        this.writeMappings(CollectionsKt.plus((Collection)unmodified, (Iterable)newMapping));
    }

    protected boolean isIncremental() {
        return true;
    }
}

