/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.ui;

import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.widget.BottomNavigationView;
import android.support.design.widget.CollapsingToolbarLayout;
import android.support.design.widget.NavigationView;
import android.support.v4.widget.DrawerLayout;
import android.support.v7.app.ActionBar;
import android.support.v7.app.ActionBarDrawerToggle;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.graphics.drawable.DrawerArrowDrawable;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewParent;
import androidx.navigation.NavController;
import androidx.navigation.NavDestination;
import androidx.navigation.NavGraph;
import androidx.navigation.NavOptions;
import androidx.navigation.ui.R;

public class NavigationUI {
    private NavigationUI() {
    }

    public static boolean onNavDestinationSelected(@NonNull MenuItem item, @NonNull NavController navController) {
        return NavigationUI.onNavDestinationSelected(item, navController, false);
    }

    static boolean onNavDestinationSelected(@NonNull MenuItem item, @NonNull NavController navController, boolean popUp) {
        NavOptions.Builder builder = new NavOptions.Builder().setLaunchSingleTop(true).setEnterAnim(R.anim.nav_default_enter_anim).setExitAnim(R.anim.nav_default_exit_anim).setPopEnterAnim(R.anim.nav_default_pop_enter_anim).setPopExitAnim(R.anim.nav_default_pop_exit_anim);
        if (popUp) {
            builder.setPopUpTo(NavigationUI.findStartDestination(navController.getGraph()).getId(), false);
        }
        NavOptions options = builder.build();
        try {
            navController.navigate(item.getItemId(), null, options);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean navigateUp(@Nullable DrawerLayout drawerLayout, @NonNull NavController navController) {
        if (drawerLayout != null && navController.getCurrentDestination() == NavigationUI.findStartDestination(navController.getGraph())) {
            drawerLayout.openDrawer(0x800003);
            return true;
        }
        return navController.navigateUp();
    }

    public static void setupActionBarWithNavController(@NonNull AppCompatActivity activity, @NonNull NavController navController) {
        NavigationUI.setupActionBarWithNavController(activity, navController, null);
    }

    public static void setupActionBarWithNavController(@NonNull AppCompatActivity activity, @NonNull NavController navController, @Nullable DrawerLayout drawerLayout) {
        navController.addOnNavigatedListener((NavController.OnNavigatedListener)new ActionBarOnNavigatedListener(activity, drawerLayout));
    }

    public static void setupWithNavController(@NonNull Toolbar toolbar, @NonNull NavController navController) {
        NavigationUI.setupWithNavController(toolbar, navController, null);
    }

    public static void setupWithNavController(@NonNull Toolbar toolbar, final @NonNull NavController navController, final @Nullable DrawerLayout drawerLayout) {
        navController.addOnNavigatedListener((NavController.OnNavigatedListener)new ToolbarOnNavigatedListener(toolbar, drawerLayout));
        toolbar.setNavigationOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NavigationUI.navigateUp(drawerLayout, navController);
            }
        });
    }

    public static void setupWithNavController(@NonNull CollapsingToolbarLayout collapsingToolbarLayout, @NonNull Toolbar toolbar, @NonNull NavController navController) {
        NavigationUI.setupWithNavController(collapsingToolbarLayout, toolbar, navController, null);
    }

    public static void setupWithNavController(@NonNull CollapsingToolbarLayout collapsingToolbarLayout, @NonNull Toolbar toolbar, final @NonNull NavController navController, final @Nullable DrawerLayout drawerLayout) {
        navController.addOnNavigatedListener((NavController.OnNavigatedListener)new CollapsingToolbarOnNavigatedListener(collapsingToolbarLayout, toolbar, drawerLayout));
        toolbar.setNavigationOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NavigationUI.navigateUp(drawerLayout, navController);
            }
        });
    }

    public static void setupWithNavController(final @NonNull NavigationView navigationView, final @NonNull NavController navController) {
        navigationView.setNavigationItemSelectedListener(new NavigationView.OnNavigationItemSelectedListener(){

            public boolean onNavigationItemSelected(@NonNull MenuItem item) {
                ViewParent parent;
                boolean handled = NavigationUI.onNavDestinationSelected(item, navController, true);
                if (handled && (parent = navigationView.getParent()) instanceof DrawerLayout) {
                    ((DrawerLayout)parent).closeDrawer((View)navigationView);
                }
                return handled;
            }
        });
        navController.addOnNavigatedListener(new NavController.OnNavigatedListener(){

            public void onNavigated(@NonNull NavController controller, @NonNull NavDestination destination) {
                Menu menu = navigationView.getMenu();
                int size = menu.size();
                for (int h = 0; h < size; ++h) {
                    MenuItem item = menu.getItem(h);
                    item.setChecked(NavigationUI.matchDestination(destination, item.getItemId()));
                }
            }
        });
    }

    public static void setupWithNavController(final @NonNull BottomNavigationView bottomNavigationView, final @NonNull NavController navController) {
        bottomNavigationView.setOnNavigationItemSelectedListener(new BottomNavigationView.OnNavigationItemSelectedListener(){

            public boolean onNavigationItemSelected(@NonNull MenuItem item) {
                return NavigationUI.onNavDestinationSelected(item, navController, true);
            }
        });
        navController.addOnNavigatedListener(new NavController.OnNavigatedListener(){

            public void onNavigated(@NonNull NavController controller, @NonNull NavDestination destination) {
                Menu menu = bottomNavigationView.getMenu();
                int size = menu.size();
                for (int h = 0; h < size; ++h) {
                    MenuItem item = menu.getItem(h);
                    if (!NavigationUI.matchDestination(destination, item.getItemId())) continue;
                    item.setChecked(true);
                }
            }
        });
    }

    static boolean matchDestination(@NonNull NavDestination destination, @IdRes int destId) {
        NavDestination currentDestination = destination;
        while (currentDestination.getId() != destId && currentDestination.getParent() != null) {
            currentDestination = currentDestination.getParent();
        }
        return currentDestination.getId() == destId;
    }

    static NavDestination findStartDestination(@NonNull NavGraph graph) {
        NavGraph startDestination = graph;
        while (startDestination instanceof NavGraph) {
            NavGraph parent = startDestination;
            startDestination = parent.findNode(parent.getStartDestination());
        }
        return startDestination;
    }

    private static abstract class AbstractAppBarOnNavigatedListener
    implements NavController.OnNavigatedListener {
        private final Context mContext;
        @Nullable
        private final DrawerLayout mDrawerLayout;
        private DrawerArrowDrawable mArrowDrawable;
        private ValueAnimator mAnimator;

        AbstractAppBarOnNavigatedListener(@NonNull Context context, @Nullable DrawerLayout drawerLayout) {
            this.mContext = context;
            this.mDrawerLayout = drawerLayout;
        }

        protected abstract void setTitle(CharSequence var1);

        protected abstract void setNavigationIcon(Drawable var1);

        public void onNavigated(@NonNull NavController controller, @NonNull NavDestination destination) {
            boolean isStartDestination;
            CharSequence title = destination.getLabel();
            if (!TextUtils.isEmpty((CharSequence)title)) {
                this.setTitle(title);
            }
            boolean bl = isStartDestination = NavigationUI.findStartDestination(controller.getGraph()) == destination;
            if (this.mDrawerLayout == null && isStartDestination) {
                this.setNavigationIcon(null);
            } else {
                this.setActionBarUpIndicator(this.mDrawerLayout != null && isStartDestination);
            }
        }

        void setActionBarUpIndicator(boolean showAsDrawerIndicator) {
            float endValue;
            boolean animate = true;
            if (this.mArrowDrawable == null) {
                this.mArrowDrawable = new DrawerArrowDrawable(this.mContext);
                animate = false;
            }
            this.setNavigationIcon((Drawable)this.mArrowDrawable);
            float f = endValue = showAsDrawerIndicator ? 0.0f : 1.0f;
            if (animate) {
                float startValue = this.mArrowDrawable.getProgress();
                if (this.mAnimator != null) {
                    this.mAnimator.cancel();
                }
                this.mAnimator = ObjectAnimator.ofFloat((Object)this.mArrowDrawable, (String)"progress", (float[])new float[]{startValue, endValue});
                this.mAnimator.start();
            } else {
                this.mArrowDrawable.setProgress(endValue);
            }
        }
    }

    private static class CollapsingToolbarOnNavigatedListener
    extends AbstractAppBarOnNavigatedListener {
        private final CollapsingToolbarLayout mCollapsingToolbarLayout;
        private final Toolbar mToolbar;

        CollapsingToolbarOnNavigatedListener(@NonNull CollapsingToolbarLayout collapsingToolbarLayout, @NonNull Toolbar toolbar, @Nullable DrawerLayout drawerLayout) {
            super(collapsingToolbarLayout.getContext(), drawerLayout);
            this.mCollapsingToolbarLayout = collapsingToolbarLayout;
            this.mToolbar = toolbar;
        }

        @Override
        protected void setTitle(CharSequence title) {
            this.mCollapsingToolbarLayout.setTitle(title);
        }

        @Override
        protected void setNavigationIcon(Drawable icon) {
            this.mToolbar.setNavigationIcon(icon);
        }
    }

    private static class ToolbarOnNavigatedListener
    extends AbstractAppBarOnNavigatedListener {
        private final Toolbar mToolbar;

        ToolbarOnNavigatedListener(@NonNull Toolbar toolbar, @Nullable DrawerLayout drawerLayout) {
            super(toolbar.getContext(), drawerLayout);
            this.mToolbar = toolbar;
        }

        @Override
        protected void setTitle(CharSequence title) {
            this.mToolbar.setTitle(title);
        }

        @Override
        protected void setNavigationIcon(Drawable icon) {
            this.mToolbar.setNavigationIcon(icon);
        }
    }

    private static class ActionBarOnNavigatedListener
    extends AbstractAppBarOnNavigatedListener {
        private final AppCompatActivity mActivity;

        ActionBarOnNavigatedListener(@NonNull AppCompatActivity activity, @Nullable DrawerLayout drawerLayout) {
            super(activity.getDrawerToggleDelegate().getActionBarThemedContext(), drawerLayout);
            this.mActivity = activity;
        }

        @Override
        protected void setTitle(CharSequence title) {
            ActionBar actionBar = this.mActivity.getSupportActionBar();
            actionBar.setTitle(title);
        }

        @Override
        protected void setNavigationIcon(Drawable icon) {
            ActionBar actionBar = this.mActivity.getSupportActionBar();
            if (icon == null) {
                actionBar.setDisplayHomeAsUpEnabled(false);
            } else {
                actionBar.setDisplayHomeAsUpEnabled(true);
                ActionBarDrawerToggle.Delegate delegate = this.mActivity.getDrawerToggleDelegate();
                delegate.setActionBarUpIndicator(icon, 0);
            }
        }
    }
}

