/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.ui;

import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import android.support.v7.app.ActionBar;
import android.support.v7.app.ActionBarDrawerToggle;
import android.support.v7.app.AppCompatActivity;
import androidx.navigation.ui.AbstractAppBarOnNavigatedListener;
import androidx.navigation.ui.AppBarConfiguration;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
class ActionBarOnNavigatedListener
extends AbstractAppBarOnNavigatedListener {
    private final AppCompatActivity mActivity;

    ActionBarOnNavigatedListener(@NonNull AppCompatActivity activity, @NonNull AppBarConfiguration configuration) {
        super(activity.getDrawerToggleDelegate().getActionBarThemedContext(), configuration);
        this.mActivity = activity;
    }

    @Override
    protected void setTitle(CharSequence title) {
        ActionBar actionBar = this.mActivity.getSupportActionBar();
        actionBar.setTitle(title);
    }

    @Override
    protected void setNavigationIcon(Drawable icon) {
        ActionBar actionBar = this.mActivity.getSupportActionBar();
        if (icon == null) {
            actionBar.setDisplayHomeAsUpEnabled(false);
        } else {
            actionBar.setDisplayHomeAsUpEnabled(true);
            ActionBarDrawerToggle.Delegate delegate = this.mActivity.getDrawerToggleDelegate();
            delegate.setActionBarUpIndicator(icon, 0);
        }
    }
}

