/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.ui;

import android.annotation.SuppressLint;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.widget.DrawerLayout;
import androidx.navigation.NavGraph;
import androidx.navigation.ui.NavigationUI;
import java.util.HashSet;
import java.util.Set;

public class AppBarConfiguration {
    @NonNull
    private final Set<Integer> mTopLevelDestinations;
    @Nullable
    private final DrawerLayout mDrawerLayout;

    private AppBarConfiguration(@NonNull Set<Integer> topLevelDestinations, @Nullable DrawerLayout drawerLayout) {
        this.mTopLevelDestinations = topLevelDestinations;
        this.mDrawerLayout = drawerLayout;
    }

    @NonNull
    public Set<Integer> getTopLevelDestinations() {
        return this.mTopLevelDestinations;
    }

    @Nullable
    public DrawerLayout getDrawerLayout() {
        return this.mDrawerLayout;
    }

    public static class Builder {
        @NonNull
        private final Set<Integer> mTopLevelDestinations = new HashSet<Integer>();
        @Nullable
        private DrawerLayout mDrawerLayout;

        public Builder(@NonNull NavGraph navGraph) {
            this.mTopLevelDestinations.add(NavigationUI.findStartDestination(navGraph).getId());
        }

        public Builder(int ... topLevelDestinationIds) {
            for (int destinationId : topLevelDestinationIds) {
                this.mTopLevelDestinations.add(destinationId);
            }
        }

        public Builder(@NonNull Set<Integer> topLevelDestinationIds) {
            this.mTopLevelDestinations.addAll(topLevelDestinationIds);
        }

        @NonNull
        public Builder setDrawerLayout(@Nullable DrawerLayout drawerLayout) {
            this.mDrawerLayout = drawerLayout;
            return this;
        }

        @SuppressLint(value={"SyntheticAccessor"})
        @NonNull
        public AppBarConfiguration build() {
            return new AppBarConfiguration(this.mTopLevelDestinations, this.mDrawerLayout);
        }
    }
}

