/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.ui;

import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import android.support.design.widget.CollapsingToolbarLayout;
import android.support.v7.widget.Toolbar;
import androidx.navigation.NavController;
import androidx.navigation.NavDestination;
import androidx.navigation.ui.AbstractAppBarOnNavigatedListener;
import androidx.navigation.ui.AppBarConfiguration;
import java.lang.ref.WeakReference;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
class CollapsingToolbarOnNavigatedListener
extends AbstractAppBarOnNavigatedListener {
    private final WeakReference<CollapsingToolbarLayout> mCollapsingToolbarLayoutWeakReference;
    private final WeakReference<Toolbar> mToolbarWeakReference;

    CollapsingToolbarOnNavigatedListener(@NonNull CollapsingToolbarLayout collapsingToolbarLayout, @NonNull Toolbar toolbar, @NonNull AppBarConfiguration configuration) {
        super(collapsingToolbarLayout.getContext(), configuration);
        this.mCollapsingToolbarLayoutWeakReference = new WeakReference<CollapsingToolbarLayout>(collapsingToolbarLayout);
        this.mToolbarWeakReference = new WeakReference<Toolbar>(toolbar);
    }

    @Override
    public void onNavigated(@NonNull NavController controller, @NonNull NavDestination destination) {
        CollapsingToolbarLayout collapsingToolbarLayout = (CollapsingToolbarLayout)this.mCollapsingToolbarLayoutWeakReference.get();
        Toolbar toolbar = (Toolbar)this.mToolbarWeakReference.get();
        if (collapsingToolbarLayout == null || toolbar == null) {
            controller.removeOnNavigatedListener((NavController.OnNavigatedListener)this);
            return;
        }
        super.onNavigated(controller, destination);
    }

    @Override
    protected void setTitle(CharSequence title) {
        CollapsingToolbarLayout collapsingToolbarLayout = (CollapsingToolbarLayout)this.mCollapsingToolbarLayoutWeakReference.get();
        if (collapsingToolbarLayout != null) {
            collapsingToolbarLayout.setTitle(title);
        }
    }

    @Override
    protected void setNavigationIcon(Drawable icon) {
        Toolbar toolbar = (Toolbar)this.mToolbarWeakReference.get();
        if (toolbar != null) {
            toolbar.setNavigationIcon(icon);
        }
    }
}

