/*
 * Decompiled with CFR 0.152.
 */
package android.arch.paging;

import android.arch.paging.ContiguousDataSource;
import android.arch.paging.ContiguousPagedList;
import android.arch.paging.DataSource;
import android.arch.paging.PagedStorage;
import android.arch.paging.PositionalDataSource;
import android.arch.paging.SnapshotPagedList;
import android.arch.paging.TiledPagedList;
import android.support.annotation.AnyThread;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.annotation.WorkerThread;
import java.lang.ref.WeakReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class PagedList<T>
extends AbstractList<T> {
    @NonNull
    final Executor mMainThreadExecutor;
    @NonNull
    final Executor mBackgroundThreadExecutor;
    @Nullable
    final BoundaryCallback<T> mBoundaryCallback;
    @NonNull
    final Config mConfig;
    @NonNull
    final PagedStorage<T> mStorage;
    int mLastLoad = 0;
    T mLastItem = null;
    private boolean mBoundaryCallbackBeginDeferred = false;
    private boolean mBoundaryCallbackEndDeferred = false;
    private int mLowestIndexAccessed = Integer.MAX_VALUE;
    private int mHighestIndexAccessed = Integer.MIN_VALUE;
    private final AtomicBoolean mDetached = new AtomicBoolean(false);
    private final ArrayList<WeakReference<Callback>> mCallbacks = new ArrayList();

    PagedList(@NonNull PagedStorage<T> storage, @NonNull Executor mainThreadExecutor, @NonNull Executor backgroundThreadExecutor, @Nullable BoundaryCallback<T> boundaryCallback, @NonNull Config config) {
        this.mStorage = storage;
        this.mMainThreadExecutor = mainThreadExecutor;
        this.mBackgroundThreadExecutor = backgroundThreadExecutor;
        this.mBoundaryCallback = boundaryCallback;
        this.mConfig = config;
    }

    @NonNull
    private static <K, T> PagedList<T> create(@NonNull DataSource<K, T> dataSource, @NonNull Executor notifyExecutor, @NonNull Executor fetchExecutor, @Nullable BoundaryCallback<T> boundaryCallback, @NonNull Config config, @Nullable K key) {
        if (dataSource.isContiguous() || !config.enablePlaceholders) {
            int lastLoad = -1;
            if (!dataSource.isContiguous()) {
                dataSource = ((PositionalDataSource)dataSource).wrapAsContiguousWithoutPlaceholders();
                if (key != null) {
                    lastLoad = (Integer)key;
                }
            }
            ContiguousDataSource contigDataSource = (ContiguousDataSource)dataSource;
            return new ContiguousPagedList<K, T>(contigDataSource, notifyExecutor, fetchExecutor, boundaryCallback, config, key, lastLoad);
        }
        return new TiledPagedList<T>((PositionalDataSource)dataSource, notifyExecutor, fetchExecutor, boundaryCallback, config, key != null ? (Integer)key : 0);
    }

    @Override
    @Nullable
    public T get(int index) {
        T item = this.mStorage.get(index);
        if (item != null) {
            this.mLastItem = item;
        }
        return item;
    }

    public void loadAround(int index) {
        this.mLastLoad = index + this.getPositionOffset();
        this.loadAroundInternal(index);
        this.mLowestIndexAccessed = Math.min(this.mLowestIndexAccessed, index);
        this.mHighestIndexAccessed = Math.max(this.mHighestIndexAccessed, index);
        this.tryDispatchBoundaryCallbacks(true);
    }

    @AnyThread
    void deferBoundaryCallbacks(final boolean deferEmpty, final boolean deferBegin, final boolean deferEnd) {
        if (this.mBoundaryCallback == null) {
            throw new IllegalStateException("Can't defer BoundaryCallback, no instance");
        }
        if (this.mLowestIndexAccessed == Integer.MAX_VALUE) {
            this.mLowestIndexAccessed = this.mStorage.size();
        }
        if (this.mHighestIndexAccessed == Integer.MIN_VALUE) {
            this.mHighestIndexAccessed = 0;
        }
        if (deferEmpty || deferBegin || deferEnd) {
            this.mMainThreadExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    if (deferEmpty) {
                        PagedList.this.mBoundaryCallback.onZeroItemsLoaded();
                    }
                    if (deferBegin) {
                        PagedList.this.mBoundaryCallbackBeginDeferred = true;
                    }
                    if (deferEnd) {
                        PagedList.this.mBoundaryCallbackEndDeferred = true;
                    }
                    PagedList.this.tryDispatchBoundaryCallbacks(false);
                }
            });
        }
    }

    private void tryDispatchBoundaryCallbacks(boolean post) {
        boolean dispatchEnd;
        final boolean dispatchBegin = this.mBoundaryCallbackBeginDeferred && this.mLowestIndexAccessed <= this.mConfig.prefetchDistance;
        boolean bl = dispatchEnd = this.mBoundaryCallbackEndDeferred && this.mHighestIndexAccessed >= this.size() - 1 - this.mConfig.prefetchDistance;
        if (!dispatchBegin && !dispatchEnd) {
            return;
        }
        if (dispatchBegin) {
            this.mBoundaryCallbackBeginDeferred = false;
        }
        if (dispatchEnd) {
            this.mBoundaryCallbackEndDeferred = false;
        }
        if (post) {
            this.mMainThreadExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    PagedList.this.dispatchBoundaryCallbacks(dispatchBegin, dispatchEnd);
                }
            });
        } else {
            this.dispatchBoundaryCallbacks(dispatchBegin, dispatchEnd);
        }
    }

    private void dispatchBoundaryCallbacks(boolean begin, boolean end) {
        if (begin) {
            this.mBoundaryCallback.onItemAtFrontLoaded(this.mStorage.getFirstLoadedItem());
        }
        if (end) {
            this.mBoundaryCallback.onItemAtEndLoaded(this.mStorage.getLastLoadedItem());
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    void offsetBoundaryAccessIndices(int offset) {
        this.mLowestIndexAccessed += offset;
        this.mHighestIndexAccessed += offset;
    }

    @Override
    public int size() {
        return this.mStorage.size();
    }

    public boolean isImmutable() {
        return this.isDetached();
    }

    @NonNull
    public List<T> snapshot() {
        if (this.isImmutable()) {
            return this;
        }
        return new SnapshotPagedList(this);
    }

    abstract boolean isContiguous();

    @NonNull
    public Config getConfig() {
        return this.mConfig;
    }

    @NonNull
    public abstract DataSource<?, T> getDataSource();

    @Nullable
    public abstract Object getLastKey();

    public boolean isDetached() {
        return this.mDetached.get();
    }

    public void detach() {
        this.mDetached.set(true);
    }

    public int getPositionOffset() {
        return this.mStorage.getPositionOffset();
    }

    public void addWeakCallback(@Nullable List<T> previousSnapshot, @NonNull Callback callback) {
        if (previousSnapshot != null && previousSnapshot != this) {
            if (previousSnapshot.isEmpty()) {
                if (!this.mStorage.isEmpty()) {
                    callback.onInserted(0, this.mStorage.size());
                }
            } else {
                PagedList storageSnapshot = (PagedList)previousSnapshot;
                this.dispatchUpdatesSinceSnapshot(storageSnapshot, callback);
            }
        }
        for (int i = this.mCallbacks.size() - 1; i >= 0; --i) {
            Callback currentCallback = (Callback)this.mCallbacks.get(i).get();
            if (currentCallback != null) continue;
            this.mCallbacks.remove(i);
        }
        this.mCallbacks.add(new WeakReference<Callback>(callback));
    }

    public void removeWeakCallback(@NonNull Callback callback) {
        for (int i = this.mCallbacks.size() - 1; i >= 0; --i) {
            Callback currentCallback = (Callback)this.mCallbacks.get(i).get();
            if (currentCallback != null && currentCallback != callback) continue;
            this.mCallbacks.remove(i);
        }
    }

    void notifyInserted(int position, int count) {
        if (count != 0) {
            for (int i = this.mCallbacks.size() - 1; i >= 0; --i) {
                Callback callback = (Callback)this.mCallbacks.get(i).get();
                if (callback == null) continue;
                callback.onInserted(position, count);
            }
        }
    }

    void notifyChanged(int position, int count) {
        if (count != 0) {
            for (int i = this.mCallbacks.size() - 1; i >= 0; --i) {
                Callback callback = (Callback)this.mCallbacks.get(i).get();
                if (callback == null) continue;
                callback.onChanged(position, count);
            }
        }
    }

    abstract void dispatchUpdatesSinceSnapshot(@NonNull PagedList<T> var1, @NonNull Callback var2);

    abstract void loadAroundInternal(int var1);

    @MainThread
    public static abstract class BoundaryCallback<T> {
        public void onZeroItemsLoaded() {
        }

        public void onItemAtFrontLoaded(@NonNull T itemAtFront) {
        }

        public void onItemAtEndLoaded(@NonNull T itemAtEnd) {
        }
    }

    public static class Config {
        public final int pageSize;
        public final int prefetchDistance;
        public final boolean enablePlaceholders;
        public final int initialLoadSizeHint;

        private Config(int pageSize, int prefetchDistance, boolean enablePlaceholders, int initialLoadSizeHint) {
            this.pageSize = pageSize;
            this.prefetchDistance = prefetchDistance;
            this.enablePlaceholders = enablePlaceholders;
            this.initialLoadSizeHint = initialLoadSizeHint;
        }

        public static final class Builder {
            private int mPageSize = -1;
            private int mPrefetchDistance = -1;
            private int mInitialLoadSizeHint = -1;
            private boolean mEnablePlaceholders = true;

            public Builder setPageSize(int pageSize) {
                this.mPageSize = pageSize;
                return this;
            }

            public Builder setPrefetchDistance(int prefetchDistance) {
                this.mPrefetchDistance = prefetchDistance;
                return this;
            }

            public Builder setEnablePlaceholders(boolean enablePlaceholders) {
                this.mEnablePlaceholders = enablePlaceholders;
                return this;
            }

            public Builder setInitialLoadSizeHint(int initialLoadSizeHint) {
                this.mInitialLoadSizeHint = initialLoadSizeHint;
                return this;
            }

            public Config build() {
                if (this.mPageSize < 1) {
                    throw new IllegalArgumentException("Page size must be a positive number");
                }
                if (this.mPrefetchDistance < 0) {
                    this.mPrefetchDistance = this.mPageSize;
                }
                if (this.mInitialLoadSizeHint < 0) {
                    this.mInitialLoadSizeHint = this.mPageSize * 3;
                }
                if (!this.mEnablePlaceholders && this.mPrefetchDistance == 0) {
                    throw new IllegalArgumentException("Placeholders and prefetch are the only ways to trigger loading of more data in the PagedList, so either placeholders must be enabled, or prefetch distance must be > 0.");
                }
                return new Config(this.mPageSize, this.mPrefetchDistance, this.mEnablePlaceholders, this.mInitialLoadSizeHint);
            }
        }
    }

    public static abstract class Callback {
        public abstract void onChanged(int var1, int var2);

        public abstract void onInserted(int var1, int var2);

        public abstract void onRemoved(int var1, int var2);
    }

    public static final class Builder<Key, Value> {
        private final DataSource<Key, Value> mDataSource;
        private final Config mConfig;
        private Executor mNotifyExecutor;
        private Executor mFetchExecutor;
        private BoundaryCallback mBoundaryCallback;
        private Key mInitialKey;

        public Builder(@NonNull DataSource<Key, Value> dataSource, @NonNull Config config) {
            if (dataSource == null) {
                throw new IllegalArgumentException("DataSource may not be null");
            }
            if (config == null) {
                throw new IllegalArgumentException("Config may not be null");
            }
            this.mDataSource = dataSource;
            this.mConfig = config;
        }

        public Builder(@NonNull DataSource<Key, Value> dataSource, int pageSize) {
            this(dataSource, new Config.Builder().setPageSize(pageSize).build());
        }

        @NonNull
        public Builder<Key, Value> setNotifyExecutor(@NonNull Executor notifyExecutor) {
            this.mNotifyExecutor = notifyExecutor;
            return this;
        }

        @NonNull
        public Builder<Key, Value> setFetchExecutor(@NonNull Executor fetchExecutor) {
            this.mFetchExecutor = fetchExecutor;
            return this;
        }

        @NonNull
        public Builder<Key, Value> setBoundaryCallback(@Nullable BoundaryCallback boundaryCallback) {
            this.mBoundaryCallback = boundaryCallback;
            return this;
        }

        @NonNull
        public Builder<Key, Value> setInitialKey(@Nullable Key initialKey) {
            this.mInitialKey = initialKey;
            return this;
        }

        @WorkerThread
        @NonNull
        public PagedList<Value> build() {
            if (this.mNotifyExecutor == null) {
                throw new IllegalArgumentException("MainThreadExecutor required");
            }
            if (this.mFetchExecutor == null) {
                throw new IllegalArgumentException("BackgroundThreadExecutor required");
            }
            return PagedList.create(this.mDataSource, this.mNotifyExecutor, this.mFetchExecutor, this.mBoundaryCallback, this.mConfig, this.mInitialKey);
        }
    }
}

