/*
 * Decompiled with CFR 0.152.
 */
package android.arch.paging;

import android.arch.paging.DataSource;
import android.arch.paging.PageResult;
import android.arch.paging.PagedList;
import android.arch.paging.PagedStorage;
import android.arch.paging.PositionalDataSource;
import android.support.annotation.AnyThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import java.util.concurrent.Executor;

class TiledPagedList<T>
extends PagedList<T>
implements PagedStorage.Callback {
    private final PositionalDataSource<T> mDataSource;
    private PageResult.Receiver<T> mReceiver = new PageResult.Receiver<T>(){

        @Override
        @AnyThread
        public void onPageResult(int type, @NonNull PageResult<T> pageResult) {
            if (pageResult.isInvalid()) {
                TiledPagedList.this.detach();
                return;
            }
            if (TiledPagedList.this.isDetached()) {
                return;
            }
            if (type != 0 && type != 3) {
                throw new IllegalArgumentException("unexpected resultType" + type);
            }
            if (TiledPagedList.this.mStorage.getPageCount() == 0) {
                TiledPagedList.this.mStorage.initAndSplit(pageResult.leadingNulls, pageResult.page, pageResult.trailingNulls, pageResult.positionOffset, TiledPagedList.this.mConfig.pageSize, TiledPagedList.this);
            } else {
                TiledPagedList.this.mStorage.insertPage(pageResult.positionOffset, pageResult.page, TiledPagedList.this);
            }
            if (TiledPagedList.this.mBoundaryCallback != null) {
                boolean deferEmpty = TiledPagedList.this.mStorage.size() == 0;
                boolean deferBegin = !deferEmpty && pageResult.leadingNulls == 0 && pageResult.positionOffset == 0;
                int size = TiledPagedList.this.size();
                boolean deferEnd = !deferEmpty && (type == 0 && pageResult.trailingNulls == 0 || type == 3 && pageResult.positionOffset + TiledPagedList.this.mConfig.pageSize >= size);
                TiledPagedList.this.deferBoundaryCallbacks(deferEmpty, deferBegin, deferEnd);
            }
        }
    };

    @WorkerThread
    TiledPagedList(@NonNull PositionalDataSource<T> dataSource, @NonNull Executor mainThreadExecutor, @NonNull Executor backgroundThreadExecutor, @Nullable PagedList.BoundaryCallback<T> boundaryCallback, @NonNull PagedList.Config config, int position) {
        super(new PagedStorage(), mainThreadExecutor, backgroundThreadExecutor, boundaryCallback, config);
        this.mDataSource = dataSource;
        int pageSize = this.mConfig.pageSize;
        this.mLastLoad = position;
        if (this.mDataSource.isInvalid()) {
            this.detach();
        } else {
            int firstLoadSize = Math.max(Math.round(this.mConfig.initialLoadSizeHint / pageSize), 2) * pageSize;
            int idealStart = position - firstLoadSize / 2;
            int roundedPageStart = Math.max(0, Math.round(idealStart / pageSize) * pageSize);
            this.mDataSource.dispatchLoadInitial(true, roundedPageStart, firstLoadSize, pageSize, this.mMainThreadExecutor, this.mReceiver);
        }
    }

    @Override
    boolean isContiguous() {
        return false;
    }

    @Override
    @NonNull
    public DataSource<?, T> getDataSource() {
        return this.mDataSource;
    }

    @Override
    @Nullable
    public Object getLastKey() {
        return this.mLastLoad;
    }

    @Override
    protected void dispatchUpdatesSinceSnapshot(@NonNull PagedList<T> pagedListSnapshot, @NonNull PagedList.Callback callback) {
        PagedStorage snapshot = pagedListSnapshot.mStorage;
        if (snapshot.isEmpty() || this.mStorage.size() != snapshot.size()) {
            throw new IllegalArgumentException("Invalid snapshot provided - doesn't appear to be a snapshot of this PagedList");
        }
        int pageSize = this.mConfig.pageSize;
        int leadingNullPages = this.mStorage.getLeadingNullCount() / pageSize;
        int pageCount = this.mStorage.getPageCount();
        for (int i = 0; i < pageCount; ++i) {
            int updatedPages;
            int pageIndex = i + leadingNullPages;
            for (updatedPages = 0; updatedPages < this.mStorage.getPageCount() && this.mStorage.hasPage(pageSize, pageIndex + updatedPages) && !snapshot.hasPage(pageSize, pageIndex + updatedPages); ++updatedPages) {
            }
            if (updatedPages <= 0) continue;
            callback.onChanged(pageIndex * pageSize, pageSize * updatedPages);
            i += updatedPages - 1;
        }
    }

    @Override
    protected void loadAroundInternal(int index) {
        this.mStorage.allocatePlaceholders(index, this.mConfig.prefetchDistance, this.mConfig.pageSize, this);
    }

    @Override
    public void onInitialized(int count) {
        this.notifyInserted(0, count);
    }

    @Override
    public void onPagePrepended(int leadingNulls, int changed, int added) {
        throw new IllegalStateException("Contiguous callback on TiledPagedList");
    }

    @Override
    public void onPageAppended(int endPosition, int changed, int added) {
        throw new IllegalStateException("Contiguous callback on TiledPagedList");
    }

    @Override
    public void onPagePlaceholderInserted(final int pageIndex) {
        this.mBackgroundThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (TiledPagedList.this.isDetached()) {
                    return;
                }
                int pageSize = TiledPagedList.this.mConfig.pageSize;
                if (TiledPagedList.this.mDataSource.isInvalid()) {
                    TiledPagedList.this.detach();
                } else {
                    int startPosition = pageIndex * pageSize;
                    int count = Math.min(pageSize, TiledPagedList.this.mStorage.size() - startPosition);
                    TiledPagedList.this.mDataSource.dispatchLoadRange(3, startPosition, count, TiledPagedList.this.mMainThreadExecutor, TiledPagedList.this.mReceiver);
                }
            }
        });
    }

    @Override
    public void onPageInserted(int start, int count) {
        this.notifyChanged(start, count);
    }
}

