/*
 * Decompiled with CFR 0.152.
 */
package android.arch.paging;

import android.arch.core.util.Function;
import android.arch.paging.DataSource;
import android.arch.paging.ItemKeyedDataSource;
import android.support.annotation.NonNull;
import java.util.IdentityHashMap;
import java.util.List;

class WrapperItemKeyedDataSource<K, A, B>
extends ItemKeyedDataSource<K, B> {
    private final ItemKeyedDataSource<K, A> mSource;
    private final Function<List<A>, List<B>> mListFunction;
    private final IdentityHashMap<B, K> mKeyMap = new IdentityHashMap();

    WrapperItemKeyedDataSource(ItemKeyedDataSource<K, A> source, Function<List<A>, List<B>> listFunction) {
        this.mSource = source;
        this.mListFunction = listFunction;
    }

    @Override
    public void addInvalidatedCallback(@NonNull DataSource.InvalidatedCallback onInvalidatedCallback) {
        this.mSource.addInvalidatedCallback(onInvalidatedCallback);
    }

    @Override
    public void removeInvalidatedCallback(@NonNull DataSource.InvalidatedCallback onInvalidatedCallback) {
        this.mSource.removeInvalidatedCallback(onInvalidatedCallback);
    }

    @Override
    public void invalidate() {
        this.mSource.invalidate();
    }

    @Override
    public boolean isInvalid() {
        return this.mSource.isInvalid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<B> convertWithStashedKeys(List<A> source) {
        List<B> dest = WrapperItemKeyedDataSource.convert(this.mListFunction, source);
        IdentityHashMap<B, K> identityHashMap = this.mKeyMap;
        synchronized (identityHashMap) {
            for (int i = 0; i < dest.size(); ++i) {
                this.mKeyMap.put(dest.get(i), this.mSource.getKey(source.get(i)));
            }
        }
        return dest;
    }

    @Override
    public void loadInitial(@NonNull ItemKeyedDataSource.LoadInitialParams<K> params, final @NonNull ItemKeyedDataSource.LoadInitialCallback<B> callback) {
        this.mSource.loadInitial(params, new ItemKeyedDataSource.LoadInitialCallback<A>(){

            @Override
            public void onResult(@NonNull List<A> data, int position, int totalCount) {
                callback.onResult(WrapperItemKeyedDataSource.this.convertWithStashedKeys(data), position, totalCount);
            }

            @Override
            public void onResult(@NonNull List<A> data) {
                callback.onResult(WrapperItemKeyedDataSource.this.convertWithStashedKeys(data));
            }
        });
    }

    @Override
    public void loadAfter(@NonNull ItemKeyedDataSource.LoadParams<K> params, final @NonNull ItemKeyedDataSource.LoadCallback<B> callback) {
        this.mSource.loadAfter(params, new ItemKeyedDataSource.LoadCallback<A>(){

            @Override
            public void onResult(@NonNull List<A> data) {
                callback.onResult(WrapperItemKeyedDataSource.this.convertWithStashedKeys(data));
            }
        });
    }

    @Override
    public void loadBefore(@NonNull ItemKeyedDataSource.LoadParams<K> params, final @NonNull ItemKeyedDataSource.LoadCallback<B> callback) {
        this.mSource.loadBefore(params, new ItemKeyedDataSource.LoadCallback<A>(){

            @Override
            public void onResult(@NonNull List<A> data) {
                callback.onResult(WrapperItemKeyedDataSource.this.convertWithStashedKeys(data));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public K getKey(@NonNull B item) {
        IdentityHashMap<B, K> identityHashMap = this.mKeyMap;
        synchronized (identityHashMap) {
            return this.mKeyMap.get(item);
        }
    }
}

