/*
 * Decompiled with CFR 0.152.
 */
package android.arch.persistence.room.verifier;

import android.arch.persistence.room.processor.Context;
import android.arch.persistence.room.verifier.DatabaseVerificaitonErrors;
import android.arch.persistence.room.verifier.QueryResultInfo;
import android.arch.persistence.room.vo.Entity;
import android.arch.persistence.room.vo.Warning;
import java.io.File;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import javax.lang.model.element.Element;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.sqlite.JDBC;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B%\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Landroid/arch/persistence/room/verifier/DatabaseVerifier;", "", "connection", "Ljava/sql/Connection;", "context", "Landroid/arch/persistence/room/processor/Context;", "entities", "", "Landroid/arch/persistence/room/vo/Entity;", "(Ljava/sql/Connection;Landroid/arch/persistence/room/processor/Context;Ljava/util/List;)V", "getConnection", "()Ljava/sql/Connection;", "getContext", "()Landroid/arch/persistence/room/processor/Context;", "getEntities", "()Ljava/util/List;", "analyze", "Landroid/arch/persistence/room/verifier/QueryResultInfo;", "sql", "", "closeConnection", "", "Companion", "compiler"})
public final class DatabaseVerifier {
    @NotNull
    private final Connection connection;
    @NotNull
    private final Context context;
    @NotNull
    private final List<Entity> entities;
    private static final String CONNECTION_URL = "jdbc:sqlite::memory:";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final QueryResultInfo analyze(@NotNull String sql) {
        QueryResultInfo queryResultInfo;
        Intrinsics.checkParameterIsNotNull((Object)sql, (String)"sql");
        try {
            PreparedStatement stmt;
            PreparedStatement preparedStatement = stmt = this.connection.prepareStatement(sql);
            Intrinsics.checkExpressionValueIsNotNull((Object)preparedStatement, (String)"stmt");
            queryResultInfo = new QueryResultInfo(Jdbc_extKt.columnInfo(preparedStatement), null, 2, null);
        }
        catch (SQLException ex) {
            queryResultInfo = new QueryResultInfo(CollectionsKt.emptyList(), ex);
        }
        return queryResultInfo;
    }

    public final void closeConnection(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (!this.connection.isClosed()) {
            try {
                this.connection.close();
            }
            catch (Throwable t) {
                context.getLogger().d("failed to close the database connection " + t.getMessage(), new Object[0]);
            }
        }
    }

    @NotNull
    public final Connection getConnection() {
        return this.connection;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final List<Entity> getEntities() {
        return this.entities;
    }

    private DatabaseVerifier(Connection connection, Context context, List<Entity> entities) {
        this.connection = connection;
        this.context = context;
        this.entities = entities;
        Iterable $receiver$iv = this.entities;
        for (Object element$iv : $receiver$iv) {
            Entity entity = (Entity)element$iv;
            Statement stmt = this.connection.createStatement();
            stmt.executeUpdate(entity.getCreateTableQuery());
        }
    }

    static {
        String tmpDir = System.getProperty("java.io.tmpdir");
        if (tmpDir != null) {
            File outDir = new File(tmpDir, "room-" + UUID.randomUUID());
            outDir.mkdirs();
            outDir.deleteOnExit();
            System.setProperty("org.sqlite.tmpdir", outDir.getAbsolutePath());
            JDBC.isValidURL((String)CONNECTION_URL);
            DatabaseVerifier.Companion.unregisterDrivers();
        }
    }

    public /* synthetic */ DatabaseVerifier(@NotNull Connection connection, @NotNull Context context, @NotNull List entities, DefaultConstructorMarker $constructor_marker) {
        this(connection, context, entities);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\b\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Landroid/arch/persistence/room/verifier/DatabaseVerifier$Companion;", "", "()V", "CONNECTION_URL", "", "create", "Landroid/arch/persistence/room/verifier/DatabaseVerifier;", "context", "Landroid/arch/persistence/room/processor/Context;", "element", "Ljavax/lang/model/element/Element;", "entities", "", "Landroid/arch/persistence/room/vo/Entity;", "unregisterDrivers", "", "compiler"})
    public static final class Companion {
        @Nullable
        public final DatabaseVerifier create(@NotNull Context context, @NotNull Element element, @NotNull List<Entity> entities) {
            DatabaseVerifier databaseVerifier;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull(entities, (String)"entities");
            try {
                Connection connection;
                Connection connection2 = connection = JDBC.createConnection((String)DatabaseVerifier.CONNECTION_URL, (Properties)new Properties());
                Intrinsics.checkExpressionValueIsNotNull((Object)connection2, (String)"connection");
                databaseVerifier = new DatabaseVerifier(connection2, context, entities, null);
            }
            catch (Exception ex) {
                context.getLogger().w(Warning.CANNOT_CREATE_VERIFICATION_DATABASE, element, DatabaseVerificaitonErrors.INSTANCE.cannotCreateConnection(ex), new Object[0]);
                databaseVerifier = null;
            }
            return databaseVerifier;
        }

        private final void unregisterDrivers() {
            try {
                Driver driver = DriverManager.getDriver(DatabaseVerifier.CONNECTION_URL);
                if (driver != null) {
                    Driver driver2;
                    Driver it = driver2 = driver;
                    DriverManager.deregisterDriver(it);
                }
            }
            catch (Throwable t) {
                System.err.println("Room: cannot unregister driver " + t.getMessage());
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

