/*
 * Decompiled with CFR 0.152.
 */
package android.arch.persistence.room.processor;

import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.ext.Element_extKt;
import android.arch.persistence.room.parser.Collate;
import android.arch.persistence.room.parser.SQLTypeAffinity;
import android.arch.persistence.room.preconditions.Checks;
import android.arch.persistence.room.processor.Context;
import android.arch.persistence.room.processor.FieldProcessor$WhenMappings;
import android.arch.persistence.room.processor.ProcessorErrors;
import android.arch.persistence.room.solver.types.ColumnTypeAdapter;
import android.arch.persistence.room.vo.EmbeddedField;
import android.arch.persistence.room.vo.Field;
import com.google.auto.common.AnnotationMirrors;
import com.google.auto.common.MoreElements;
import com.google.common.base.Optional;
import com.squareup.javapoet.TypeName;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u0018\u001a\u00020\u0019R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001b"}, d2={"Landroid/arch/persistence/room/processor/FieldProcessor;", "", "baseContext", "Landroid/arch/persistence/room/processor/Context;", "containing", "Ljavax/lang/model/type/DeclaredType;", "element", "Ljavax/lang/model/element/Element;", "bindingScope", "Landroid/arch/persistence/room/processor/FieldProcessor$BindingScope;", "fieldParent", "Landroid/arch/persistence/room/vo/EmbeddedField;", "(Landroid/arch/persistence/room/processor/Context;Ljavax/lang/model/type/DeclaredType;Ljavax/lang/model/element/Element;Landroid/arch/persistence/room/processor/FieldProcessor$BindingScope;Landroid/arch/persistence/room/vo/EmbeddedField;)V", "getBindingScope", "()Landroid/arch/persistence/room/processor/FieldProcessor$BindingScope;", "getContaining", "()Ljavax/lang/model/type/DeclaredType;", "context", "getContext", "()Landroid/arch/persistence/room/processor/Context;", "getElement", "()Ljavax/lang/model/element/Element;", "getFieldParent", "()Landroid/arch/persistence/room/vo/EmbeddedField;", "process", "Landroid/arch/persistence/room/vo/Field;", "BindingScope", "compiler"})
public final class FieldProcessor {
    @NotNull
    private final Context context;
    @NotNull
    private final DeclaredType containing;
    @NotNull
    private final Element element;
    @NotNull
    private final BindingScope bindingScope;
    @Nullable
    private final EmbeddedField fieldParent;

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final Field process() {
        boolean indexed;
        Collate collate;
        SQLTypeAffinity affinity;
        String columnName;
        TypeMirror member = this.context.getProcessingEnv().getTypeUtils().asMemberOf(this.containing, this.element);
        TypeName type = TypeName.get((TypeMirror)member);
        Optional columnInfoAnnotation = MoreElements.getAnnotationMirror((Element)this.element, ColumnInfo.class);
        String name = this.element.getSimpleName().toString();
        Object object = this.fieldParent;
        if (object == null || (object = ((EmbeddedField)object).getPrefix()) == null) {
            object = "";
        }
        Object fieldPrefix = object;
        Optional optional = columnInfoAnnotation;
        Intrinsics.checkExpressionValueIsNotNull((Object)optional, (String)"columnInfoAnnotation");
        if (optional.isPresent()) {
            SQLTypeAffinity userDefinedAffinity22;
            AnnotationValue annotationValue = AnnotationMirrors.getAnnotationValue((AnnotationMirror)((AnnotationMirror)columnInfoAnnotation.get()), (String)"name");
            Intrinsics.checkExpressionValueIsNotNull((Object)annotationValue, (String)"AnnotationMirrors\n      \u2026Annotation.get(), \"name\")");
            String nameInAnnotation = Element_extKt.getAsString(annotationValue, "[field-name]");
            columnName = (String)fieldPrefix + (Intrinsics.areEqual((Object)nameInAnnotation, (Object)"[field-name]") ? name : nameInAnnotation);
            try {
                AnnotationValue annotationValue2 = AnnotationMirrors.getAnnotationValue((AnnotationMirror)((AnnotationMirror)columnInfoAnnotation.get()), (String)"typeAffinity");
                Intrinsics.checkExpressionValueIsNotNull((Object)annotationValue2, (String)"AnnotationMirrors\n      \u2026on.get(), \"typeAffinity\")");
                Integer n = Element_extKt.getAsInt(annotationValue2, 1);
                if (n == null) {
                    Intrinsics.throwNpe();
                }
                int userDefinedAffinity22 = n;
                userDefinedAffinity22 = SQLTypeAffinity.Companion.fromAnnotationValue(userDefinedAffinity22);
            }
            catch (NumberFormatException ex) {
                userDefinedAffinity22 = null;
            }
            affinity = userDefinedAffinity22;
            AnnotationValue annotationValue3 = AnnotationMirrors.getAnnotationValue((AnnotationMirror)((AnnotationMirror)columnInfoAnnotation.get()), (String)"collate");
            Intrinsics.checkExpressionValueIsNotNull((Object)annotationValue3, (String)"AnnotationMirrors.getAnn\u2026otation.get(), \"collate\")");
            Integer n = Element_extKt.getAsInt(annotationValue3, 1);
            if (n == null) {
                Intrinsics.throwNpe();
            }
            collate = Collate.Companion.fromAnnotationValue(n);
            AnnotationValue annotationValue4 = AnnotationMirrors.getAnnotationValue((AnnotationMirror)((AnnotationMirror)columnInfoAnnotation.get()), (String)"index");
            Intrinsics.checkExpressionValueIsNotNull((Object)annotationValue4, (String)"AnnotationMirrors\n      \u2026nnotation.get(), \"index\")");
            indexed = Element_extKt.getAsBoolean(annotationValue4, false);
        } else {
            columnName = (String)fieldPrefix + name;
            affinity = null;
            collate = null;
            indexed = false;
        }
        this.context.getChecker().notBlank(columnName, this.element, ProcessorErrors.INSTANCE.getCOLUMN_NAME_CANNOT_BE_EMPTY(), new Object[0]);
        Checks checks = this.context.getChecker();
        TypeName typeName2 = type;
        Intrinsics.checkExpressionValueIsNotNull((Object)typeName2, (String)"type");
        checks.notUnbound(typeName2, this.element, ProcessorErrors.INSTANCE.getCANNOT_USE_UNBOUND_GENERICS_IN_ENTITY_FIELDS(), new Object[0]);
        TypeMirror typeMirror = member;
        Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror, (String)"member");
        boolean userDefinedAffinity22 = indexed;
        EmbeddedField embeddedField = this.fieldParent;
        Collate collate2 = collate;
        SQLTypeAffinity sQLTypeAffinity = affinity;
        String string = columnName;
        Element element = this.element;
        TypeMirror typeMirror2 = typeMirror;
        String string2 = name;
        Field field = new Field(element, string2, typeMirror2, sQLTypeAffinity, collate2, string, embeddedField, userDefinedAffinity22);
        switch (FieldProcessor$WhenMappings.$EnumSwitchMapping$0[this.bindingScope.ordinal()]) {
            case 1: {
                ColumnTypeAdapter adapter = this.context.getTypeAdapterStore().findColumnTypeAdapter(field.getType(), field.getAffinity());
                field.setStatementBinder(adapter);
                field.setCursorValueReader(adapter);
                Object object2 = adapter;
                if (object2 == null || (object2 = object2.getTypeAffinity()) == null) {
                    object2 = field.getAffinity();
                }
                field.setAffinity((SQLTypeAffinity)((Object)object2));
                this.context.getChecker().check(adapter != null, field.getElement(), ProcessorErrors.INSTANCE.getCANNOT_FIND_COLUMN_TYPE_ADAPTER(), new Object[0]);
                break;
            }
            case 2: {
                field.setStatementBinder(this.context.getTypeAdapterStore().findStatementValueBinder(field.getType(), field.getAffinity()));
                this.context.getChecker().check(field.getStatementBinder() != null, field.getElement(), ProcessorErrors.INSTANCE.getCANNOT_FIND_STMT_BINDER(), new Object[0]);
                break;
            }
            case 3: {
                field.setCursorValueReader(this.context.getTypeAdapterStore().findCursorValueReader(field.getType(), field.getAffinity()));
                this.context.getChecker().check(field.getCursorValueReader() != null, field.getElement(), ProcessorErrors.INSTANCE.getCANNOT_FIND_CURSOR_READER(), new Object[0]);
            }
        }
        return field;
    }

    @NotNull
    public final DeclaredType getContaining() {
        return this.containing;
    }

    @NotNull
    public final Element getElement() {
        return this.element;
    }

    @NotNull
    public final BindingScope getBindingScope() {
        return this.bindingScope;
    }

    @Nullable
    public final EmbeddedField getFieldParent() {
        return this.fieldParent;
    }

    public FieldProcessor(@NotNull Context baseContext, @NotNull DeclaredType containing, @NotNull Element element, @NotNull BindingScope bindingScope, @Nullable EmbeddedField fieldParent) {
        Intrinsics.checkParameterIsNotNull((Object)baseContext, (String)"baseContext");
        Intrinsics.checkParameterIsNotNull((Object)containing, (String)"containing");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)((Object)bindingScope), (String)"bindingScope");
        this.containing = containing;
        this.element = element;
        this.bindingScope = bindingScope;
        this.fieldParent = fieldParent;
        this.context = baseContext.fork(this.element);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Landroid/arch/persistence/room/processor/FieldProcessor$BindingScope;", "", "(Ljava/lang/String;I)V", "TWO_WAY", "BIND_TO_STMT", "READ_FROM_CURSOR", "compiler"})
    public static final class BindingScope
    extends Enum<BindingScope> {
        public static final /* enum */ BindingScope TWO_WAY;
        public static final /* enum */ BindingScope BIND_TO_STMT;
        public static final /* enum */ BindingScope READ_FROM_CURSOR;
        private static final /* synthetic */ BindingScope[] $VALUES;

        static {
            BindingScope[] bindingScopeArray = new BindingScope[3];
            BindingScope[] bindingScopeArray2 = bindingScopeArray;
            bindingScopeArray[0] = TWO_WAY = new BindingScope();
            bindingScopeArray[1] = BIND_TO_STMT = new BindingScope();
            bindingScopeArray[2] = READ_FROM_CURSOR = new BindingScope();
            $VALUES = bindingScopeArray;
        }

        public static BindingScope[] values() {
            return (BindingScope[])$VALUES.clone();
        }

        public static BindingScope valueOf(String string) {
            return Enum.valueOf(BindingScope.class, string);
        }
    }
}

