/*
 * Decompiled with CFR 0.152.
 */
package android.arch.persistence.room.processor;

import android.arch.persistence.room.Entity;
import android.arch.persistence.room.PrimaryKey;
import android.arch.persistence.room.ext.Element_extKt;
import android.arch.persistence.room.log.RLog;
import android.arch.persistence.room.parser.SQLTypeAffinity;
import android.arch.persistence.room.parser.SqlParser;
import android.arch.persistence.room.preconditions.Checks;
import android.arch.persistence.room.processor.Context;
import android.arch.persistence.room.processor.EntityProcessor;
import android.arch.persistence.room.processor.FieldProcessor;
import android.arch.persistence.room.processor.PojoProcessor;
import android.arch.persistence.room.processor.ProcessorErrors;
import android.arch.persistence.room.processor.cache.Cache;
import android.arch.persistence.room.vo.Constructor;
import android.arch.persistence.room.vo.EmbeddedField;
import android.arch.persistence.room.vo.Field;
import android.arch.persistence.room.vo.ForeignKey;
import android.arch.persistence.room.vo.ForeignKeyAction;
import android.arch.persistence.room.vo.Index;
import android.arch.persistence.room.vo.Pojo;
import android.arch.persistence.room.vo.Warning;
import com.google.auto.common.AnnotationMirrors;
import com.google.auto.common.MoreElements;
import com.google.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor6;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 72\u00020\u0001:\u0003789B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\b\u0002\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t\u00a2\u0006\u0002\u0010\nJ,\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0013H\u0002J\u001e\u0010\u0019\u001a\u00020\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u00132\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u00132\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0013H\u0002J$\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00160\u00132\u0006\u0010\u001b\u001a\u00020\u00052\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u0013H\u0002J\u001c\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00160\u00132\f\u0010#\u001a\b\u0012\u0004\u0012\u00020!0\u0013H\u0002J\b\u0010$\u001a\u00020%H\u0002J$\u0010&\u001a\u00020\u00162\f\u0010#\u001a\b\u0012\u0004\u0012\u00020!0\u00132\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0013H\u0002J(\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u00132\b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\u0006\u0010/\u001a\u00020%J$\u00100\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u00101\u001a\b\u0012\u0004\u0012\u0002020\u00132\u0006\u00103\u001a\u000204H\u0002J$\u00105\u001a\b\u0012\u0004\u0012\u00020\u00180\u00132\f\u00106\u001a\b\u0012\u0004\u0012\u00020(0\u00132\u0006\u00103\u001a\u000204H\u0002R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Landroid/arch/persistence/room/processor/EntityProcessor;", "", "baseContext", "Landroid/arch/persistence/room/processor/Context;", "element", "Ljavax/lang/model/element/TypeElement;", "referenceStack", "Ljava/util/LinkedHashSet;", "Ljavax/lang/model/element/Name;", "Lkotlin/collections/LinkedHashSet;", "(Landroid/arch/persistence/room/processor/Context;Ljavax/lang/model/element/TypeElement;Ljava/util/LinkedHashSet;)V", "context", "getContext", "()Landroid/arch/persistence/room/processor/Context;", "getElement", "()Ljavax/lang/model/element/TypeElement;", "checkIndicesForForeignKeys", "", "entityForeignKeys", "", "Landroid/arch/persistence/room/vo/ForeignKey;", "primaryKey", "Landroid/arch/persistence/room/vo/PrimaryKey;", "indices", "Landroid/arch/persistence/room/vo/Index;", "choosePrimaryKey", "candidates", "typeElement", "collectPrimaryKeysFromEmbeddedFields", "embeddedFields", "Landroid/arch/persistence/room/vo/EmbeddedField;", "collectPrimaryKeysFromEntityAnnotations", "availableFields", "Landroid/arch/persistence/room/vo/Field;", "collectPrimaryKeysFromPrimaryKeyAnnotations", "fields", "doProcess", "Landroid/arch/persistence/room/vo/Entity;", "findAndValidatePrimaryKey", "loadSuperIndices", "Landroid/arch/persistence/room/processor/EntityProcessor$IndexInput;", "typeMirror", "Ljavax/lang/model/type/TypeMirror;", "tableName", "", "inherit", "", "process", "validateAndCreateForeignKeyReferences", "foreignKeyInputs", "Landroid/arch/persistence/room/processor/EntityProcessor$ForeignKeyInput;", "pojo", "Landroid/arch/persistence/room/vo/Pojo;", "validateAndCreateIndices", "inputs", "Companion", "ForeignKeyInput", "IndexInput", "compiler"})
public final class EntityProcessor {
    @NotNull
    private final Context context;
    @NotNull
    private final TypeElement element;
    private final LinkedHashSet<Name> referenceStack;
    private static final Companion.INDEX_LIST_VISITOR.1 INDEX_LIST_VISITOR;
    private static final Companion.INDEX_VISITOR.1 INDEX_VISITOR;
    private static final Companion.FOREIGN_KEY_LIST_VISITOR.1 FOREIGN_KEY_LIST_VISITOR;
    private static final Companion.FOREIGN_KEY_VISITOR.1 FOREIGN_KEY_VISITOR;
    public static final Companion Companion;

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final android.arch.persistence.room.vo.Entity process() {
        return this.context.getCache().getEntities().get(new Cache.EntityKey(this.element), (Function0<android.arch.persistence.room.vo.Entity>)((Function0)new Function0<android.arch.persistence.room.vo.Entity>(this){
            final /* synthetic */ EntityProcessor this$0;

            @NotNull
            public final android.arch.persistence.room.vo.Entity invoke() {
                return EntityProcessor.access$doProcess(this.this$0);
            }
            {
                this.this$0 = entityProcessor;
                super(0);
            }
        }));
    }

    private final android.arch.persistence.room.vo.Entity doProcess() {
        Field it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        List foreignKeyInputs;
        boolean inheritSuperIndices;
        List entityIndices;
        String tableName;
        this.context.getChecker().hasAnnotation(this.element, (KClass<? extends Annotation>)Reflection.getOrCreateKotlinClass(Entity.class), ProcessorErrors.INSTANCE.getENTITY_MUST_BE_ANNOTATED_WITH_ENTITY(), new Object[0]);
        Pojo pojo = new PojoProcessor(this.context, this.element, FieldProcessor.BindingScope.TWO_WAY, null, this.referenceStack).process();
        this.context.getChecker().check(pojo.getRelations().isEmpty(), this.element, ProcessorErrors.INSTANCE.getRELATION_IN_ENTITY(), new Object[0]);
        AnnotationMirror annotation = (AnnotationMirror)MoreElements.getAnnotationMirror((Element)this.element, Entity.class).orNull();
        if (annotation != null) {
            tableName = Companion.extractTableName(this.element, annotation);
            entityIndices = EntityProcessor.Companion.extractIndices(annotation, tableName);
            AnnotationValue annotationValue = AnnotationMirrors.getAnnotationValue((AnnotationMirror)annotation, (String)"inheritSuperIndices");
            Intrinsics.checkExpressionValueIsNotNull((Object)annotationValue, (String)"AnnotationMirrors\n      \u2026n, \"inheritSuperIndices\")");
            inheritSuperIndices = Element_extKt.getAsBoolean(annotationValue, false);
            foreignKeyInputs = EntityProcessor.Companion.extractForeignKeys(annotation);
        } else {
            tableName = this.element.getSimpleName().toString();
            foreignKeyInputs = CollectionsKt.emptyList();
            entityIndices = CollectionsKt.emptyList();
            inheritSuperIndices = false;
        }
        this.context.getChecker().notBlank(tableName, this.element, ProcessorErrors.INSTANCE.getENTITY_TABLE_NAME_CANNOT_BE_EMPTY(), new Object[0]);
        Iterable iterable = pojo.getFields();
        void var9_8 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (Field)element$iv$iv;
            if (!it.getIndexed()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            IndexInput indexInput;
            it = (Field)item$iv$iv;
            Collection collection = destination$iv$iv;
            if (it.getParent() != null) {
                it.setIndexed(false);
                this.context.getLogger().w(Warning.INDEX_FROM_EMBEDDED_FIELD_IS_DROPPED, it.getElement(), ProcessorErrors.INSTANCE.droppedEmbeddedFieldIndex(it.getPath(), this.element.getQualifiedName().toString()), new Object[0]);
                indexInput = null;
            } else if (Intrinsics.areEqual((Object)it.getElement().getEnclosingElement(), (Object)this.element) ^ true && !inheritSuperIndices) {
                it.setIndexed(false);
                this.context.getLogger().w(Warning.INDEX_FROM_PARENT_FIELD_IS_DROPPED, ProcessorErrors.INSTANCE.droppedSuperClassFieldIndex(it.getColumnName(), this.element.toString(), it.getElement().getEnclosingElement().toString()), new Object[0]);
                indexInput = null;
            } else {
                indexInput = new IndexInput(EntityProcessor.Companion.createIndexName(CollectionsKt.listOf((Object)it.getColumnName()), tableName), false, CollectionsKt.listOf((Object)it.getColumnName()));
            }
            IndexInput indexInput2 = indexInput;
            collection.add(indexInput2);
        }
        List fieldIndices = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
        List<IndexInput> superIndices = this.loadSuperIndices(this.element.getSuperclass(), tableName, inheritSuperIndices);
        List indexInputs = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)entityIndices, (Iterable)fieldIndices), (Iterable)superIndices);
        List<Index> indices = this.validateAndCreateIndices(indexInputs, pojo);
        android.arch.persistence.room.vo.PrimaryKey primaryKey = this.findAndValidatePrimaryKey(pojo.getFields(), pojo.getEmbeddedFields());
        Object object = (Field)CollectionsKt.firstOrNull(primaryKey.getFields());
        if (object == null || (object = object.getAffinity()) == null) {
            object = SQLTypeAffinity.TEXT;
        }
        Object affinity = object;
        Checks checks = this.context.getChecker();
        boolean bl = !primaryKey.getAutoGenerateId() || affinity == SQLTypeAffinity.INTEGER;
        Object object2 = (Field)CollectionsKt.firstOrNull(primaryKey.getFields());
        if (object2 == null || (object2 = ((Field)object2).getElement()) == null) {
            object2 = this.element;
        }
        checks.check(bl, (Element)object2, ProcessorErrors.INSTANCE.getAUTO_INCREMENTED_PRIMARY_KEY_IS_NOT_INT(), new Object[0]);
        List<ForeignKey> entityForeignKeys = this.validateAndCreateForeignKeyReferences(foreignKeyInputs, pojo);
        this.checkIndicesForForeignKeys(entityForeignKeys, primaryKey, indices);
        this.context.getChecker().check(SqlParser.Companion.isValidIdentifier(tableName), this.element, ProcessorErrors.INSTANCE.getINVALID_TABLE_NAME(), new Object[0]);
        Iterable $receiver$iv2 = pojo.getFields();
        for (Object element$iv : $receiver$iv2) {
            Field it2 = (Field)element$iv;
            this.context.getChecker().check(SqlParser.Companion.isValidIdentifier(it2.getColumnName()), it2.getElement(), ProcessorErrors.INSTANCE.getINVALID_COLUMN_NAME(), new Object[0]);
        }
        Constructor constructor = pojo.getConstructor();
        List<ForeignKey> list = entityForeignKeys;
        android.arch.persistence.room.vo.PrimaryKey primaryKey2 = primaryKey;
        List<Index> list2 = indices;
        android.arch.persistence.room.vo.Entity entity = new android.arch.persistence.room.vo.Entity(this.element, tableName, pojo.getType(), pojo.getFields(), pojo.getEmbeddedFields(), primaryKey2, list2, list, constructor);
        return entity;
    }

    /*
     * Unable to fully structure code
     */
    private final void checkIndicesForForeignKeys(List<ForeignKey> entityForeignKeys, android.arch.persistence.room.vo.PrimaryKey primaryKey, List<Index> indices) {
        covers$ = checkIndicesForForeignKeys.1.INSTANCE;
        $receiver$iv = entityForeignKeys;
        for (T element$iv : $receiver$iv) {
            block8: {
                fKey = (ForeignKey)element$iv;
                var10_11 = $receiver$iv = (Iterable)fKey.getChildFields();
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    var14_15 = (Field)item$iv$iv;
                    var15_16 = destination$iv$iv;
                    var16_17 = it.getColumnName();
                    var15_16.add(var16_17);
                }
                columnNames = (List)destination$iv$iv;
                if (checkIndicesForForeignKeys.1.INSTANCE.invoke(columnNames, primaryKey.getFields())) ** GOTO lbl-1000
                $receiver$iv = indices;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (T element$iv : $receiver$iv) {
                        index = (Index)element$iv;
                        if (!checkIndicesForForeignKeys.1.INSTANCE.invoke(columnNames, index.getFields())) continue;
                        v0 = true;
                        break block8;
                    }
                    v0 = false;
                }
            }
            if (v0) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = false;
            }
            if (exists = v1) continue;
            if (columnNames.size() == 1) {
                this.context.getLogger().w(Warning.MISSING_INDEX_ON_FOREIGN_KEY_CHILD, this.element, ProcessorErrors.INSTANCE.foreignKeyMissingIndexInChildColumn((String)columnNames.get(0)), new Object[0]);
                continue;
            }
            this.context.getLogger().w(Warning.MISSING_INDEX_ON_FOREIGN_KEY_CHILD, this.element, ProcessorErrors.INSTANCE.foreignKeyMissingIndexInChildColumns(columnNames), new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<ForeignKey> validateAndCreateForeignKeyReferences(List<ForeignKeyInput> foreignKeyInputs, Pojo pojo) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)foreignKeyInputs;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            ForeignKey foreignKey;
            Collection collection;
            block22: {
                void it;
                ForeignKeyInput foreignKeyInput = (ForeignKeyInput)item$iv$iv;
                collection = destination$iv$iv;
                if (it.getOnUpdate() == null) {
                    this.context.getLogger().e(this.element, ProcessorErrors.INSTANCE.getINVALID_FOREIGN_KEY_ACTION(), new Object[0]);
                    foreignKey = null;
                } else if (it.getOnDelete() == null) {
                    this.context.getLogger().e(this.element, ProcessorErrors.INSTANCE.getINVALID_FOREIGN_KEY_ACTION(), new Object[0]);
                    foreignKey = null;
                } else if (it.getChildColumns().isEmpty()) {
                    this.context.getLogger().e(this.element, ProcessorErrors.INSTANCE.getFOREIGN_KEY_EMPTY_CHILD_COLUMN_LIST(), new Object[0]);
                    foreignKey = null;
                } else if (it.getParentColumns().isEmpty()) {
                    this.context.getLogger().e(this.element, ProcessorErrors.INSTANCE.getFOREIGN_KEY_EMPTY_PARENT_COLUMN_LIST(), new Object[0]);
                    foreignKey = null;
                } else if (it.getChildColumns().size() != it.getParentColumns().size()) {
                    this.context.getLogger().e(this.element, ProcessorErrors.INSTANCE.foreignKeyColumnNumberMismatch(it.getChildColumns(), it.getParentColumns()), new Object[0]);
                    foreignKey = null;
                } else {
                    TypeElement typeElement;
                    try {
                        Element element = MoreTypes.asElement((TypeMirror)it.getParent());
                        if (element == null) {
                            throw new TypeCastException("null cannot be cast to non-null type javax.lang.model.element.TypeElement");
                        }
                        typeElement = (TypeElement)element;
                    }
                    catch (IllegalArgumentException noClass) {
                        this.context.getLogger().e(this.element, ProcessorErrors.INSTANCE.getFOREIGN_KEY_CANNOT_FIND_PARENT(), new Object[0]);
                        foreignKey = null;
                        break block22;
                    }
                    TypeElement parentElement = typeElement;
                    AnnotationMirror parentAnnotation = (AnnotationMirror)MoreElements.getAnnotationMirror((Element)parentElement, Entity.class).orNull();
                    if (parentAnnotation == null) {
                        this.context.getLogger().e(this.element, ProcessorErrors.INSTANCE.foreignKeyNotAnEntity(parentElement.toString()), new Object[0]);
                        foreignKey = null;
                    } else {
                        void $receiver$iv$iv2;
                        Iterable $receiver$iv2;
                        String tableName = Companion.extractTableName(parentElement, parentAnnotation);
                        Object object = $receiver$iv2 = (Iterable)it.getChildColumns();
                        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                        for (Object item$iv$iv2 : $receiver$iv$iv2) {
                            Object v2;
                            void columnName;
                            Iterable iterable2;
                            Iterable iterable3;
                            Collection collection2;
                            block23: {
                                String string = (String)item$iv$iv2;
                                collection2 = destination$iv$iv2;
                                iterable2 = iterable3 = (Iterable)pojo.getFields();
                                for (Object object2 : iterable2) {
                                    Field it2 = (Field)object2;
                                    if (!Intrinsics.areEqual((Object)it2.getColumnName(), (Object)columnName)) continue;
                                    v2 = object2;
                                    break block23;
                                }
                                v2 = null;
                            }
                            Field field = v2;
                            if (field == null) {
                                Collection<String> collection3;
                                void $receiver$iv$iv3;
                                void $receiver$iv3;
                                Object object2;
                                iterable3 = pojo.getFields();
                                void var25_27 = columnName;
                                ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
                                Element element = pojo.getElement();
                                RLog rLog = this.context.getLogger();
                                iterable2 = $receiver$iv3;
                                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
                                object2 = $receiver$iv$iv3.iterator();
                                while (object2.hasNext()) {
                                    void it3;
                                    Object item$iv$iv3 = object2.next();
                                    Field $i$a$1$find = (Field)item$iv$iv3;
                                    collection3 = destination$iv$iv3;
                                    String string = it3.getColumnName();
                                    collection3.add(string);
                                }
                                collection3 = (List)destination$iv$iv3;
                                rLog.e(element, processorErrors.foreignKeyChildColumnDoesNotExist((String)var25_27, (List<String>)collection3), new Object[0]);
                            }
                            Field field2 = field;
                            collection2.add(field2);
                        }
                        List fields = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv2));
                        if (fields.size() != it.getChildColumns().size()) {
                            foreignKey = null;
                        } else {
                            boolean bl = it.getDeferred();
                            object = it.getOnUpdate();
                            ForeignKeyAction foreignKeyAction = it.getOnDelete();
                            List<String> list = it.getParentColumns();
                            List list2 = fields;
                            ForeignKey foreignKey2 = new ForeignKey(tableName, list, list2, foreignKeyAction, (ForeignKeyAction)((Object)object), bl);
                            foreignKey = foreignKey2;
                        }
                    }
                }
            }
            ForeignKey foreignKey3 = foreignKey;
            collection.add(foreignKey3);
        }
        return CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final android.arch.persistence.room.vo.PrimaryKey findAndValidatePrimaryKey(List<Field> fields, List<EmbeddedField> embeddedFields) {
        android.arch.persistence.room.vo.PrimaryKey candidate;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        List candidates = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.collectPrimaryKeysFromEntityAnnotations(this.element, fields), (Iterable)this.collectPrimaryKeysFromPrimaryKeyAnnotations(fields)), (Iterable)this.collectPrimaryKeysFromEmbeddedFields(embeddedFields));
        Collection collection = candidates;
        Object object = this.context.getChecker();
        boolean bl = !collection.isEmpty();
        ((Checks)object).check(bl, this.element, ProcessorErrors.INSTANCE.getMISSING_PRIMARY_KEY(), new Object[0]);
        Iterable iterable = $receiver$iv = (Iterable)candidates;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            candidate = (android.arch.persistence.room.vo.PrimaryKey)element$iv$iv;
            if (!(!candidate.getAutoGenerateId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void $receiver$iv$iv2;
            Iterable $receiver$iv2;
            candidate = (android.arch.persistence.room.vo.PrimaryKey)item$iv$iv;
            object = destination$iv$iv;
            Iterable $i$f$filterTo = $receiver$iv2 = (Iterable)candidate.getFields();
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv2 : $receiver$iv$iv2) {
                void field;
                Field field2 = (Field)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                if (candidate.getFields().size() > 1 || candidate.getFields().size() == 1 && field.getAffinity() != SQLTypeAffinity.INTEGER) {
                    this.context.getChecker().check(field.getNonNull(), field.getElement(), ProcessorErrors.INSTANCE.primaryKeyNull(field.getPath()), new Object[0]);
                    EmbeddedField parent = field.getParent();
                    while (parent != null) {
                        Field parentField = parent.getField();
                        this.context.getChecker().check(parentField.getNonNull(), parentField.getElement(), ProcessorErrors.INSTANCE.primaryKeyNull(parentField.getPath()), new Object[0]);
                        parent = parentField.getParent();
                    }
                }
                Unit unit = Unit.INSTANCE;
                collection2.add(unit);
            }
            List list = (List)destination$iv$iv2;
            object.add(list);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        if (candidates.size() == 1) {
            return (android.arch.persistence.room.vo.PrimaryKey)CollectionsKt.first((List)candidates);
        }
        return this.choosePrimaryKey(candidates, this.element);
    }

    /*
     * WARNING - void declaration
     */
    private final List<android.arch.persistence.room.vo.PrimaryKey> collectPrimaryKeysFromPrimaryKeyAnnotations(List<Field> fields) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)fields;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            android.arch.persistence.room.vo.PrimaryKey primaryKey;
            void field;
            Field field2 = (Field)item$iv$iv;
            Collection collection = destination$iv$iv;
            if ((AnnotationMirror)MoreElements.getAnnotationMirror((Element)field.getElement(), PrimaryKey.class).orNull() != null) {
                AnnotationMirror annotationMirror;
                AnnotationMirror it = annotationMirror;
                if (field.getParent() != null) {
                    Element grandParentField = field.getParent().getMRootParent().getField().getElement();
                    this.context.fork(grandParentField).getLogger().w(Warning.PRIMARY_KEY_FROM_EMBEDDED_IS_DROPPED, grandParentField, ProcessorErrors.INSTANCE.embeddedPrimaryKeyIsDropped(this.element.getQualifiedName().toString(), field.getName()), new Object[0]);
                    primaryKey = null;
                } else {
                    Element element = field.getElement().getEnclosingElement();
                    List list = CollectionsKt.listOf((Object)field);
                    AnnotationValue annotationValue = AnnotationMirrors.getAnnotationValue((AnnotationMirror)it, (String)"autoGenerate");
                    Intrinsics.checkExpressionValueIsNotNull((Object)annotationValue, (String)"AnnotationMirrors\n      \u2026Value(it, \"autoGenerate\")");
                    primaryKey = new android.arch.persistence.room.vo.PrimaryKey(element, list, Element_extKt.getAsBoolean(annotationValue, false));
                }
            } else {
                primaryKey = null;
            }
            android.arch.persistence.room.vo.PrimaryKey primaryKey2 = primaryKey;
            collection.add(primaryKey2);
        }
        return CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final List<android.arch.persistence.room.vo.PrimaryKey> collectPrimaryKeysFromEntityAnnotations(TypeElement typeElement, List<Field> availableFields) {
        List<android.arch.persistence.room.vo.PrimaryKey> list;
        Iterable $receiver$iv$iv;
        Collection destination$iv$iv;
        Iterable $receiver$iv;
        Object object;
        block14: {
            block13: {
                List list2;
                AnnotationMirror annotationMirror;
                object = (AnnotationMirror)MoreElements.getAnnotationMirror((Element)typeElement, Entity.class).orNull();
                if (object == null) break block13;
                AnnotationMirror it = annotationMirror = object;
                AnnotationValue annotationValue = AnnotationMirrors.getAnnotationValue((AnnotationMirror)it, (String)"primaryKeys");
                Intrinsics.checkExpressionValueIsNotNull((Object)annotationValue, (String)"AnnotationMirrors.getAnn\u2026nValue(it, \"primaryKeys\")");
                List<String> primaryKeyColumns = Element_extKt.getAsStringList(annotationValue);
                if (primaryKeyColumns.isEmpty()) {
                    list2 = CollectionsKt.emptyList();
                } else {
                    Iterable iterable = $receiver$iv = (Iterable)primaryKeyColumns;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (Object item$iv$iv : $receiver$iv$iv) {
                        Collection<String> collection;
                        void $receiver$iv$iv2;
                        Object v3;
                        void pKeyColumnName;
                        Iterable $receiver$iv2;
                        Collection collection2;
                        block12: {
                            String string = (String)item$iv$iv;
                            collection2 = destination$iv$iv;
                            $receiver$iv2 = availableFields;
                            for (Object element$iv : $receiver$iv2) {
                                Field it2 = (Field)element$iv;
                                if (!Intrinsics.areEqual((Object)it2.getColumnName(), (Object)pKeyColumnName)) continue;
                                v3 = element$iv;
                                break block12;
                            }
                            v3 = null;
                        }
                        Field field = v3;
                        $receiver$iv2 = availableFields;
                        void var19_18 = pKeyColumnName;
                        ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
                        Element element = typeElement;
                        boolean bl = field != null;
                        Checks checks = this.context.getChecker();
                        Iterable iterable2 = $receiver$iv2;
                        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                        for (Object item$iv$iv2 : $receiver$iv$iv2) {
                            void it3;
                            Field $i$f$firstOrNull = (Field)item$iv$iv2;
                            collection = destination$iv$iv2;
                            String string = it3.getColumnName();
                            collection.add(string);
                        }
                        collection = (List)destination$iv$iv2;
                        checks.check(bl, element, processorErrors.primaryKeyColumnDoesNotExist((String)var19_18, (List<String>)collection), new Object[0]);
                        Field field2 = field;
                        collection2.add(field2);
                    }
                    List fields = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
                    list2 = CollectionsKt.listOf((Object)new android.arch.persistence.room.vo.PrimaryKey(typeElement, fields, false));
                }
                object = list2;
                if (list2 != null) break block14;
            }
            object = CollectionsKt.emptyList();
        }
        Object myPkeys = object;
        TypeMirror mySuper = typeElement.getSuperclass();
        if (mySuper != null && mySuper.getKind() != TypeKind.NONE) {
            $receiver$iv$iv = $receiver$iv = (Iterable)availableFields;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                Field it = (Field)element$iv$iv;
                if (Intrinsics.areEqual((Object)it.getElement().getEnclosingElement(), (Object)typeElement)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List remainingFields = (List)destination$iv$iv;
            TypeElement typeElement2 = MoreTypes.asTypeElement((TypeMirror)mySuper);
            Intrinsics.checkExpressionValueIsNotNull((Object)typeElement2, (String)"MoreTypes.asTypeElement(mySuper)");
            list = this.collectPrimaryKeysFromEntityAnnotations(typeElement2, remainingFields);
        } else {
            list = CollectionsKt.emptyList();
        }
        List<android.arch.persistence.room.vo.PrimaryKey> superPKeys = list;
        return CollectionsKt.plus((Collection)superPKeys, (Iterable)((Iterable)myPkeys));
    }

    /*
     * WARNING - void declaration
     */
    private final List<android.arch.persistence.room.vo.PrimaryKey> collectPrimaryKeysFromEmbeddedFields(List<EmbeddedField> embeddedFields) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)embeddedFields;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            android.arch.persistence.room.vo.PrimaryKey primaryKey;
            void embeddedField;
            EmbeddedField embeddedField2 = (EmbeddedField)item$iv$iv;
            Collection collection = destination$iv$iv;
            if ((AnnotationMirror)MoreElements.getAnnotationMirror((Element)embeddedField.getField().getElement(), PrimaryKey.class).orNull() != null) {
                AnnotationMirror annotationMirror;
                AnnotationMirror it = annotationMirror;
                AnnotationValue annotationValue = AnnotationMirrors.getAnnotationValue((AnnotationMirror)it, (String)"autoGenerate");
                Intrinsics.checkExpressionValueIsNotNull((Object)annotationValue, (String)"AnnotationMirrors\n      \u2026Value(it, \"autoGenerate\")");
                boolean autoGenerate = Element_extKt.getAsBoolean(annotationValue, false);
                this.context.getChecker().check(!autoGenerate || embeddedField.getPojo().getFields().size() == 1, embeddedField.getField().getElement(), ProcessorErrors.INSTANCE.getAUTO_INCREMENT_EMBEDDED_HAS_MULTIPLE_FIELDS(), new Object[0]);
                primaryKey = new android.arch.persistence.room.vo.PrimaryKey(embeddedField.getField().getElement().getEnclosingElement(), embeddedField.getPojo().getFields(), autoGenerate);
            } else {
                primaryKey = null;
            }
            android.arch.persistence.room.vo.PrimaryKey primaryKey2 = primaryKey;
            collection.add(primaryKey2);
        }
        return CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final android.arch.persistence.room.vo.PrimaryKey choosePrimaryKey(List<android.arch.persistence.room.vo.PrimaryKey> candidates, TypeElement typeElement) {
        Object mySuper;
        android.arch.persistence.room.vo.PrimaryKey primaryKey;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)candidates;
        Collection destination$iv$iv = new ArrayList();
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            android.arch.persistence.room.vo.PrimaryKey candidate = (android.arch.persistence.room.vo.PrimaryKey)element$iv$iv;
            if (!Intrinsics.areEqual((Object)candidate.getDeclaredIn(), (Object)typeElement)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List myPKeys = (List)destination$iv$iv;
        if (myPKeys.size() == 1) {
            $receiver$iv = CollectionsKt.minus((Iterable)candidates, (Iterable)myPKeys);
            for (Object element$iv : $receiver$iv) {
                android.arch.persistence.room.vo.PrimaryKey it = (android.arch.persistence.room.vo.PrimaryKey)element$iv;
                this.context.getLogger().d(this.element, "" + it.toHumanReadableString() + " is" + " overridden by " + ((android.arch.persistence.room.vo.PrimaryKey)CollectionsKt.first((List)myPKeys)).toHumanReadableString(), new Object[0]);
            }
            primaryKey = (android.arch.persistence.room.vo.PrimaryKey)CollectionsKt.first((List)myPKeys);
        } else if (myPKeys.isEmpty()) {
            mySuper = typeElement.getSuperclass();
            if (mySuper != null && mySuper.getKind() != TypeKind.NONE) {
                TypeElement typeElement2 = MoreTypes.asTypeElement((TypeMirror)mySuper);
                Intrinsics.checkExpressionValueIsNotNull((Object)typeElement2, (String)"MoreTypes.asTypeElement(mySuper)");
                return this.choosePrimaryKey(candidates, typeElement2);
            }
            primaryKey = android.arch.persistence.room.vo.PrimaryKey.Companion.getMISSING();
        } else {
            Collection<String> collection;
            mySuper = myPKeys;
            ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
            Element element = this.element;
            RLog rLog = this.context.getLogger();
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                void p1;
                Object item$iv$iv = iterator.next();
                android.arch.persistence.room.vo.PrimaryKey $i$f$forEach = (android.arch.persistence.room.vo.PrimaryKey)item$iv$iv;
                collection = destination$iv$iv;
                String string = p1.toHumanReadableString();
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            rLog.e(element, processorErrors.multiplePrimaryKeyAnnotations((List<String>)collection), new Object[0]);
            primaryKey = android.arch.persistence.room.vo.PrimaryKey.Companion.getMISSING();
        }
        return primaryKey;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Index> validateAndCreateIndices(List<IndexInput> inputs, Pojo pojo) {
        Collection collection;
        Object $receiver$iv$iv;
        Object $receiver$iv = inputs;
        Iterator iterator = $receiver$iv;
        Iterator destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Object object = $receiver$iv$iv.iterator();
        while (object.hasNext()) {
            void $receiver$iv$iv2;
            Iterable $receiver$iv2;
            Object item$iv$iv = object.next();
            IndexInput indexInput = (IndexInput)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            collection = indexInput.getColumnNames();
            Object object2 = this.context.getChecker();
            boolean bl = !collection.isEmpty();
            ((Checks)object2).check(bl, this.element, ProcessorErrors.INSTANCE.getINDEX_COLUMNS_CANNOT_BE_EMPTY(), new Object[0]);
            Iterable iterable = $receiver$iv2 = (Iterable)indexInput.getColumnNames();
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv2 : $receiver$iv$iv2) {
                Collection<String> collection3;
                void $receiver$iv$iv3;
                void $receiver$iv3;
                Object v0;
                void columnName;
                Iterable $receiver$iv32;
                block10: {
                    String string = (String)item$iv$iv2;
                    object2 = destination$iv$iv2;
                    $receiver$iv32 = pojo.getFields();
                    for (Object element$iv : $receiver$iv32) {
                        Field it = (Field)element$iv;
                        if (!Intrinsics.areEqual((Object)it.getColumnName(), (Object)columnName)) continue;
                        v0 = element$iv;
                        break block10;
                    }
                    v0 = null;
                }
                Field field = v0;
                $receiver$iv32 = pojo.getFields();
                void var24_32 = columnName;
                ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
                Element element = this.element;
                boolean bl2 = field != null;
                Checks checks = this.context.getChecker();
                Iterator iterator2 = $receiver$iv3;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
                for (Object item$iv$iv3 : $receiver$iv$iv3) {
                    void it;
                    Field $i$f$firstOrNull = (Field)item$iv$iv3;
                    collection3 = destination$iv$iv3;
                    String string = it.getColumnName();
                    collection3.add(string);
                }
                collection3 = (List)destination$iv$iv3;
                checks.check(bl2, element, processorErrors.indexColumnDoesNotExist((String)var24_32, (List<String>)collection3), new Object[0]);
                Field field2 = field;
                object2.add(field2);
            }
            List fields = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv2));
            Index index = fields.isEmpty() ? null : new Index(indexInput.getName(), indexInput.getUnique(), fields);
            collection2.add(index);
        }
        List indices = CollectionsKt.filterNotNull((Iterable)((List)((Object)destination$iv$iv)));
        $receiver$iv = indices;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new LinkedHashMap();
        object = $receiver$iv$iv.iterator();
        while (object.hasNext()) {
            Object object3;
            Iterator $receiver$iv$iv$iv = destination$iv$iv;
            Object element$iv$iv = object.next();
            Index index = (Index)element$iv$iv;
            String key$iv$iv = index.getName();
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object3 = answer$iv$iv$iv;
            } else {
                object3 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object3;
            list$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new LinkedHashMap();
        object = $receiver$iv$iv;
        for (Map.Entry entry : object.entrySet()) {
            Map.Entry it = entry;
            if (!(((List)it.getValue()).size() > 1)) continue;
            destination$iv$iv.put(entry.getKey(), entry.getValue());
        }
        $receiver$iv = destination$iv$iv;
        iterator = $receiver$iv;
        destination$iv$iv = iterator.entrySet().iterator();
        while (destination$iv$iv.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = destination$iv$iv.next();
            this.context.getLogger().e(this.element, ProcessorErrors.INSTANCE.duplicateIndexInEntity((String)it.getKey()), new Object[0]);
        }
        $receiver$iv = pojo.getEmbeddedFields();
        iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            EmbeddedField embedded = (EmbeddedField)element$iv;
            TypeElement embeddedElement = embedded.getPojo().getElement();
            AnnotationMirror annotationMirror = (AnnotationMirror)MoreElements.getAnnotationMirror((Element)embeddedElement, Entity.class).orNull();
            if (annotationMirror == null) continue;
            Collection it = collection;
            List subIndices = EntityProcessor.Companion.extractIndices(annotationMirror, "");
            Collection collection4 = subIndices;
            if (!(!collection4.isEmpty())) continue;
            RLog rLog = this.context.getLogger();
            Element element = embedded.getField().getElement();
            String string = embedded.getPojo().getTypeName().toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"embedded.pojo.typeName.toString()");
            rLog.w(Warning.INDEX_FROM_EMBEDDED_ENTITY_IS_DROPPED, element, ProcessorErrors.INSTANCE.droppedEmbeddedIndex(string, embedded.getField().getPath(), this.element.getQualifiedName().toString()), new Object[0]);
        }
        return indices;
    }

    /*
     * WARNING - void declaration
     */
    private final List<IndexInput> loadSuperIndices(TypeMirror typeMirror, String tableName, boolean inherit) {
        Object object;
        TypeElement parentElement;
        block10: {
            block9: {
                List list;
                AnnotationMirror annotationMirror;
                AnnotationMirror annotation;
                if (typeMirror == null || typeMirror.getKind() == TypeKind.NONE) {
                    return CollectionsKt.emptyList();
                }
                parentElement = MoreTypes.asTypeElement((TypeMirror)typeMirror);
                object = (AnnotationMirror)MoreElements.getAnnotationMirror((Element)parentElement, Entity.class).orNull();
                if (object == null) break block9;
                AnnotationMirror annotationMirror2 = annotation = (annotationMirror = object);
                Intrinsics.checkExpressionValueIsNotNull((Object)annotationMirror2, (String)"annotation");
                List indices = EntityProcessor.Companion.extractIndices(annotationMirror2, "super");
                if (indices.isEmpty()) {
                    list = CollectionsKt.emptyList();
                } else if (inherit) {
                    void $receiver$iv$iv;
                    Iterable $receiver$iv;
                    Iterable iterable = $receiver$iv = (Iterable)indices;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (Object item$iv$iv : $receiver$iv$iv) {
                        void it;
                        IndexInput indexInput = (IndexInput)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        IndexInput indexInput2 = new IndexInput(EntityProcessor.Companion.createIndexName(it.getColumnNames(), tableName), it.getUnique(), it.getColumnNames());
                        collection.add(indexInput2);
                    }
                    list = (List)destination$iv$iv;
                } else {
                    RLog rLog = this.context.getLogger();
                    Element element = parentElement;
                    String string = this.element.getQualifiedName().toString();
                    TypeElement typeElement = parentElement;
                    Intrinsics.checkExpressionValueIsNotNull((Object)typeElement, (String)"parentElement");
                    rLog.w(Warning.INDEX_FROM_PARENT_IS_DROPPED, element, ProcessorErrors.INSTANCE.droppedSuperClassIndex(string, typeElement.getQualifiedName().toString()), new Object[0]);
                    list = CollectionsKt.emptyList();
                }
                object = list;
                if (list != null) break block10;
            }
            object = CollectionsKt.emptyList();
        }
        Object myIndices = object;
        Collection collection = (Collection)myIndices;
        TypeElement typeElement = parentElement;
        Intrinsics.checkExpressionValueIsNotNull((Object)typeElement, (String)"parentElement");
        return CollectionsKt.plus((Collection)collection, (Iterable)this.loadSuperIndices(typeElement.getSuperclass(), tableName, inherit));
    }

    @NotNull
    public final TypeElement getElement() {
        return this.element;
    }

    public EntityProcessor(@NotNull Context baseContext, @NotNull TypeElement element, @NotNull LinkedHashSet<Name> referenceStack) {
        Intrinsics.checkParameterIsNotNull((Object)baseContext, (String)"baseContext");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull(referenceStack, (String)"referenceStack");
        this.element = element;
        this.referenceStack = referenceStack;
        this.context = baseContext.fork(this.element);
    }

    public /* synthetic */ EntityProcessor(Context context, TypeElement typeElement, LinkedHashSet linkedHashSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            linkedHashSet = new LinkedHashSet<Name>();
        }
        this(context, typeElement, linkedHashSet);
    }

    static {
        Companion = new Companion(null);
        INDEX_LIST_VISITOR = new SimpleAnnotationValueVisitor6<List<? extends IndexInput>, String>(){

            /*
             * WARNING - void declaration
             */
            @NotNull
            public List<IndexInput> visitArray(@Nullable List<? extends AnnotationValue> values, @NotNull String tableName) {
                List list;
                block4: {
                    block3: {
                        void $receiver$iv$iv;
                        Intrinsics.checkParameterIsNotNull((Object)tableName, (String)"tableName");
                        list = values;
                        if (list == null) break block3;
                        Iterable $receiver$iv = list;
                        Iterable iterable = $receiver$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                        for (T item$iv$iv : $receiver$iv$iv) {
                            void it;
                            AnnotationValue annotationValue = (AnnotationValue)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            IndexInput indexInput = (IndexInput)EntityProcessor.access$getINDEX_VISITOR$cp().visit((AnnotationValue)it, tableName);
                            collection.add(indexInput);
                        }
                        list = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
                        if (list != null) break block4;
                    }
                    list = CollectionsKt.emptyList();
                }
                return list;
            }
        };
        INDEX_VISITOR = new SimpleAnnotationValueVisitor6<IndexInput, String>(){

            @Nullable
            public IndexInput visitAnnotation(@Nullable AnnotationMirror a, @NotNull String tableName) {
                Intrinsics.checkParameterIsNotNull((Object)tableName, (String)"tableName");
                AnnotationValue annotationValue = AnnotationMirrors.getAnnotationValue((AnnotationMirror)a, (String)"value");
                Intrinsics.checkExpressionValueIsNotNull((Object)annotationValue, (String)"getAnnotationValue(a, \"value\")");
                List<String> fieldInput = Element_extKt.getAsStringList(annotationValue);
                AnnotationValue annotationValue2 = AnnotationMirrors.getAnnotationValue((AnnotationMirror)a, (String)"unique");
                Intrinsics.checkExpressionValueIsNotNull((Object)annotationValue2, (String)"getAnnotationValue(a, \"unique\")");
                boolean unique = Element_extKt.getAsBoolean(annotationValue2, false);
                AnnotationValue annotationValue3 = AnnotationMirrors.getAnnotationValue((AnnotationMirror)a, (String)"name");
                Intrinsics.checkExpressionValueIsNotNull((Object)annotationValue3, (String)"getAnnotationValue(a, \"name\")");
                String nameValue = Element_extKt.getAsString(annotationValue3, "");
                String name = nameValue == null || Intrinsics.areEqual((Object)nameValue, (Object)"") ? android.arch.persistence.room.processor.EntityProcessor$Companion.access$createIndexName(EntityProcessor.Companion, fieldInput, tableName) : nameValue;
                return new IndexInput(name, unique, fieldInput);
            }
        };
        FOREIGN_KEY_LIST_VISITOR = new SimpleAnnotationValueVisitor6<List<? extends ForeignKeyInput>, Void>(){

            /*
             * WARNING - void declaration
             */
            @NotNull
            public List<ForeignKeyInput> visitArray(@Nullable List<? extends AnnotationValue> values, @Nullable Void void_) {
                List list;
                block4: {
                    block3: {
                        void $receiver$iv$iv;
                        list = values;
                        if (list == null) break block3;
                        Iterable $receiver$iv = list;
                        Iterable iterable = $receiver$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                        for (T item$iv$iv : $receiver$iv$iv) {
                            void it;
                            AnnotationValue annotationValue = (AnnotationValue)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            ForeignKeyInput foreignKeyInput = (ForeignKeyInput)EntityProcessor.access$getFOREIGN_KEY_VISITOR$cp().visit((AnnotationValue)it);
                            collection.add(foreignKeyInput);
                        }
                        list = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
                        if (list != null) break block4;
                    }
                    list = CollectionsKt.emptyList();
                }
                return list;
            }
        };
        FOREIGN_KEY_VISITOR = new SimpleAnnotationValueVisitor6<ForeignKeyInput, Void>(){

            @Nullable
            public ForeignKeyInput visitAnnotation(@Nullable AnnotationMirror a, @Nullable Void void_) {
                TypeMirror typeMirror;
                try {
                    AnnotationValue annotationValue = AnnotationMirrors.getAnnotationValue((AnnotationMirror)a, (String)"entity");
                    Intrinsics.checkExpressionValueIsNotNull((Object)annotationValue, (String)"getAnnotationValue(a, \"entity\")");
                    typeMirror = Element_extKt.toType(annotationValue);
                }
                catch (TypeNotPresentException notPresent) {
                    return null;
                }
                TypeMirror entityClass = typeMirror;
                AnnotationValue annotationValue = AnnotationMirrors.getAnnotationValue((AnnotationMirror)a, (String)"parentColumns");
                Intrinsics.checkExpressionValueIsNotNull((Object)annotationValue, (String)"getAnnotationValue(a, \"parentColumns\")");
                List<String> parentColumns = Element_extKt.getAsStringList(annotationValue);
                AnnotationValue annotationValue2 = AnnotationMirrors.getAnnotationValue((AnnotationMirror)a, (String)"childColumns");
                Intrinsics.checkExpressionValueIsNotNull((Object)annotationValue2, (String)"getAnnotationValue(a, \"childColumns\")");
                List<String> childColumns = Element_extKt.getAsStringList(annotationValue2);
                AnnotationValue annotationValue3 = AnnotationMirrors.getAnnotationValue((AnnotationMirror)a, (String)"onDelete");
                Intrinsics.checkExpressionValueIsNotNull((Object)annotationValue3, (String)"getAnnotationValue(a, \"onDelete\")");
                Integer onDeleteInput = Element_extKt.getAsInt$default(annotationValue3, null, 1, null);
                AnnotationValue annotationValue4 = AnnotationMirrors.getAnnotationValue((AnnotationMirror)a, (String)"onUpdate");
                Intrinsics.checkExpressionValueIsNotNull((Object)annotationValue4, (String)"getAnnotationValue(a, \"onUpdate\")");
                Integer onUpdateInput = Element_extKt.getAsInt$default(annotationValue4, null, 1, null);
                AnnotationValue annotationValue5 = AnnotationMirrors.getAnnotationValue((AnnotationMirror)a, (String)"deferred");
                Intrinsics.checkExpressionValueIsNotNull((Object)annotationValue5, (String)"getAnnotationValue(a, \"deferred\")");
                boolean deferred = Element_extKt.getAsBoolean(annotationValue5, true);
                ForeignKeyAction onDelete = ForeignKeyAction.Companion.fromAnnotationValue(onDeleteInput);
                ForeignKeyAction onUpdate = ForeignKeyAction.Companion.fromAnnotationValue(onUpdateInput);
                return new ForeignKeyInput(entityClass, parentColumns, childColumns, onDelete, onUpdate, deferred);
            }
        };
    }

    @NotNull
    public static final /* synthetic */ android.arch.persistence.room.vo.Entity access$doProcess(EntityProcessor $this) {
        return $this.doProcess();
    }

    @NotNull
    public static final /* synthetic */ Companion.INDEX_VISITOR.1 access$getINDEX_VISITOR$cp() {
        return INDEX_VISITOR;
    }

    @NotNull
    public static final /* synthetic */ Companion.FOREIGN_KEY_VISITOR.1 access$getFOREIGN_KEY_VISITOR$cp() {
        return FOREIGN_KEY_VISITOR;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0003J-\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Landroid/arch/persistence/room/processor/EntityProcessor$IndexInput;", "", "name", "", "unique", "", "columnNames", "", "(Ljava/lang/String;ZLjava/util/List;)V", "getColumnNames", "()Ljava/util/List;", "getName", "()Ljava/lang/String;", "getUnique", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "compiler"})
    public static final class IndexInput {
        @NotNull
        private final String name;
        private final boolean unique;
        @NotNull
        private final List<String> columnNames;

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final boolean getUnique() {
            return this.unique;
        }

        @NotNull
        public final List<String> getColumnNames() {
            return this.columnNames;
        }

        public IndexInput(@NotNull String name, boolean unique, @NotNull List<String> columnNames2) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull(columnNames2, (String)"columnNames");
            this.name = name;
            this.unique = unique;
            this.columnNames = columnNames2;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final boolean component2() {
            return this.unique;
        }

        @NotNull
        public final List<String> component3() {
            return this.columnNames;
        }

        @NotNull
        public final IndexInput copy(@NotNull String name, boolean unique, @NotNull List<String> columnNames2) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull(columnNames2, (String)"columnNames");
            return new IndexInput(name, unique, columnNames2);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ IndexInput copy$default(IndexInput indexInput, String string, boolean bl, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = indexInput.name;
            }
            if ((n & 2) != 0) {
                bl = indexInput.unique;
            }
            if ((n & 4) != 0) {
                list = indexInput.columnNames;
            }
            return indexInput.copy(string, bl, list);
        }

        public String toString() {
            return "IndexInput(name=" + this.name + ", unique=" + this.unique + ", columnNames=" + this.columnNames + ")";
        }

        public int hashCode() {
            String string = this.name;
            int n = (string != null ? string.hashCode() : 0) * 31;
            int n2 = this.unique ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            List<String> list = this.columnNames;
            return (n + n2) * 31 + (list != null ? ((Object)list).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof IndexInput)) break block3;
                    IndexInput indexInput = (IndexInput)object;
                    if (!Intrinsics.areEqual((Object)this.name, (Object)indexInput.name) || !(this.unique == indexInput.unique) || !Intrinsics.areEqual(this.columnNames, indexInput.columnNames)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\fH\u00c6\u0003JU\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020\f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020\u0006H\u00d6\u0001R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000f\u00a8\u0006$"}, d2={"Landroid/arch/persistence/room/processor/EntityProcessor$ForeignKeyInput;", "", "parent", "Ljavax/lang/model/type/TypeMirror;", "parentColumns", "", "", "childColumns", "onDelete", "Landroid/arch/persistence/room/vo/ForeignKeyAction;", "onUpdate", "deferred", "", "(Ljavax/lang/model/type/TypeMirror;Ljava/util/List;Ljava/util/List;Landroid/arch/persistence/room/vo/ForeignKeyAction;Landroid/arch/persistence/room/vo/ForeignKeyAction;Z)V", "getChildColumns", "()Ljava/util/List;", "getDeferred", "()Z", "getOnDelete", "()Landroid/arch/persistence/room/vo/ForeignKeyAction;", "getOnUpdate", "getParent", "()Ljavax/lang/model/type/TypeMirror;", "getParentColumns", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "toString", "compiler"})
    public static final class ForeignKeyInput {
        @NotNull
        private final TypeMirror parent;
        @NotNull
        private final List<String> parentColumns;
        @NotNull
        private final List<String> childColumns;
        @Nullable
        private final ForeignKeyAction onDelete;
        @Nullable
        private final ForeignKeyAction onUpdate;
        private final boolean deferred;

        @NotNull
        public final TypeMirror getParent() {
            return this.parent;
        }

        @NotNull
        public final List<String> getParentColumns() {
            return this.parentColumns;
        }

        @NotNull
        public final List<String> getChildColumns() {
            return this.childColumns;
        }

        @Nullable
        public final ForeignKeyAction getOnDelete() {
            return this.onDelete;
        }

        @Nullable
        public final ForeignKeyAction getOnUpdate() {
            return this.onUpdate;
        }

        public final boolean getDeferred() {
            return this.deferred;
        }

        public ForeignKeyInput(@NotNull TypeMirror parent, @NotNull List<String> parentColumns, @NotNull List<String> childColumns, @Nullable ForeignKeyAction onDelete, @Nullable ForeignKeyAction onUpdate, boolean deferred) {
            Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
            Intrinsics.checkParameterIsNotNull(parentColumns, (String)"parentColumns");
            Intrinsics.checkParameterIsNotNull(childColumns, (String)"childColumns");
            this.parent = parent;
            this.parentColumns = parentColumns;
            this.childColumns = childColumns;
            this.onDelete = onDelete;
            this.onUpdate = onUpdate;
            this.deferred = deferred;
        }

        @NotNull
        public final TypeMirror component1() {
            return this.parent;
        }

        @NotNull
        public final List<String> component2() {
            return this.parentColumns;
        }

        @NotNull
        public final List<String> component3() {
            return this.childColumns;
        }

        @Nullable
        public final ForeignKeyAction component4() {
            return this.onDelete;
        }

        @Nullable
        public final ForeignKeyAction component5() {
            return this.onUpdate;
        }

        public final boolean component6() {
            return this.deferred;
        }

        @NotNull
        public final ForeignKeyInput copy(@NotNull TypeMirror parent, @NotNull List<String> parentColumns, @NotNull List<String> childColumns, @Nullable ForeignKeyAction onDelete, @Nullable ForeignKeyAction onUpdate, boolean deferred) {
            Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
            Intrinsics.checkParameterIsNotNull(parentColumns, (String)"parentColumns");
            Intrinsics.checkParameterIsNotNull(childColumns, (String)"childColumns");
            return new ForeignKeyInput(parent, parentColumns, childColumns, onDelete, onUpdate, deferred);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ForeignKeyInput copy$default(ForeignKeyInput foreignKeyInput, TypeMirror typeMirror, List list, List list2, ForeignKeyAction foreignKeyAction, ForeignKeyAction foreignKeyAction2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                typeMirror = foreignKeyInput.parent;
            }
            if ((n & 2) != 0) {
                list = foreignKeyInput.parentColumns;
            }
            if ((n & 4) != 0) {
                list2 = foreignKeyInput.childColumns;
            }
            if ((n & 8) != 0) {
                foreignKeyAction = foreignKeyInput.onDelete;
            }
            if ((n & 0x10) != 0) {
                foreignKeyAction2 = foreignKeyInput.onUpdate;
            }
            if ((n & 0x20) != 0) {
                bl = foreignKeyInput.deferred;
            }
            return foreignKeyInput.copy(typeMirror, list, list2, foreignKeyAction, foreignKeyAction2, bl);
        }

        public String toString() {
            return "ForeignKeyInput(parent=" + this.parent + ", parentColumns=" + this.parentColumns + ", childColumns=" + this.childColumns + ", onDelete=" + (Object)((Object)this.onDelete) + ", onUpdate=" + (Object)((Object)this.onUpdate) + ", deferred=" + this.deferred + ")";
        }

        public int hashCode() {
            TypeMirror typeMirror = this.parent;
            List<String> list = this.parentColumns;
            List<String> list2 = this.childColumns;
            ForeignKeyAction foreignKeyAction = this.onDelete;
            ForeignKeyAction foreignKeyAction2 = this.onUpdate;
            int n = (((((typeMirror != null ? ((Object)typeMirror).hashCode() : 0) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0)) * 31 + (foreignKeyAction != null ? ((Object)((Object)foreignKeyAction)).hashCode() : 0)) * 31 + (foreignKeyAction2 != null ? ((Object)((Object)foreignKeyAction2)).hashCode() : 0)) * 31;
            int n2 = this.deferred ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ForeignKeyInput)) break block3;
                    ForeignKeyInput foreignKeyInput = (ForeignKeyInput)object;
                    if (!Intrinsics.areEqual((Object)this.parent, (Object)foreignKeyInput.parent) || !Intrinsics.areEqual(this.parentColumns, foreignKeyInput.parentColumns) || !Intrinsics.areEqual(this.childColumns, foreignKeyInput.childColumns) || !Intrinsics.areEqual((Object)((Object)this.onDelete), (Object)((Object)foreignKeyInput.onDelete)) || !Intrinsics.areEqual((Object)((Object)this.onUpdate), (Object)((Object)foreignKeyInput.onUpdate)) || !(this.deferred == foreignKeyInput.deferred)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0004\u0004\u0007\n\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0010H\u0002J\u0016\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0017R\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0010\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0010\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u001d"}, d2={"Landroid/arch/persistence/room/processor/EntityProcessor$Companion;", "", "()V", "FOREIGN_KEY_LIST_VISITOR", "android/arch/persistence/room/processor/EntityProcessor$Companion$FOREIGN_KEY_LIST_VISITOR$1", "Landroid/arch/persistence/room/processor/EntityProcessor$Companion$FOREIGN_KEY_LIST_VISITOR$1;", "FOREIGN_KEY_VISITOR", "android/arch/persistence/room/processor/EntityProcessor$Companion$FOREIGN_KEY_VISITOR$1", "Landroid/arch/persistence/room/processor/EntityProcessor$Companion$FOREIGN_KEY_VISITOR$1;", "INDEX_LIST_VISITOR", "android/arch/persistence/room/processor/EntityProcessor$Companion$INDEX_LIST_VISITOR$1", "Landroid/arch/persistence/room/processor/EntityProcessor$Companion$INDEX_LIST_VISITOR$1;", "INDEX_VISITOR", "android/arch/persistence/room/processor/EntityProcessor$Companion$INDEX_VISITOR$1", "Landroid/arch/persistence/room/processor/EntityProcessor$Companion$INDEX_VISITOR$1;", "createIndexName", "", "columnNames", "", "tableName", "extractForeignKeys", "Landroid/arch/persistence/room/processor/EntityProcessor$ForeignKeyInput;", "annotation", "Ljavax/lang/model/element/AnnotationMirror;", "extractIndices", "Landroid/arch/persistence/room/processor/EntityProcessor$IndexInput;", "extractTableName", "element", "Ljavax/lang/model/element/TypeElement;", "compiler"})
    public static final class Companion {
        @NotNull
        public final String extractTableName(@NotNull TypeElement element, @NotNull AnnotationMirror annotation) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
            AnnotationValue annotationValue = AnnotationMirrors.getAnnotationValue((AnnotationMirror)annotation, (String)"tableName");
            Intrinsics.checkExpressionValueIsNotNull((Object)annotationValue, (String)"AnnotationMirrors\n      \u2026(annotation, \"tableName\")");
            String annotationValue2 = annotationValue.getValue().toString();
            return Intrinsics.areEqual((Object)annotationValue2, (Object)"") ? element.getSimpleName().toString() : annotationValue2;
        }

        private final List<IndexInput> extractIndices(AnnotationMirror annotation, String tableName) {
            AnnotationValue arrayOfIndexAnnotations = AnnotationMirrors.getAnnotationValue((AnnotationMirror)annotation, (String)"indices");
            Object r = INDEX_LIST_VISITOR.visit(arrayOfIndexAnnotations, tableName);
            Intrinsics.checkExpressionValueIsNotNull(r, (String)"INDEX_LIST_VISITOR.visit\u2026exAnnotations, tableName)");
            return (List)r;
        }

        private final String createIndexName(List<String> columnNames2, String tableName) {
            return "index_" + tableName + "_" + CollectionsKt.joinToString$default((Iterable)columnNames2, (CharSequence)"_", null, null, (int)0, null, null, (int)62, null);
        }

        private final List<ForeignKeyInput> extractForeignKeys(AnnotationMirror annotation) {
            AnnotationValue arrayOfForeignKeyAnnotations = AnnotationMirrors.getAnnotationValue((AnnotationMirror)annotation, (String)"foreignKeys");
            Object r = FOREIGN_KEY_LIST_VISITOR.visit(arrayOfForeignKeyAnnotations);
            Intrinsics.checkExpressionValueIsNotNull(r, (String)"FOREIGN_KEY_LIST_VISITOR\u2026yOfForeignKeyAnnotations)");
            return (List)r;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

