/*
 * Decompiled with CFR 0.152.
 */
package android.arch.persistence.room.processor;

import android.arch.persistence.room.ext.Element_extKt;
import android.arch.persistence.room.processor.Context;
import android.arch.persistence.room.processor.ProcessorErrors;
import android.arch.persistence.room.vo.TransactionMethod;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Types;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Landroid/arch/persistence/room/processor/TransactionMethodProcessor;", "", "baseContext", "Landroid/arch/persistence/room/processor/Context;", "containing", "Ljavax/lang/model/type/DeclaredType;", "executableElement", "Ljavax/lang/model/element/ExecutableElement;", "(Landroid/arch/persistence/room/processor/Context;Ljavax/lang/model/type/DeclaredType;Ljavax/lang/model/element/ExecutableElement;)V", "getContaining", "()Ljavax/lang/model/type/DeclaredType;", "context", "getContext", "()Landroid/arch/persistence/room/processor/Context;", "getExecutableElement", "()Ljavax/lang/model/element/ExecutableElement;", "process", "Landroid/arch/persistence/room/vo/TransactionMethod;", "compiler"})
public final class TransactionMethodProcessor {
    @NotNull
    private final Context context;
    @NotNull
    private final DeclaredType containing;
    @NotNull
    private final ExecutableElement executableElement;

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final TransactionMethod process() {
        Element element = this.executableElement;
        Types types = this.context.getProcessingEnv().getTypeUtils();
        Intrinsics.checkExpressionValueIsNotNull((Object)types, (String)"context.processingEnv.typeUtils");
        Element kotlinDefaultImpl = Element_extKt.findKotlinDefaultImpl(element, types);
        this.context.getChecker().check(!Element_extKt.hasAnyOf(this.executableElement, Modifier.PRIVATE, Modifier.FINAL) && (!Element_extKt.hasAnyOf(this.executableElement, Modifier.ABSTRACT) || kotlinDefaultImpl != null), this.executableElement, ProcessorErrors.INSTANCE.getTRANSACTION_METHOD_MODIFIERS(), new Object[0]);
        TransactionMethod.CallType callType = Element_extKt.hasAnyOf(this.executableElement, Modifier.DEFAULT) ? TransactionMethod.CallType.DEFAULT_JAVA8 : (kotlinDefaultImpl != null ? TransactionMethod.CallType.DEFAULT_KOTLIN : TransactionMethod.CallType.CONCRETE);
        return new TransactionMethod(this.executableElement, this.executableElement.getSimpleName().toString(), callType);
    }

    @NotNull
    public final DeclaredType getContaining() {
        return this.containing;
    }

    @NotNull
    public final ExecutableElement getExecutableElement() {
        return this.executableElement;
    }

    public TransactionMethodProcessor(@NotNull Context baseContext, @NotNull DeclaredType containing, @NotNull ExecutableElement executableElement) {
        Intrinsics.checkParameterIsNotNull((Object)baseContext, (String)"baseContext");
        Intrinsics.checkParameterIsNotNull((Object)containing, (String)"containing");
        Intrinsics.checkParameterIsNotNull((Object)executableElement, (String)"executableElement");
        this.containing = containing;
        this.executableElement = executableElement;
        this.context = baseContext.fork(this.executableElement);
    }
}

