/*
 * Decompiled with CFR 0.152.
 */
package android.arch.persistence.room.migration.bundle;

import android.arch.persistence.room.migration.bundle.DatabaseBundle;
import android.support.annotation.RestrictTo;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class SchemaBundle {
    @SerializedName(value="formatVersion")
    private int mFormatVersion;
    @SerializedName(value="database")
    private DatabaseBundle mDatabase;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String CHARSET = "UTF-8";
    public static final int LATEST_FORMAT = 1;

    public SchemaBundle(int formatVersion, DatabaseBundle database) {
        this.mFormatVersion = formatVersion;
        this.mDatabase = database;
    }

    public int getFormatVersion() {
        return this.mFormatVersion;
    }

    public DatabaseBundle getDatabase() {
        return this.mDatabase;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static SchemaBundle deserialize(InputStream fis) throws UnsupportedEncodingException {
        InputStreamReader is = new InputStreamReader(fis, CHARSET);
        try {
            SchemaBundle schemaBundle = (SchemaBundle)GSON.fromJson((Reader)is, SchemaBundle.class);
            return schemaBundle;
        }
        finally {
            SchemaBundle.safeClose(is);
            SchemaBundle.safeClose(fis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static void serialize(SchemaBundle bundle, File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file, false);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, CHARSET);
        try {
            GSON.toJson((Object)bundle, (Appendable)osw);
        }
        finally {
            SchemaBundle.safeClose(osw);
            SchemaBundle.safeClose(fos);
        }
    }

    private static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

