/*
 * Decompiled with CFR 0.152.
 */
package android.arch.persistence.room.migration.bundle;

import android.arch.persistence.room.migration.bundle.BundleUtil;
import android.arch.persistence.room.migration.bundle.FieldBundle;
import android.arch.persistence.room.migration.bundle.ForeignKeyBundle;
import android.arch.persistence.room.migration.bundle.IndexBundle;
import android.arch.persistence.room.migration.bundle.PrimaryKeyBundle;
import android.arch.persistence.room.migration.bundle.SchemaEquality;
import android.arch.persistence.room.migration.bundle.SchemaEqualityUtil;
import android.support.annotation.RestrictTo;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class EntityBundle
implements SchemaEquality<EntityBundle> {
    static final String NEW_TABLE_PREFIX = "_new_";
    @SerializedName(value="tableName")
    private String mTableName;
    @SerializedName(value="createSql")
    private String mCreateSql;
    @SerializedName(value="fields")
    private List<FieldBundle> mFields;
    @SerializedName(value="primaryKey")
    private PrimaryKeyBundle mPrimaryKey;
    @SerializedName(value="indices")
    private List<IndexBundle> mIndices;
    @SerializedName(value="foreignKeys")
    private List<ForeignKeyBundle> mForeignKeys;
    private transient String mNewTableName;
    private transient Map<String, FieldBundle> mFieldsByColumnName;

    public EntityBundle(String tableName, String createSql, List<FieldBundle> fields, PrimaryKeyBundle primaryKey, List<IndexBundle> indices, List<ForeignKeyBundle> foreignKeys) {
        this.mTableName = tableName;
        this.mCreateSql = createSql;
        this.mFields = fields;
        this.mPrimaryKey = primaryKey;
        this.mIndices = indices;
        this.mForeignKeys = foreignKeys;
    }

    public String getNewTableName() {
        if (this.mNewTableName == null) {
            this.mNewTableName = NEW_TABLE_PREFIX + this.mTableName;
        }
        return this.mNewTableName;
    }

    public Map<String, FieldBundle> getFieldsByColumnName() {
        if (this.mFieldsByColumnName == null) {
            this.mFieldsByColumnName = new HashMap<String, FieldBundle>();
            for (FieldBundle bundle : this.mFields) {
                this.mFieldsByColumnName.put(bundle.getColumnName(), bundle);
            }
        }
        return this.mFieldsByColumnName;
    }

    public String getTableName() {
        return this.mTableName;
    }

    public String getCreateSql() {
        return this.mCreateSql;
    }

    public List<FieldBundle> getFields() {
        return this.mFields;
    }

    public PrimaryKeyBundle getPrimaryKey() {
        return this.mPrimaryKey;
    }

    public List<IndexBundle> getIndices() {
        return this.mIndices;
    }

    public List<ForeignKeyBundle> getForeignKeys() {
        return this.mForeignKeys;
    }

    public String createTable() {
        return BundleUtil.replaceTableName(this.mCreateSql, this.getTableName());
    }

    public String createNewTable() {
        return BundleUtil.replaceTableName(this.mCreateSql, this.getNewTableName());
    }

    @NotNull
    public String renameToOriginal() {
        return "ALTER TABLE " + this.getNewTableName() + " RENAME TO " + this.getTableName();
    }

    public Collection<String> buildCreateQueries() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.createTable());
        for (IndexBundle indexBundle : this.mIndices) {
            result.add(indexBundle.create(this.getTableName()));
        }
        return result;
    }

    @Override
    public boolean isSchemaEqual(EntityBundle other) {
        if (!this.mTableName.equals(other.mTableName)) {
            return false;
        }
        return SchemaEqualityUtil.checkSchemaEquality(this.getFieldsByColumnName(), other.getFieldsByColumnName()) && SchemaEqualityUtil.checkSchemaEquality(this.mPrimaryKey, other.mPrimaryKey) && SchemaEqualityUtil.checkSchemaEquality(this.mIndices, other.mIndices) && SchemaEqualityUtil.checkSchemaEquality(this.mForeignKeys, other.mForeignKeys);
    }
}

