/*
 * Decompiled with CFR 0.152.
 */
package android.arch.persistence.room;

import android.arch.persistence.room.RoomDatabase;
import android.content.Context;
import android.support.annotation.NonNull;

public class Room {
    static final String LOG_TAG = "ROOM";
    public static final String MASTER_TABLE_NAME = "room_master_table";
    private static final String CURSOR_CONV_SUFFIX = "_CursorConverter";

    public static <T extends RoomDatabase> RoomDatabase.Builder<T> databaseBuilder(@NonNull Context context, @NonNull Class<T> klass, @NonNull String name) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("Cannot create a database with null or empty name. If you are trying to create an in memory database, use Room.inMemoryDatabaseBuilder");
        }
        return new RoomDatabase.Builder<T>(context, klass, name);
    }

    public static <T extends RoomDatabase> RoomDatabase.Builder<T> inMemoryDatabaseBuilder(@NonNull Context context, @NonNull Class<T> klass) {
        return new RoomDatabase.Builder<T>(context, klass, null);
    }

    @NonNull
    static <T, C> T getGeneratedImplementation(Class<C> klass, String suffix) {
        String fullPackage = klass.getPackage().getName();
        String name = klass.getCanonicalName();
        String postPackageName = fullPackage.isEmpty() ? name : name.substring(fullPackage.length() + 1);
        String implName = postPackageName.replace('.', '_') + suffix;
        try {
            Class<?> aClass = Class.forName(fullPackage.isEmpty() ? implName : fullPackage + "." + implName);
            return (T)aClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("cannot find implementation for " + klass.getCanonicalName() + ". " + implName + " does not exist");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot access the constructor" + klass.getCanonicalName());
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Failed to create an instance of " + klass.getCanonicalName());
        }
    }
}

