/*
 * Decompiled with CFR 0.152.
 */
package android.arch.persistence.room;

import android.arch.core.executor.ArchTaskExecutor;
import android.arch.persistence.db.SimpleSQLiteQuery;
import android.arch.persistence.db.SupportSQLiteDatabase;
import android.arch.persistence.db.SupportSQLiteOpenHelper;
import android.arch.persistence.db.SupportSQLiteQuery;
import android.arch.persistence.db.SupportSQLiteStatement;
import android.arch.persistence.db.framework.FrameworkSQLiteOpenHelperFactory;
import android.arch.persistence.room.DatabaseConfiguration;
import android.arch.persistence.room.InvalidationTracker;
import android.arch.persistence.room.Room;
import android.arch.persistence.room.migration.Migration;
import android.content.Context;
import android.database.Cursor;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.v4.util.SparseArrayCompat;
import android.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class RoomDatabase {
    private static final String DB_IMPL_SUFFIX = "_Impl";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int MAX_BIND_PARAMETER_CNT = 999;
    protected volatile SupportSQLiteDatabase mDatabase;
    private SupportSQLiteOpenHelper mOpenHelper;
    private final InvalidationTracker mInvalidationTracker;
    private boolean mAllowMainThreadQueries;
    @Nullable
    protected List<Callback> mCallbacks;
    private final ReentrantLock mCloseLock = new ReentrantLock();

    Lock getCloseLock() {
        return this.mCloseLock;
    }

    public RoomDatabase() {
        this.mInvalidationTracker = this.createInvalidationTracker();
    }

    @CallSuper
    public void init(@NonNull DatabaseConfiguration configuration) {
        this.mOpenHelper = this.createOpenHelper(configuration);
        this.mCallbacks = configuration.callbacks;
        this.mAllowMainThreadQueries = configuration.allowMainThreadQueries;
    }

    @NonNull
    public SupportSQLiteOpenHelper getOpenHelper() {
        return this.mOpenHelper;
    }

    @NonNull
    protected abstract SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration var1);

    @NonNull
    protected abstract InvalidationTracker createInvalidationTracker();

    public boolean isOpen() {
        SupportSQLiteDatabase db = this.mDatabase;
        return db != null && db.isOpen();
    }

    public void close() {
        if (this.isOpen()) {
            try {
                this.mCloseLock.lock();
                this.mOpenHelper.close();
            }
            finally {
                this.mCloseLock.unlock();
            }
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void assertNotMainThread() {
        if (this.mAllowMainThreadQueries) {
            return;
        }
        if (ArchTaskExecutor.getInstance().isMainThread()) {
            throw new IllegalStateException("Cannot access database on the main thread since it may potentially lock the UI for a long period of time.");
        }
    }

    public Cursor query(String query, @Nullable Object[] args) {
        return this.mOpenHelper.getWritableDatabase().query((SupportSQLiteQuery)new SimpleSQLiteQuery(query, args));
    }

    public Cursor query(SupportSQLiteQuery query) {
        this.assertNotMainThread();
        return this.mOpenHelper.getWritableDatabase().query(query);
    }

    public SupportSQLiteStatement compileStatement(@NonNull String sql) {
        this.assertNotMainThread();
        return this.mOpenHelper.getWritableDatabase().compileStatement(sql);
    }

    public void beginTransaction() {
        this.assertNotMainThread();
        this.mInvalidationTracker.syncTriggers();
        this.mOpenHelper.getWritableDatabase().beginTransaction();
    }

    public void endTransaction() {
        this.mOpenHelper.getWritableDatabase().endTransaction();
        if (!this.inTransaction()) {
            this.mInvalidationTracker.refreshVersionsAsync();
        }
    }

    public void setTransactionSuccessful() {
        this.mOpenHelper.getWritableDatabase().setTransactionSuccessful();
    }

    public void runInTransaction(@NonNull Runnable body) {
        this.beginTransaction();
        try {
            body.run();
            this.setTransactionSuccessful();
        }
        finally {
            this.endTransaction();
        }
    }

    public <V> V runInTransaction(@NonNull Callable<V> body) {
        this.beginTransaction();
        try {
            V result = body.call();
            this.setTransactionSuccessful();
            V v = result;
            return v;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception in transaction", e);
        }
        finally {
            this.endTransaction();
        }
    }

    protected void internalInitInvalidationTracker(@NonNull SupportSQLiteDatabase db) {
        this.mInvalidationTracker.internalInit(db);
    }

    @NonNull
    public InvalidationTracker getInvalidationTracker() {
        return this.mInvalidationTracker;
    }

    public boolean inTransaction() {
        return this.mOpenHelper.getWritableDatabase().inTransaction();
    }

    public static abstract class Callback {
        public void onCreate(@NonNull SupportSQLiteDatabase db) {
        }

        public void onOpen(@NonNull SupportSQLiteDatabase db) {
        }
    }

    public static class MigrationContainer {
        private SparseArrayCompat<SparseArrayCompat<Migration>> mMigrations = new SparseArrayCompat();

        public void addMigrations(Migration ... migrations) {
            for (Migration migration : migrations) {
                this.addMigration(migration);
            }
        }

        private void addMigration(Migration migration) {
            Migration existing;
            int start = migration.startVersion;
            int end = migration.endVersion;
            SparseArrayCompat targetMap = (SparseArrayCompat)this.mMigrations.get(start);
            if (targetMap == null) {
                targetMap = new SparseArrayCompat();
                this.mMigrations.put(start, (Object)targetMap);
            }
            if ((existing = (Migration)targetMap.get(end)) != null) {
                Log.w((String)"ROOM", (String)("Overriding migration " + existing + " with " + migration));
            }
            targetMap.append(end, (Object)migration);
        }

        @Nullable
        public List<Migration> findMigrationPath(int start, int end) {
            if (start == end) {
                return Collections.emptyList();
            }
            boolean migrateUp = end > start;
            ArrayList<Migration> result = new ArrayList<Migration>();
            return this.findUpMigrationPath(result, migrateUp, start, end);
        }

        private List<Migration> findUpMigrationPath(List<Migration> result, boolean upgrade, int start, int end) {
            int searchDirection;
            int n = searchDirection = upgrade ? -1 : 1;
            while (upgrade ? start < end : start > end) {
                int lastIndex;
                int firstIndex;
                SparseArrayCompat targetNodes = (SparseArrayCompat)this.mMigrations.get(start);
                if (targetNodes == null) {
                    return null;
                }
                int size = targetNodes.size();
                if (upgrade) {
                    firstIndex = size - 1;
                    lastIndex = -1;
                } else {
                    firstIndex = 0;
                    lastIndex = size;
                }
                boolean found = false;
                for (int i = firstIndex; i != lastIndex; i += searchDirection) {
                    int targetVersion = targetNodes.keyAt(i);
                    if (targetVersion > end || targetVersion <= start) continue;
                    result.add((Migration)targetNodes.valueAt(i));
                    start = targetVersion;
                    found = true;
                    break;
                }
                if (found) continue;
                return null;
            }
            return result;
        }
    }

    public static class Builder<T extends RoomDatabase> {
        private final Class<T> mDatabaseClass;
        private final String mName;
        private final Context mContext;
        private ArrayList<Callback> mCallbacks;
        private SupportSQLiteOpenHelper.Factory mFactory;
        private boolean mAllowMainThreadQueries;
        private boolean mRequireMigration;
        private final MigrationContainer mMigrationContainer;
        private Set<Integer> mMigrationsNotRequiredFrom;
        private Set<Integer> mMigrationStartAndEndVersions;

        Builder(@NonNull Context context, @NonNull Class<T> klass, @Nullable String name) {
            this.mContext = context;
            this.mDatabaseClass = klass;
            this.mName = name;
            this.mRequireMigration = true;
            this.mMigrationContainer = new MigrationContainer();
        }

        @NonNull
        public Builder<T> openHelperFactory(@Nullable SupportSQLiteOpenHelper.Factory factory) {
            this.mFactory = factory;
            return this;
        }

        @NonNull
        public Builder<T> addMigrations(Migration ... migrations) {
            if (this.mMigrationStartAndEndVersions == null) {
                this.mMigrationStartAndEndVersions = new HashSet<Integer>();
            }
            for (Migration migration : migrations) {
                this.mMigrationStartAndEndVersions.add(migration.startVersion);
                this.mMigrationStartAndEndVersions.add(migration.endVersion);
            }
            this.mMigrationContainer.addMigrations(migrations);
            return this;
        }

        @NonNull
        public Builder<T> allowMainThreadQueries() {
            this.mAllowMainThreadQueries = true;
            return this;
        }

        @NonNull
        public Builder<T> fallbackToDestructiveMigration() {
            this.mRequireMigration = false;
            return this;
        }

        @NonNull
        public Builder<T> fallbackToDestructiveMigrationFrom(Integer ... startVersions) {
            if (this.mMigrationsNotRequiredFrom == null) {
                this.mMigrationsNotRequiredFrom = new HashSet<Integer>();
            }
            Collections.addAll(this.mMigrationsNotRequiredFrom, startVersions);
            return this;
        }

        @NonNull
        public Builder<T> addCallback(@NonNull Callback callback) {
            if (this.mCallbacks == null) {
                this.mCallbacks = new ArrayList();
            }
            this.mCallbacks.add(callback);
            return this;
        }

        @NonNull
        public T build() {
            if (this.mContext == null) {
                throw new IllegalArgumentException("Cannot provide null context for the database.");
            }
            if (this.mDatabaseClass == null) {
                throw new IllegalArgumentException("Must provide an abstract class that extends RoomDatabase");
            }
            if (this.mMigrationStartAndEndVersions != null && this.mMigrationsNotRequiredFrom != null) {
                for (Integer version : this.mMigrationStartAndEndVersions) {
                    if (!this.mMigrationsNotRequiredFrom.contains(version)) continue;
                    throw new IllegalArgumentException("Inconsistency detected. A Migration was supplied to addMigration(Migration... migrations) that has a start or end version equal to a start version supplied to fallbackToDestructiveMigrationFrom(Integer ... startVersions). Start version: " + version);
                }
            }
            if (this.mFactory == null) {
                this.mFactory = new FrameworkSQLiteOpenHelperFactory();
            }
            DatabaseConfiguration configuration = new DatabaseConfiguration(this.mContext, this.mName, this.mFactory, this.mMigrationContainer, this.mCallbacks, this.mAllowMainThreadQueries, this.mRequireMigration, this.mMigrationsNotRequiredFrom);
            RoomDatabase db = (RoomDatabase)Room.getGeneratedImplementation(this.mDatabaseClass, RoomDatabase.DB_IMPL_SUFFIX);
            db.init(configuration);
            return (T)db;
        }
    }
}

