/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl;

import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.MediatorLiveData;
import android.arch.lifecycle.Observer;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;

class WorkManagerLiveDataTracker {
    @VisibleForTesting
    final Set<LiveData> mLiveDataSet = Collections.newSetFromMap(new IdentityHashMap());

    WorkManagerLiveDataTracker() {
    }

    public <T> LiveData<T> track(LiveData<T> other) {
        return new TrackedLiveData<T>(this, other);
    }

    void onActive(LiveData liveData) {
        this.mLiveDataSet.add(liveData);
    }

    void onInactive(LiveData liveData) {
        this.mLiveDataSet.remove(liveData);
    }

    static class TrackedLiveData<T>
    extends MediatorLiveData<T> {
        private final WorkManagerLiveDataTracker mContainer;

        TrackedLiveData(WorkManagerLiveDataTracker container, LiveData<T> wrapped) {
            this.mContainer = container;
            this.addSource(wrapped, new Observer<T>(){

                public void onChanged(@Nullable T t) {
                    TrackedLiveData.this.setValue(t);
                }
            });
        }

        protected void onActive() {
            super.onActive();
            this.mContainer.onActive((LiveData)this);
        }

        protected void onInactive() {
            super.onInactive();
            this.mContainer.onInactive((LiveData)this);
        }
    }
}

