/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.constraints.trackers;

import android.content.Context;
import android.support.annotation.RestrictTo;
import androidx.work.Logger;
import androidx.work.impl.constraints.ConstraintListener;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class ConstraintTracker<T> {
    private static final String TAG = Logger.tagWithPrefix("ConstraintTracker");
    protected final Context mAppContext;
    private final Object mLock = new Object();
    private final Set<ConstraintListener<T>> mListeners = new LinkedHashSet<ConstraintListener<T>>();
    private T mCurrentState;

    ConstraintTracker(Context context) {
        this.mAppContext = context.getApplicationContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ConstraintListener<T> listener) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mListeners.add(listener)) {
                if (this.mListeners.size() == 1) {
                    this.mCurrentState = this.getInitialState();
                    Logger.get().debug(TAG, String.format("%s: initial state = %s", this.getClass().getSimpleName(), this.mCurrentState), new Throwable[0]);
                    this.startTracking();
                }
                listener.onConstraintChanged(this.mCurrentState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ConstraintListener<T> listener) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mListeners.remove(listener) && this.mListeners.isEmpty()) {
                this.stopTracking();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(T newState) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCurrentState == newState || this.mCurrentState != null && this.mCurrentState.equals(newState)) {
                return;
            }
            this.mCurrentState = newState;
            ArrayList<ConstraintListener<T>> listenersList = new ArrayList<ConstraintListener<T>>(this.mListeners);
            for (ConstraintListener constraintListener : listenersList) {
                constraintListener.onConstraintChanged(this.mCurrentState);
            }
        }
    }

    public abstract T getInitialState();

    public abstract void startTracking();

    public abstract void stopTracking();
}

