/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.RestrictTo;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class IdGenerator {
    public static final int INITIAL_ID = 0;
    static final String PREFERENCE_FILE_KEY = "androidx.work.util.id";
    static final String NEXT_JOB_SCHEDULER_ID_KEY = "next_job_scheduler_id";
    static final String NEXT_ALARM_MANAGER_ID_KEY = "next_alarm_manager_id";
    private final Context mContext;
    private SharedPreferences mSharedPrefs;
    private boolean mLoadedPreferences;

    public IdGenerator(Context context) {
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int nextJobSchedulerIdWithRange(int minInclusive, int maxInclusive) {
        Class<IdGenerator> clazz = IdGenerator.class;
        synchronized (IdGenerator.class) {
            this.loadPreferencesIfNecessary();
            int id = this.nextId(NEXT_JOB_SCHEDULER_ID_KEY);
            if (id < minInclusive || id > maxInclusive) {
                id = minInclusive;
                this.update(NEXT_JOB_SCHEDULER_ID_KEY, id + 1);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int nextAlarmManagerId() {
        Class<IdGenerator> clazz = IdGenerator.class;
        synchronized (IdGenerator.class) {
            this.loadPreferencesIfNecessary();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.nextId(NEXT_ALARM_MANAGER_ID_KEY);
        }
    }

    private int nextId(String key) {
        int id = this.mSharedPrefs.getInt(key, 0);
        int nextId = id == Integer.MAX_VALUE ? 0 : id + 1;
        this.update(key, nextId);
        return id;
    }

    private void update(String key, int value) {
        this.mSharedPrefs.edit().putInt(key, value).apply();
    }

    private void loadPreferencesIfNecessary() {
        if (!this.mLoadedPreferences) {
            this.mSharedPrefs = this.mContext.getSharedPreferences(PREFERENCE_FILE_KEY, 0);
            this.mLoadedPreferences = true;
        }
    }
}

