/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.app;

import android.app.Dialog;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.app.ActionBar;
import android.support.v7.app.ActionBarActivity;
import android.support.v7.appcompat.R;
import android.support.v7.internal.view.ActionBarPolicy;
import android.support.v7.internal.view.SupportMenuInflater;
import android.support.v7.internal.view.menu.MenuBuilder;
import android.support.v7.internal.view.menu.SubMenuBuilder;
import android.support.v7.internal.widget.ActionBarContainer;
import android.support.v7.internal.widget.ActionBarContextView;
import android.support.v7.internal.widget.ActionBarOverlayLayout;
import android.support.v7.internal.widget.ActionBarView;
import android.support.v7.internal.widget.ScrollingTabContainerView;
import android.support.v7.view.ActionMode;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.SpinnerAdapter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

class ActionBarImplBase
extends ActionBar {
    private Context mContext;
    private Context mThemedContext;
    private ActionBarActivity mActivity;
    private Dialog mDialog;
    private ActionBarOverlayLayout mOverlayLayout;
    private ActionBarContainer mContainerView;
    private ViewGroup mTopVisibilityView;
    private ActionBarView mActionView;
    private ActionBarContextView mContextView;
    private ActionBarContainer mSplitView;
    private View mContentView;
    private ScrollingTabContainerView mTabScrollView;
    private ArrayList<TabImpl> mTabs = new ArrayList();
    private TabImpl mSelectedTab;
    private int mSavedTabPosition = -1;
    private boolean mDisplayHomeAsUpSet;
    ActionModeImpl mActionMode;
    ActionMode mDeferredDestroyActionMode;
    ActionMode.Callback mDeferredModeDestroyCallback;
    private boolean mLastMenuVisibility;
    private ArrayList<ActionBar.OnMenuVisibilityListener> mMenuVisibilityListeners = new ArrayList();
    private static final int CONTEXT_DISPLAY_NORMAL = 0;
    private static final int CONTEXT_DISPLAY_SPLIT = 1;
    private static final int INVALID_POSITION = -1;
    private int mContextDisplayMode;
    private boolean mHasEmbeddedTabs;
    final Handler mHandler = new Handler();
    Runnable mTabSelector;
    private int mCurWindowVisibility = 0;
    private boolean mHiddenByApp;
    private boolean mHiddenBySystem;
    private boolean mShowingForMode;
    private boolean mNowShowing = true;
    private boolean mShowHideAnimationEnabled;
    private ActionBar.Callback mCallback;

    public ActionBarImplBase(ActionBarActivity activity, ActionBar.Callback callback) {
        this.mActivity = activity;
        this.mContext = activity;
        this.mCallback = callback;
        this.init(this.mActivity);
    }

    private void init(ActionBarActivity activity) {
        ActionBarPolicy abp;
        boolean homeAsUp;
        this.mOverlayLayout = (ActionBarOverlayLayout)activity.findViewById(R.id.action_bar_overlay_layout);
        if (this.mOverlayLayout != null) {
            this.mOverlayLayout.setActionBar(this);
        }
        this.mActionView = (ActionBarView)activity.findViewById(R.id.action_bar);
        this.mContextView = (ActionBarContextView)activity.findViewById(R.id.action_context_bar);
        this.mContainerView = (ActionBarContainer)activity.findViewById(R.id.action_bar_container);
        this.mTopVisibilityView = (ViewGroup)activity.findViewById(R.id.top_action_bar);
        if (this.mTopVisibilityView == null) {
            this.mTopVisibilityView = this.mContainerView;
        }
        this.mSplitView = (ActionBarContainer)activity.findViewById(R.id.split_action_bar);
        if (this.mActionView == null || this.mContextView == null || this.mContainerView == null) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " can only be used " + "with a compatible window decor layout");
        }
        this.mActionView.setContextView(this.mContextView);
        this.mContextDisplayMode = this.mActionView.isSplitActionBar() ? 1 : 0;
        int current = this.mActionView.getDisplayOptions();
        boolean bl = homeAsUp = (current & 4) != 0;
        if (homeAsUp) {
            this.mDisplayHomeAsUpSet = true;
        }
        this.setHomeButtonEnabled((abp = ActionBarPolicy.get(this.mContext)).enableHomeButtonByDefault() || homeAsUp);
        this.setHasEmbeddedTabs(abp.hasEmbeddedTabs());
        this.setTitle(this.mActivity.getTitle());
    }

    public void onConfigurationChanged(Configuration newConfig) {
        this.setHasEmbeddedTabs(ActionBarPolicy.get(this.mContext).hasEmbeddedTabs());
    }

    private void setHasEmbeddedTabs(boolean hasEmbeddedTabs) {
        boolean isInTabMode;
        this.mHasEmbeddedTabs = hasEmbeddedTabs;
        if (!this.mHasEmbeddedTabs) {
            this.mActionView.setEmbeddedTabView(null);
            this.mContainerView.setTabContainer(this.mTabScrollView);
        } else {
            this.mContainerView.setTabContainer(null);
            this.mActionView.setEmbeddedTabView(this.mTabScrollView);
        }
        boolean bl = isInTabMode = this.getNavigationMode() == 2;
        if (this.mTabScrollView != null) {
            if (isInTabMode) {
                this.mTabScrollView.setVisibility(0);
            } else {
                this.mTabScrollView.setVisibility(8);
            }
        }
        this.mActionView.setCollapsable(!this.mHasEmbeddedTabs && isInTabMode);
    }

    public boolean hasNonEmbeddedTabs() {
        return !this.mHasEmbeddedTabs && this.getNavigationMode() == 2;
    }

    public void setCustomView(View view) {
        this.mActionView.setCustomNavigationView(view);
    }

    public void setCustomView(View view, ActionBar.LayoutParams layoutParams) {
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.mActionView.setCustomNavigationView(view);
    }

    public void setCustomView(int resId) {
        this.setCustomView(LayoutInflater.from((Context)this.getThemedContext()).inflate(resId, (ViewGroup)this.mActionView, false));
    }

    public void setIcon(int resId) {
        this.mActionView.setIcon(resId);
    }

    public void setIcon(Drawable icon) {
        this.mActionView.setIcon(icon);
    }

    public void setLogo(int resId) {
        this.mActionView.setLogo(resId);
    }

    public void setLogo(Drawable logo) {
        this.mActionView.setLogo(logo);
    }

    public void setListNavigationCallbacks(SpinnerAdapter adapter, ActionBar.OnNavigationListener callback) {
        this.mActionView.setDropdownAdapter(adapter);
        this.mActionView.setCallback(callback);
    }

    public void setSelectedNavigationItem(int position) {
        switch (this.mActionView.getNavigationMode()) {
            case 2: {
                this.selectTab(this.mTabs.get(position));
                break;
            }
            case 1: {
                this.mActionView.setDropdownSelectedPosition(position);
                break;
            }
            default: {
                throw new IllegalStateException("setSelectedNavigationIndex not valid for current navigation mode");
            }
        }
    }

    public int getSelectedNavigationIndex() {
        switch (this.mActionView.getNavigationMode()) {
            case 2: {
                return this.mSelectedTab != null ? this.mSelectedTab.getPosition() : -1;
            }
            case 1: {
                return this.mActionView.getDropdownSelectedPosition();
            }
        }
        return -1;
    }

    public int getNavigationItemCount() {
        switch (this.mActionView.getNavigationMode()) {
            case 2: {
                return this.mTabs.size();
            }
            case 1: {
                SpinnerAdapter adapter = this.mActionView.getDropdownAdapter();
                return adapter != null ? adapter.getCount() : 0;
            }
        }
        return 0;
    }

    public void setTitle(CharSequence title) {
        this.mActionView.setTitle(title);
    }

    public void setTitle(int resId) {
        this.setTitle(this.mContext.getString(resId));
    }

    public void setSubtitle(CharSequence subtitle) {
        this.mActionView.setSubtitle(subtitle);
    }

    public void setSubtitle(int resId) {
        this.setSubtitle(this.mContext.getString(resId));
    }

    public void setDisplayOptions(int options) {
        if ((options & 4) != 0) {
            this.mDisplayHomeAsUpSet = true;
        }
        this.mActionView.setDisplayOptions(options);
    }

    public void setDisplayOptions(int options, int mask) {
        int current = this.mActionView.getDisplayOptions();
        if ((mask & 4) != 0) {
            this.mDisplayHomeAsUpSet = true;
        }
        this.mActionView.setDisplayOptions(options & mask | current & ~mask);
    }

    public void setDisplayUseLogoEnabled(boolean useLogo) {
        this.setDisplayOptions(useLogo ? 1 : 0, 1);
    }

    public void setDisplayShowHomeEnabled(boolean showHome) {
        this.setDisplayOptions(showHome ? 2 : 0, 2);
    }

    public void setDisplayHomeAsUpEnabled(boolean showHomeAsUp) {
        this.setDisplayOptions(showHomeAsUp ? 4 : 0, 4);
    }

    public void setDisplayShowTitleEnabled(boolean showTitle) {
        this.setDisplayOptions(showTitle ? 8 : 0, 8);
    }

    public void setDisplayShowCustomEnabled(boolean showCustom) {
        this.setDisplayOptions(showCustom ? 16 : 0, 16);
    }

    public void setHomeButtonEnabled(boolean enable) {
        this.mActionView.setHomeButtonEnabled(enable);
    }

    public void setBackgroundDrawable(Drawable d) {
        this.mContainerView.setPrimaryBackground(d);
    }

    public View getCustomView() {
        return this.mActionView.getCustomNavigationView();
    }

    public CharSequence getTitle() {
        return this.mActionView.getTitle();
    }

    public CharSequence getSubtitle() {
        return this.mActionView.getSubtitle();
    }

    public int getNavigationMode() {
        return this.mActionView.getNavigationMode();
    }

    public void setNavigationMode(int mode) {
        int oldMode = this.mActionView.getNavigationMode();
        switch (oldMode) {
            case 2: {
                this.mSavedTabPosition = this.getSelectedNavigationIndex();
                this.selectTab(null);
                this.mTabScrollView.setVisibility(8);
            }
        }
        this.mActionView.setNavigationMode(mode);
        switch (mode) {
            case 2: {
                this.ensureTabsExist();
                this.mTabScrollView.setVisibility(0);
                if (this.mSavedTabPosition == -1) break;
                this.setSelectedNavigationItem(this.mSavedTabPosition);
                this.mSavedTabPosition = -1;
            }
        }
        this.mActionView.setCollapsable(mode == 2 && !this.mHasEmbeddedTabs);
    }

    public int getDisplayOptions() {
        return this.mActionView.getDisplayOptions();
    }

    public ActionBar.Tab newTab() {
        return new TabImpl();
    }

    public void addTab(ActionBar.Tab tab) {
        this.addTab(tab, this.mTabs.isEmpty());
    }

    public void addTab(ActionBar.Tab tab, boolean setSelected) {
        this.ensureTabsExist();
        this.mTabScrollView.addTab(tab, setSelected);
        this.configureTab(tab, this.mTabs.size());
        if (setSelected) {
            this.selectTab(tab);
        }
    }

    public void addTab(ActionBar.Tab tab, int position) {
        this.addTab(tab, position, this.mTabs.isEmpty());
    }

    public void addTab(ActionBar.Tab tab, int position, boolean setSelected) {
        this.ensureTabsExist();
        this.mTabScrollView.addTab(tab, position, setSelected);
        this.configureTab(tab, position);
        if (setSelected) {
            this.selectTab(tab);
        }
    }

    public void removeTab(ActionBar.Tab tab) {
        this.removeTabAt(tab.getPosition());
    }

    public void removeTabAt(int position) {
        if (this.mTabScrollView == null) {
            return;
        }
        int selectedTabPosition = this.mSelectedTab != null ? this.mSelectedTab.getPosition() : this.mSavedTabPosition;
        this.mTabScrollView.removeTabAt(position);
        TabImpl removedTab = this.mTabs.remove(position);
        if (removedTab != null) {
            removedTab.setPosition(-1);
        }
        int newTabCount = this.mTabs.size();
        for (int i = position; i < newTabCount; ++i) {
            this.mTabs.get(i).setPosition(i);
        }
        if (selectedTabPosition == position) {
            this.selectTab(this.mTabs.isEmpty() ? null : this.mTabs.get(Math.max(0, position - 1)));
        }
    }

    public void removeAllTabs() {
        this.cleanupTabs();
    }

    public void selectTab(ActionBar.Tab tab) {
        if (this.getNavigationMode() != 2) {
            this.mSavedTabPosition = tab != null ? tab.getPosition() : -1;
            return;
        }
        FragmentTransaction trans = this.mActivity.getSupportFragmentManager().beginTransaction().disallowAddToBackStack();
        if (this.mSelectedTab == tab) {
            if (this.mSelectedTab != null) {
                this.mSelectedTab.getCallback().onTabReselected(this.mSelectedTab, trans);
                this.mTabScrollView.animateToTab(tab.getPosition());
            }
        } else {
            this.mTabScrollView.setTabSelected(tab != null ? tab.getPosition() : -1);
            if (this.mSelectedTab != null) {
                this.mSelectedTab.getCallback().onTabUnselected(this.mSelectedTab, trans);
            }
            this.mSelectedTab = (TabImpl)tab;
            if (this.mSelectedTab != null) {
                this.mSelectedTab.getCallback().onTabSelected(this.mSelectedTab, trans);
            }
        }
        if (!trans.isEmpty()) {
            trans.commit();
        }
    }

    public ActionBar.Tab getSelectedTab() {
        return this.mSelectedTab;
    }

    public ActionBar.Tab getTabAt(int index) {
        return this.mTabs.get(index);
    }

    public int getTabCount() {
        return this.mTabs.size();
    }

    public Context getThemedContext() {
        if (this.mThemedContext == null) {
            TypedValue outValue = new TypedValue();
            Resources.Theme currentTheme = this.mContext.getTheme();
            currentTheme.resolveAttribute(R.attr.actionBarWidgetTheme, outValue, true);
            int targetThemeRes = outValue.resourceId;
            this.mThemedContext = targetThemeRes != 0 ? new ContextThemeWrapper(this.mContext, targetThemeRes) : this.mContext;
        }
        return this.mThemedContext;
    }

    public int getHeight() {
        return this.mContainerView.getHeight();
    }

    public void show() {
        if (this.mHiddenByApp) {
            this.mHiddenByApp = false;
            this.updateVisibility(false);
        }
    }

    void showForActionMode() {
        if (!this.mShowingForMode) {
            this.mShowingForMode = true;
            this.updateVisibility(false);
        }
    }

    public void hide() {
        if (!this.mHiddenByApp) {
            this.mHiddenByApp = true;
            this.updateVisibility(false);
        }
    }

    void hideForActionMode() {
        if (this.mShowingForMode) {
            this.mShowingForMode = false;
            this.updateVisibility(false);
        }
    }

    public boolean isShowing() {
        return this.mNowShowing;
    }

    public void addOnMenuVisibilityListener(ActionBar.OnMenuVisibilityListener listener) {
        this.mMenuVisibilityListeners.add(listener);
    }

    public void removeOnMenuVisibilityListener(ActionBar.OnMenuVisibilityListener listener) {
        this.mMenuVisibilityListeners.remove(listener);
    }

    public ActionMode startActionMode(ActionMode.Callback callback) {
        if (this.mActionMode != null) {
            this.mActionMode.finish();
        }
        this.mContextView.killMode();
        ActionModeImpl mode = new ActionModeImpl(callback);
        if (mode.dispatchOnCreate()) {
            mode.invalidate();
            this.mContextView.initForMode(mode);
            this.animateToMode(true);
            if (this.mSplitView != null && this.mContextDisplayMode == 1 && this.mSplitView.getVisibility() != 0) {
                this.mSplitView.setVisibility(0);
            }
            this.mContextView.sendAccessibilityEvent(32);
            this.mActionMode = mode;
            return mode;
        }
        return null;
    }

    void animateToMode(boolean toActionMode) {
        if (toActionMode) {
            this.showForActionMode();
        } else {
            this.hideForActionMode();
        }
        this.mActionView.animateToVisibility(toActionMode ? 4 : 0);
        this.mContextView.animateToVisibility(toActionMode ? 0 : 8);
        if (this.mTabScrollView != null && !this.mActionView.hasEmbeddedTabs() && this.mActionView.isCollapsed()) {
            this.mTabScrollView.setVisibility(toActionMode ? 8 : 0);
        }
    }

    private void ensureTabsExist() {
        if (this.mTabScrollView != null) {
            return;
        }
        ScrollingTabContainerView tabScroller = new ScrollingTabContainerView(this.mContext);
        if (this.mHasEmbeddedTabs) {
            tabScroller.setVisibility(0);
            this.mActionView.setEmbeddedTabView(tabScroller);
        } else {
            if (this.getNavigationMode() == 2) {
                tabScroller.setVisibility(0);
            } else {
                tabScroller.setVisibility(8);
            }
            this.mContainerView.setTabContainer(tabScroller);
        }
        this.mTabScrollView = tabScroller;
    }

    private void configureTab(ActionBar.Tab tab, int position) {
        TabImpl tabi = (TabImpl)tab;
        ActionBar.TabListener callback = tabi.getCallback();
        if (callback == null) {
            throw new IllegalStateException("Action Bar Tab must have a Callback");
        }
        tabi.setPosition(position);
        this.mTabs.add(position, tabi);
        int count = this.mTabs.size();
        for (int i = position + 1; i < count; ++i) {
            this.mTabs.get(i).setPosition(i);
        }
    }

    private void cleanupTabs() {
        if (this.mSelectedTab != null) {
            this.selectTab(null);
        }
        this.mTabs.clear();
        if (this.mTabScrollView != null) {
            this.mTabScrollView.removeAllTabs();
        }
        this.mSavedTabPosition = -1;
    }

    private static boolean checkShowingFlags(boolean hiddenByApp, boolean hiddenBySystem, boolean showingForMode) {
        if (showingForMode) {
            return true;
        }
        return !hiddenByApp && !hiddenBySystem;
    }

    private void updateVisibility(boolean fromSystem) {
        boolean shown = ActionBarImplBase.checkShowingFlags(this.mHiddenByApp, this.mHiddenBySystem, this.mShowingForMode);
        if (shown) {
            if (!this.mNowShowing) {
                this.mNowShowing = true;
                this.doShow(fromSystem);
            }
        } else if (this.mNowShowing) {
            this.mNowShowing = false;
            this.doHide(fromSystem);
        }
    }

    public void setShowHideAnimationEnabled(boolean enabled) {
        this.mShowHideAnimationEnabled = enabled;
        if (!enabled) {
            this.mTopVisibilityView.clearAnimation();
            if (this.mSplitView != null) {
                this.mSplitView.clearAnimation();
            }
        }
    }

    public void doShow(boolean fromSystem) {
        Animation anim2;
        boolean animate;
        this.mTopVisibilityView.clearAnimation();
        if (this.mTopVisibilityView.getVisibility() == 0) {
            return;
        }
        boolean bl = animate = this.isShowHideAnimationEnabled() || fromSystem;
        if (animate) {
            anim2 = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.abc_slide_in_top);
            this.mTopVisibilityView.startAnimation(anim2);
        }
        this.mTopVisibilityView.setVisibility(0);
        if (this.mSplitView != null && this.mSplitView.getVisibility() != 0) {
            if (animate) {
                anim2 = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.abc_slide_in_bottom);
                this.mSplitView.startAnimation(anim2);
            }
            this.mSplitView.setVisibility(0);
        }
    }

    public void doHide(boolean fromSystem) {
        Animation anim2;
        boolean animate;
        this.mTopVisibilityView.clearAnimation();
        if (this.mTopVisibilityView.getVisibility() == 8) {
            return;
        }
        boolean bl = animate = this.isShowHideAnimationEnabled() || fromSystem;
        if (animate) {
            anim2 = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.abc_slide_out_top);
            this.mTopVisibilityView.startAnimation(anim2);
        }
        this.mTopVisibilityView.setVisibility(8);
        if (this.mSplitView != null && this.mSplitView.getVisibility() != 8) {
            if (animate) {
                anim2 = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.abc_slide_out_bottom);
                this.mSplitView.startAnimation(anim2);
            }
            this.mSplitView.setVisibility(8);
        }
    }

    boolean isShowHideAnimationEnabled() {
        return this.mShowHideAnimationEnabled;
    }

    class ActionModeImpl
    extends ActionMode
    implements MenuBuilder.Callback {
        private ActionMode.Callback mCallback;
        private MenuBuilder mMenu;
        private WeakReference<View> mCustomView;

        public ActionModeImpl(ActionMode.Callback callback) {
            this.mCallback = callback;
            this.mMenu = new MenuBuilder(ActionBarImplBase.this.getThemedContext()).setDefaultShowAsAction(1);
            this.mMenu.setCallback(this);
        }

        public MenuInflater getMenuInflater() {
            return new SupportMenuInflater(ActionBarImplBase.this.getThemedContext());
        }

        public Menu getMenu() {
            return this.mMenu;
        }

        public void finish() {
            if (ActionBarImplBase.this.mActionMode != this) {
                return;
            }
            if (!ActionBarImplBase.checkShowingFlags(ActionBarImplBase.this.mHiddenByApp, ActionBarImplBase.this.mHiddenBySystem, false)) {
                ActionBarImplBase.this.mDeferredDestroyActionMode = this;
                ActionBarImplBase.this.mDeferredModeDestroyCallback = this.mCallback;
            } else {
                this.mCallback.onDestroyActionMode(this);
            }
            this.mCallback = null;
            ActionBarImplBase.this.animateToMode(false);
            ActionBarImplBase.this.mContextView.closeMode();
            ActionBarImplBase.this.mActionView.sendAccessibilityEvent(32);
            ActionBarImplBase.this.mActionMode = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invalidate() {
            this.mMenu.stopDispatchingItemsChanged();
            try {
                this.mCallback.onPrepareActionMode(this, (Menu)this.mMenu);
            }
            finally {
                this.mMenu.startDispatchingItemsChanged();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean dispatchOnCreate() {
            this.mMenu.stopDispatchingItemsChanged();
            try {
                boolean bl = this.mCallback.onCreateActionMode(this, (Menu)this.mMenu);
                return bl;
            }
            finally {
                this.mMenu.startDispatchingItemsChanged();
            }
        }

        public void setCustomView(View view) {
            ActionBarImplBase.this.mContextView.setCustomView(view);
            this.mCustomView = new WeakReference<View>(view);
        }

        public void setSubtitle(CharSequence subtitle) {
            ActionBarImplBase.this.mContextView.setSubtitle(subtitle);
        }

        public void setTitle(CharSequence title) {
            ActionBarImplBase.this.mContextView.setTitle(title);
        }

        public void setTitle(int resId) {
            this.setTitle(ActionBarImplBase.this.mContext.getResources().getString(resId));
        }

        public void setSubtitle(int resId) {
            this.setSubtitle(ActionBarImplBase.this.mContext.getResources().getString(resId));
        }

        public CharSequence getTitle() {
            return ActionBarImplBase.this.mContextView.getTitle();
        }

        public CharSequence getSubtitle() {
            return ActionBarImplBase.this.mContextView.getSubtitle();
        }

        public void setTitleOptionalHint(boolean titleOptional) {
            super.setTitleOptionalHint(titleOptional);
            ActionBarImplBase.this.mContextView.setTitleOptional(titleOptional);
        }

        public boolean isTitleOptional() {
            return ActionBarImplBase.this.mContextView.isTitleOptional();
        }

        public View getCustomView() {
            return this.mCustomView != null ? (View)this.mCustomView.get() : null;
        }

        public boolean onMenuItemSelected(MenuBuilder menu, MenuItem item) {
            if (this.mCallback != null) {
                return this.mCallback.onActionItemClicked(this, item);
            }
            return false;
        }

        public void onMenuModeChange(MenuBuilder menu) {
            if (this.mCallback == null) {
                return;
            }
            this.invalidate();
            ActionBarImplBase.this.mContextView.showOverflowMenu();
        }

        public void onCloseMenu(MenuBuilder menu, boolean allMenusAreClosing) {
        }

        public boolean onSubMenuSelected(SubMenuBuilder subMenu) {
            if (this.mCallback == null) {
                return false;
            }
            if (!subMenu.hasVisibleItems()) {
                return true;
            }
            return true;
        }

        public void onCloseSubMenu(SubMenuBuilder menu) {
        }

        public void onMenuModeChange(Menu menu) {
            if (this.mCallback == null) {
                return;
            }
            this.invalidate();
            ActionBarImplBase.this.mContextView.showOverflowMenu();
        }
    }

    public class TabImpl
    extends ActionBar.Tab {
        private ActionBar.TabListener mCallback;
        private Object mTag;
        private Drawable mIcon;
        private CharSequence mText;
        private CharSequence mContentDesc;
        private int mPosition = -1;
        private View mCustomView;

        public Object getTag() {
            return this.mTag;
        }

        public ActionBar.Tab setTag(Object tag) {
            this.mTag = tag;
            return this;
        }

        public ActionBar.TabListener getCallback() {
            return this.mCallback;
        }

        public ActionBar.Tab setTabListener(ActionBar.TabListener callback) {
            this.mCallback = callback;
            return this;
        }

        public View getCustomView() {
            return this.mCustomView;
        }

        public ActionBar.Tab setCustomView(View view) {
            this.mCustomView = view;
            if (this.mPosition >= 0) {
                ActionBarImplBase.this.mTabScrollView.updateTab(this.mPosition);
            }
            return this;
        }

        public ActionBar.Tab setCustomView(int layoutResId) {
            return this.setCustomView(LayoutInflater.from((Context)ActionBarImplBase.this.getThemedContext()).inflate(layoutResId, null));
        }

        public Drawable getIcon() {
            return this.mIcon;
        }

        public int getPosition() {
            return this.mPosition;
        }

        public void setPosition(int position) {
            this.mPosition = position;
        }

        public CharSequence getText() {
            return this.mText;
        }

        public ActionBar.Tab setIcon(Drawable icon) {
            this.mIcon = icon;
            if (this.mPosition >= 0) {
                ActionBarImplBase.this.mTabScrollView.updateTab(this.mPosition);
            }
            return this;
        }

        public ActionBar.Tab setIcon(int resId) {
            return this.setIcon(ActionBarImplBase.this.mContext.getResources().getDrawable(resId));
        }

        public ActionBar.Tab setText(CharSequence text) {
            this.mText = text;
            if (this.mPosition >= 0) {
                ActionBarImplBase.this.mTabScrollView.updateTab(this.mPosition);
            }
            return this;
        }

        public ActionBar.Tab setText(int resId) {
            return this.setText(ActionBarImplBase.this.mContext.getResources().getText(resId));
        }

        public void select() {
            ActionBarImplBase.this.selectTab(this);
        }

        public ActionBar.Tab setContentDescription(int resId) {
            return this.setContentDescription(ActionBarImplBase.this.mContext.getResources().getText(resId));
        }

        public ActionBar.Tab setContentDescription(CharSequence contentDesc) {
            this.mContentDesc = contentDesc;
            if (this.mPosition >= 0) {
                ActionBarImplBase.this.mTabScrollView.updateTab(this.mPosition);
            }
            return this;
        }

        public CharSequence getContentDescription() {
            return this.mContentDesc;
        }
    }
}

