/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_impl.renderkit.html;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectBoolean;
import javax.faces.component.UISelectMany;
import javax.faces.component.html.HtmlSelectBooleanCheckbox;
import javax.faces.component.html.HtmlSelectManyCheckbox;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.shared_impl.renderkit.RendererUtils;
import org.apache.myfaces.shared_impl.renderkit.html.HTML;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlRendererUtils;

public class HtmlCheckboxRendererBase
extends HtmlRenderer {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$shared_impl$renderkit$html$HtmlCheckboxRendererBase == null ? (class$org$apache$myfaces$shared_impl$renderkit$html$HtmlCheckboxRendererBase = HtmlCheckboxRendererBase.class$("org.apache.myfaces.shared_impl.renderkit.html.HtmlCheckboxRendererBase")) : class$org$apache$myfaces$shared_impl$renderkit$html$HtmlCheckboxRendererBase));
    private static final String PAGE_DIRECTION = "pageDirection";
    private static final String LINE_DIRECTION = "lineDirection";
    private static final String EXTERNAL_TRUE_VALUE = "true";
    static /* synthetic */ Class class$org$apache$myfaces$shared_impl$renderkit$html$HtmlCheckboxRendererBase;

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, null);
        if (uiComponent instanceof UISelectBoolean) {
            Boolean value = RendererUtils.getBooleanValue(uiComponent);
            boolean isChecked = value != null ? value : false;
            this.renderCheckbox(facesContext, uiComponent, EXTERNAL_TRUE_VALUE, null, false, isChecked, true);
        } else if (uiComponent instanceof UISelectMany) {
            this.renderCheckboxList(facesContext, (UISelectMany)uiComponent);
        } else {
            throw new IllegalArgumentException("Unsupported component class " + uiComponent.getClass().getName());
        }
    }

    public void renderCheckboxList(FacesContext facesContext, UISelectMany selectMany) throws IOException {
        boolean useSubmittedValues;
        Converter converter;
        String layout = this.getLayout(selectMany);
        boolean pageDirectionLayout = false;
        if (layout != null) {
            if (layout.equals(PAGE_DIRECTION)) {
                pageDirectionLayout = true;
            } else if (layout.equals(LINE_DIRECTION)) {
                pageDirectionLayout = false;
            } else {
                log.error((Object)("Wrong layout attribute for component " + selectMany.getClientId(facesContext) + ": " + layout));
            }
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("table", (UIComponent)selectMany);
        HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)selectMany, HTML.SELECT_TABLE_PASSTHROUGH_ATTRIBUTES);
        HtmlRendererUtils.writeIdIfNecessary(writer, (UIComponent)selectMany, facesContext);
        if (!pageDirectionLayout) {
            writer.startElement("tr", (UIComponent)selectMany);
        }
        try {
            converter = RendererUtils.findUISelectManyConverter(facesContext, selectMany);
        }
        catch (FacesException e) {
            log.error((Object)("Error finding Converter for component with id " + selectMany.getClientId(facesContext)));
            converter = null;
        }
        Set lookupSet = RendererUtils.getSubmittedValuesAsSet(facesContext, (UIComponent)selectMany, converter, selectMany);
        boolean bl = useSubmittedValues = lookupSet != null;
        if (!useSubmittedValues) {
            lookupSet = RendererUtils.getSelectedValuesAsSet(facesContext, (UIComponent)selectMany, converter, selectMany);
        }
        Iterator it = RendererUtils.getSelectItemList(selectMany).iterator();
        while (it.hasNext()) {
            SelectItem selectItem = (SelectItem)it.next();
            this.renderGroupOrItemCheckbox(facesContext, (UIComponent)selectMany, selectItem, useSubmittedValues, lookupSet, converter, pageDirectionLayout);
        }
        if (!pageDirectionLayout) {
            writer.endElement("tr");
        }
        writer.endElement("table");
    }

    protected String getLayout(UISelectMany selectMany) {
        if (selectMany instanceof HtmlSelectManyCheckbox) {
            return ((HtmlSelectManyCheckbox)selectMany).getLayout();
        }
        return (String)selectMany.getAttributes().get("layout");
    }

    protected void renderGroupOrItemCheckbox(FacesContext facesContext, UIComponent uiComponent, SelectItem selectItem, boolean useSubmittedValues, Set lookupSet, Converter converter, boolean pageDirectionLayout) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        boolean isSelectItemGroup = selectItem instanceof SelectItemGroup;
        Object itemValue = selectItem.getValue();
        UISelectMany selectMany = (UISelectMany)uiComponent;
        String itemStrValue = converter == null ? itemValue.toString() : converter.getAsString(facesContext, (UIComponent)selectMany, itemValue);
        if (isSelectItemGroup) {
            if (pageDirectionLayout) {
                writer.startElement("tr", (UIComponent)selectMany);
            }
            writer.startElement("td", (UIComponent)selectMany);
            writer.write(selectItem.getLabel());
            writer.endElement("td");
            if (pageDirectionLayout) {
                writer.endElement("tr");
                writer.startElement("tr", (UIComponent)selectMany);
            }
            writer.startElement("td", (UIComponent)selectMany);
            writer.startElement("table", (UIComponent)selectMany);
            writer.writeAttribute("border", (Object)"0", null);
            SelectItemGroup group = (SelectItemGroup)selectItem;
            SelectItem[] selectItems = group.getSelectItems();
            for (int i = 0; i < selectItems.length; ++i) {
                this.renderGroupOrItemCheckbox(facesContext, (UIComponent)selectMany, selectItems[i], useSubmittedValues, lookupSet, converter, pageDirectionLayout);
            }
            writer.endElement("td");
            writer.endElement("tr");
            writer.endElement("table");
            writer.endElement("td");
            if (pageDirectionLayout) {
                writer.endElement("tr");
            }
        } else {
            writer.write("\t\t");
            if (pageDirectionLayout) {
                writer.startElement("tr", (UIComponent)selectMany);
            }
            writer.startElement("td", (UIComponent)selectMany);
            writer.startElement("label", (UIComponent)selectMany);
            boolean checked = lookupSet.contains(itemStrValue);
            boolean disabled = selectItem.isDisabled();
            String labelClass = null;
            boolean componentDisabled = this.isDisabled(facesContext, (UIComponent)selectMany);
            labelClass = componentDisabled || disabled ? (String)selectMany.getAttributes().get("disabledClass") : (String)selectMany.getAttributes().get("enabledClass");
            if (labelClass != null) {
                writer.writeAttribute("class", (Object)labelClass, "labelClass");
            }
            this.renderCheckbox(facesContext, (UIComponent)selectMany, itemStrValue, selectItem.getLabel(), disabled, checked, false);
            writer.endElement("label");
            writer.endElement("td");
            if (pageDirectionLayout) {
                writer.endElement("tr");
            }
        }
    }

    protected void renderCheckbox(FacesContext facesContext, UIComponent uiComponent, String value, String label, boolean disabled, boolean checked, boolean renderId) throws IOException {
        String clientId = uiComponent.getClientId(facesContext);
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("input", uiComponent);
        writer.writeAttribute("type", (Object)"checkbox", null);
        writer.writeAttribute("name", (Object)clientId, null);
        if (renderId) {
            HtmlRendererUtils.writeIdIfNecessary(writer, uiComponent, facesContext);
        }
        if (checked) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (value != null && value.length() > 0) {
            writer.writeAttribute("value", (Object)value, null);
        }
        HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
        if (this.isDisabled(facesContext, uiComponent)) {
            writer.writeAttribute("disabled", (Object)Boolean.TRUE, null);
        }
        writer.writeText((Object)"", null);
        if (label != null && label.length() > 0) {
            writer.write("&#160;");
            writer.writeText((Object)label, null);
        }
    }

    protected boolean isDisabled(FacesContext facesContext, UIComponent component) {
        if (component instanceof HtmlSelectBooleanCheckbox) {
            return ((HtmlSelectBooleanCheckbox)component).isDisabled();
        }
        if (component instanceof HtmlSelectManyCheckbox) {
            return ((HtmlSelectManyCheckbox)component).isDisabled();
        }
        return RendererUtils.getBooleanAttribute(component, "disabled", false);
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        RendererUtils.checkParamValidity(facesContext, component, null);
        if (component instanceof UISelectBoolean) {
            HtmlRendererUtils.decodeUISelectBoolean(facesContext, component);
        } else if (component instanceof UISelectMany) {
            HtmlRendererUtils.decodeUISelectMany(facesContext, component);
        } else {
            throw new IllegalArgumentException("Unsupported component class " + component.getClass().getName());
        }
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent component, Object submittedValue) throws ConverterException {
        RendererUtils.checkParamValidity(facesContext, component, null);
        if (component instanceof UISelectBoolean) {
            return submittedValue;
        }
        if (component instanceof UISelectMany) {
            return RendererUtils.getConvertedUISelectManyValue(facesContext, (UISelectMany)component, submittedValue);
        }
        throw new IllegalArgumentException("Unsupported component class " + component.getClass().getName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

