/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.url;

import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.provider.LayeredFileName;
import org.apache.commons.vfs.provider.UriParser;

public class UrlFileName
extends LayeredFileName {
    public UrlFileName(String scheme, String zipFileUri, String path) {
        super(scheme, zipFileUri, path);
    }

    protected void appendRootUri(StringBuffer buffer) {
        buffer.append(this.getScheme());
        buffer.append(":");
        UriParser.appendEncoded(buffer, this.getOuterUri(), null);
    }

    protected FileName createName(String path) {
        return new UrlFileName(this.getScheme(), this.getOuterUri(), path);
    }

    public static UrlFileName parseUri(String uri) throws FileSystemException {
        StringBuffer name = new StringBuffer();
        String scheme = UriParser.extractScheme(uri, name);
        String zipUri = UrlFileName.extractZipName(name);
        UriParser.decode(name, 0, name.length());
        UriParser.normalisePath(name);
        String path = name.toString();
        return new UrlFileName(scheme, zipUri, path);
    }

    private static String extractZipName(StringBuffer uri) throws FileSystemException {
        return uri.substring(2);
    }
}

